/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#ifndef __FK_TREE_HEADER__
#define __FK_TREE_HEADER__

#include <string>
#include <list>
#include <iostream>

class fk_Tree;
class fk_TreeData;

class fk_TreeBaseObject {};

typedef std::list<fk_TreeData *>	fk_TList;

class fk_TreeData {

	friend class			fk_Tree;

 private:
	fk_TreeBaseObject		*object;
	fk_Tree					*base;
	std::string				name;
	fk_TreeData				*parent;
	fk_TList				children;
	int						depth, maxDepth;
	bool					deleteFlg;

	void					_calcMaxDepth(void);
	void					_addChild(fk_TreeData *);
 	void					_clearChild(fk_TreeData *);

 public:
	// コンストラクタ (ユーザは直接利用しない)
	fk_TreeData(fk_Tree *, const std::string, fk_TreeData *);
	// デストラクタ
	~fk_TreeData();

	// 該当データの深さ参照
	int						getDepth(void);

	// 該当データを枝としたときの最深度
	int						getMaxDepth(void);

	// 子データ参照, 引数 NULL で最初の要素, 以下順番に引数に入力
	fk_TreeData *			getChild(fk_TreeData *d);
	
	// 親データ参照
	fk_TreeData *			getParent(void);

	// 次の兄弟データ参照
	fk_TreeData *			getNext(void);

	// 前の兄弟データ参照
	fk_TreeData *			getPrev(void);

	// 兄弟中での順番参照
	int						getOrder(void);

	// 子データの個数参照
	int						getChildrenSize(void);

	// 名前参照
	std::string				getName(void);

	// ユーザデータの挿入 (デストラクタで同時に消去されたくない場合は,
	// 後ろの引数で false を選択)
	void					setObject(fk_TreeBaseObject *, bool = true);

	// ユーザデータ参照
	fk_TreeBaseObject *		getObject(void);

	void					print(void);
};

class fk_Tree {

 private:
	fk_TList		treeData;
	fk_TreeData		*root;

	void			_clear(void);
	void			_makeRoot(const std::string);
	void			_clearData(fk_TreeData *);
	fk_TreeData *	_simpleClone(fk_TreeData *, fk_TreeData *);
	int				_setDepth(fk_TreeData *, int);

 protected:

	virtual fk_TreeData *	makeNewData(fk_Tree *,
										const std::string, fk_TreeData *);


 public:
	// コンストラクタ, 引数に root データの名前
	fk_Tree(const std::string = "default");
	// デストラクタ
	virtual ~fk_Tree();

	// root データ参照
	fk_TreeData *	getRoot(void);

	// 現データを破棄し, n を新しい名前とする root データの再構築
	void			clear(const std::string n);

	// 子データの生成, 引数は p が親データ, n が子の名前
	fk_TreeData *	addNewChild(fk_TreeData *p, const std::string n);

	// d およびその下の枝の消去
	bool			deleteBranch(fk_TreeData *d);

	// d の子および子の下の枝の消去
	bool			clearChildren(fk_TreeData *d);

	// p の子として, d をコピーして生成。枝はコピーしない
	fk_TreeData *	cloneOneData(fk_TreeData *p, fk_TreeData *d);

	// p の子として, d をコピーして生成。枝も全てコピー
	fk_TreeData *	cloneBranch(fk_TreeData *p, fk_TreeData *d);

	// d を p の下に移動。p が d の枝にある場合は不可
	bool			moveBranch(fk_TreeData *p, fk_TreeData *d);

	// d の兄弟内での順番を n だけ前進。n が負ならば先頭へ
	void			toFront(int n, fk_TreeData *d);

	// d の兄弟内での順番を n だけ後退。n が負ならば最後尾へ
	void			toBack(int n, fk_TreeData *d);

	// d が該当の木の中で生存するデータかどうか判定
	bool			isArive(fk_TreeData *d);

	// nという名前のデータを検索
	fk_TreeData *	findData(const std::string n);

	fk_TreeData *	foreachData(fk_TreeData *);

	void			print(void);
};

#endif // !__FK_TREE_HEADER__
