/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include "TFK_PointBase.h"

TFK_PointBase::TFK_PointBase(void)
{
	model->setPointColor(0.0f, 0.0f, 0.0f);
	model->setSize(TFK_DEFAULT_POINT_SIZE);
	model->setDrawMode(FK_POINTMODE);
	model->setMaterialMode(FK_PARENT_MODE);
	model->setReverseDrawMode(true);
	solid->setMaterialMode(FK_PARENT_MODE);

	defaultSize = -1.0;
	return;
}

TFK_PointBase::~TFK_PointBase()
{
	delete solid;
	delete model;

	solid = (fk_Solid *)NULL;
	model = (fk_Model *)NULL;

	return;
}
	
int TFK_PointBase::create(fk_Vector argPos)
{
	fk_Vertex		*v;

	if(planeMode == true) argPos.z = 0.0;
	v = solid->makeVertex(argPos);

	if(defaultPalette != TFK_NULL_PALETTE) {
		v->setElemMaterialMode(FK_CHILD_MODE);
		v->setElemMaterialID(defaultPalette);
	}

	if(defaultSize > 0.0) {
		v->setDrawSize(defaultSize);
	}

	return GetMaskID(v->getID());

}

bool TFK_PointBase::move(int argID, fk_Vector argPos)
{
	fk_Vertex		*v = solid->getVData(GetTrueID(argID));

	if(v == (fk_Vertex *)NULL) return false;
	if(planeMode == true) argPos.z = 0.0;

	solid->moveVertex(v, argPos);
	return true;
}

bool TFK_PointBase::translate(int argID, fk_Vector argVec)
{
	fk_Vertex		*v = solid->getVData(GetTrueID(argID));
	fk_Vector		pos;

	if(v == (fk_Vertex *)NULL) return false;
	if(planeMode == true) argVec.z = 0.0;

	solid->moveVertex(v, getPos(argID) + argVec);
	return true;
}

bool TFK_PointBase::clear(int argID)
{
	fk_Vertex		*v;
	int				trueID = GetTrueID(argID);

	if(argID == -1) {
		solid->allClear(false);
		return true;
	}
	if(trueID < 0) return false;

	if((v = solid->getVData(trueID)) == (fk_Vertex *)NULL) return false;
	return solid->deleteVertex(v);
}

bool TFK_PointBase::changePalette(int argID, int argCID)
{
	fk_Vertex		*curV;
	int				trueID = GetTrueID(argID);

	if(argID == -1) {
		for(curV = solid->getNextV((fk_Vertex *)NULL);
			curV != (fk_Vertex *)NULL;
			curV = solid->getNextV(curV)) {
			curV->setElemMaterialMode(FK_CHILD_MODE);
			curV->setElemMaterialID(argCID);
		}
	} else if(trueID < 0) {
		return false;
	} else {
		if((curV = solid->getVData(trueID)) == (fk_Vertex *)NULL) {
			return false;
		}
		curV->setElemMaterialMode(FK_CHILD_MODE);
		curV->setElemMaterialID(argCID);
	}
	return true;
}

int TFK_PointBase::getPalette(int argID)
{
	fk_Vertex		*vertex;

	if((vertex = solid->getVData(GetTrueID(argID))) == (fk_Vertex *)NULL) {
		return -1;
	}

	return vertex->getElemMaterialID();
}

fk_Vector TFK_PointBase::getPos(int argID)
{
	fk_Vertex		*curV;
	fk_Vector		pos(0.0, 0.0, 0.0);

	if((curV = solid->getVData(GetTrueID(argID))) == (fk_Vertex *)NULL) {
		return pos;
	}

	return curV->getPosition();
}

bool TFK_PointBase::isArive(int argID)
{
	return solid->existVertex(GetTrueID(argID));
}

void TFK_PointBase::setSize(int argID, double argSize)
{
	fk_Vertex	*curV;
	int			trueID = GetTrueID(argID);

	if(argID == -1) {
		for(curV = solid->getNextV((fk_Vertex *)NULL);
			curV != (fk_Vertex *)NULL;
			curV = solid->getNextV(curV)) {
			curV->setDrawSize(argSize);
		}
	} else if(trueID < 0) {
		return;
	} else {
		if((curV = solid->getVData(trueID)) == (fk_Vertex *)NULL) {
			return;
		}
		curV->setDrawSize(argSize);
	}

	return;
}

double TFK_PointBase::getSize(int argID)
{
	fk_Vertex	*vertex;

	if((vertex = solid->getVData(GetTrueID(argID))) == (fk_Vertex *)NULL) {
		return 0.0;
	}

	return vertex->getDrawSize();
}

void TFK_PointBase::setDefaultSize(double argSize)
{
	defaultSize = argSize;
	return;
}
