/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2008, Watanabe Lab, School of Media Science,
 *	Tokyo University of Technology, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/
#include "TFK_PolygonBase.h"

using namespace std;

typedef vector<fk_Vector>::size_type	vsize;

TFK_PolygonBase::TFK_PolygonBase(void)
{
	fk_Material			mat;

	mat.setAmbient(0.0f, 0.0f, 0.0f);
	mat.setDiffuse(0.0f, 0.0f, 0.0f);
	mat.setSpecular(0.0f, 0.0f, 0.0f);
	mat.setEmission(0.0f, 0.0f, 0.0f);

	model->setMaterial(mat);
	model->setDrawMode(FK_FRONTBACK_POLYMODE);
	model->setMaterialMode(FK_PARENT_MODE);
	model->setReverseDrawMode(true);
	solid->setMaterialMode(FK_PARENT_MODE);

	return;
}

TFK_PolygonBase::~TFK_PolygonBase()
{
	delete solid;
	delete model;

	solid = (fk_Solid *)NULL;
	model = (fk_Model *)NULL;

	return;
}

void TFK_PolygonBase::AddVArray(fk_Loop *argL)
{
	vector<fk_Vertex *>		vArray;
	fk_Half					*firstH, *curH;

	if(argL == (fk_Loop *)NULL) return;

	firstH = argL->getOneHalf();
	vArray.push_back(firstH->getVertex());
	curH = firstH->getNextHalf();
	while(curH != firstH) {
		vArray.push_back(curH->getVertex());
		curH = curH->getNextHalf();
	}

	if(argL->getID() >= int(vArrayBase.size())) {
		vArrayBase.resize(argL->getID()+1);
	}

	vArrayBase[argL->getID()] = vArray;
	return;
}


int TFK_PolygonBase::create(int argVNum)
{
	vsize					i;
	fk_Vertex				*curV;
	vector<fk_Vertex *>		vArray;
	fk_Edge					*prevE;
	fk_Half					*nextH, *prevH, *lH, *rH, *nextH2, *prevH2;
	fk_Loop					*loop;
	fk_Vector				pos(0.0, 0.0, 0.0);

	if(argVNum < 3) return -1;

	vArray.clear();
	for(i = 0; i < vsize(argVNum); i++) {
		curV = solid->makeVertex(pos);
		vArray.push_back(curV);
	}

	if((prevE = solid->makeEdge(vArray[1], vArray[0])) == (fk_Edge *)NULL) {
		return -1;
	}

	for(i = 2; i < vArray.size(); i++) {
		lH = prevE->getLeftHalf();
		rH = prevE->getRightHalf();
		if(lH->getVertex() == vArray[i-1]) {
			prevH = rH;
			nextH = lH;
		} else {
			prevH = lH;
			nextH = rH;
		}

		if((prevE = solid->makeEdge(vArray[i-1], vArray[i],
									prevH, nextH)) == (fk_Edge *)NULL) {
			return -1;
		}
	}

	nextH = solid->getOneHOnV(vArray.back());
	prevH = solid->getMateHOnH(nextH);
	nextH2 = solid->getOneHOnV(vArray[0]);
	prevH2 = solid->getMateHOnH(nextH2);

	if((solid->makeEdge(vArray.back(), vArray[0], prevH,
						nextH, prevH2, nextH2)) == (fk_Edge *)NULL) {
		return -1;
	}

	if((loop = solid->makeLoop(prevH)) == (fk_Loop *)NULL) {
		return -1;
	}

	AddVArray(loop);

	if(defaultPalette != TFK_NULL_PALETTE) {
		loop->setElemMaterialMode(FK_CHILD_MODE);
		loop->setElemMaterialID(defaultPalette);
	}

	return GetMaskID(loop->getID());
}

bool TFK_PolygonBase::move(int argID, int argVID, fk_Vector argP)
{
	int		trueID = GetTrueID(argID);

	if(solid->getLData(trueID) == (fk_Loop *)NULL) return false;
	if(argVID < 0 || int(vArrayBase[trueID].size()) <= argVID) return false;
	if(planeMode == true) argP.z = 0.0;
	solid->moveVertex(vArrayBase[trueID][argVID], argP);
	return true;
}

bool TFK_PolygonBase::translate(int argID, fk_Vector argP)
{
	vector<fk_Vertex *>::size_type		i;
	int									trueID = GetTrueID(argID);

	if(solid->getLData(trueID) == (fk_Loop *)NULL) return false;
	
	if(planeMode == true) argP.z = 0.0;
	for(i = 0; i < vArrayBase[trueID].size(); i++) {
		solid->moveVertex(vArrayBase[trueID][i],
						  vArrayBase[trueID][i]->getPosition() + argP);
	}

	return true;
}

bool TFK_PolygonBase::clear(int argID)
{
	fk_Loop							*loop;
	vector<fk_Edge *>				eArray;
	vector<fk_Edge *>::size_type	i;
	vector<fk_Vertex *>::size_type	j;
	int								trueID = GetTrueID(argID);

	if(argID == -1) {
		solid->allClear(false);
		vArrayBase.clear();
		return true;
	}
	if(trueID < 0) return false;

	if((loop = solid->getLData(trueID)) == (fk_Loop *)NULL) return false;
	eArray = solid->getAllEOnL(loop);
	if(solid->deleteLoop(loop) == false) return false;
	for(i = 0; i < eArray.size(); i++) {
		if(solid->deleteEdge(eArray[i]) == false) return false;
	}

	for(j = 0; j < vArrayBase[trueID].size(); j++) {
		if(solid->deleteVertex(vArrayBase[trueID][j]) == false) {
			return false;
		}
	}
	vArrayBase[trueID].clear();
	return true;
}

bool TFK_PolygonBase::changePalette(int argID, int argCID)
{
	fk_Loop			*curL;
	int				trueID = GetTrueID(argID);

	if(argID == -1) {
		for(curL = solid->getNextL((fk_Loop *)NULL);
			curL != (fk_Loop *)NULL;
			curL = solid->getNextL(curL)) {
			curL->setElemMaterialMode(FK_CHILD_MODE);
			curL->setElemMaterialID(argCID);
		}
	} else if(trueID < 0) {
		return false;
	} else {
		if((curL = solid->getLData(trueID)) == (fk_Loop *)NULL) {
			return false;
		}
		curL->setElemMaterialMode(FK_CHILD_MODE);
		curL->setElemMaterialID(argCID);
	}
	return true;
}

int TFK_PolygonBase::getPalette(int argID)
{
	fk_Loop			*loop;

	if((loop = solid->getLData(GetTrueID(argID))) == (fk_Loop *)NULL) {
		return -1;
	}

	return loop->getElemMaterialID();
}

int TFK_PolygonBase::getVertexNum(int argID)
{
	int			trueID = GetTrueID(argID);

	if(solid->existLoop(trueID) == false) return -1;
	return int(vArrayBase[trueID].size());
}

fk_Vector TFK_PolygonBase::getVertexPos(int argID, int argVID)
{
	fk_Vector	tmp(0.0, 0.0, 0.0);
	int			trueID = GetTrueID(argID);

	if(solid->existLoop(trueID) == false) return tmp;
	if(argVID < 0 || argVID >= int(vArrayBase[trueID].size())) return tmp;
	return vArrayBase[trueID][argVID]->getPosition();
}

bool TFK_PolygonBase::isArive(int argID)
{
	return solid->existLoop(GetTrueID(argID));
}

bool TFK_PolygonBase::loadData(FILE *argFP, fk_DataFormatMode argMode,
							   bool argSizeMode)
{
	fk_Loop			*curL;

	if(TFK_UniShapeBase::loadData(argFP, argMode, argSizeMode) == false) {
		return false;
	}

	vArrayBase.clear();
	curL = solid->getNextL((fk_Loop *)NULL);
	if(curL != (fk_Loop *)NULL) {
		AddVArray(curL);
		curL = solid->getNextL(curL);
	}
		
	generation++;
	return true;
}
