/****************************************************************************
 *
 *	Copyright (c) 1999-2011, Fine Kernel Project, All rights reserved.
 *
 *	Redistribution and use in source and binary forms,
 *	with or without modification, are permitted provided that the
 *	following conditions are met:
 *
 *		- Redistributions of source code must retain the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer.
 *
 *		- Redistributions in binary form must reproduce the above
 *			copyright notice, this list of conditions and the
 *			following disclaimer in the documentation and/or
 *			other materials provided with the distribution.
 *
 *		- Neither the name of the copyright holders nor the names
 *			of its contributors may be used to endorse or promote
 *			products derived from this software without specific
 *			prior written permission.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 *	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *	POSSIBILITY OF SUCH DAMAGE. 
 *
 ****************************************************************************/
/****************************************************************************
 *
 *	Copyright (c) 1999-2011, Fine Kernel Project, All rights reserved.
 *
 *	本ソフトウェアおよびソースコードのライセンスは、基本的に
 *	「修正 BSD ライセンス」に従います。以下にその詳細を記します。
 *
 *	ソースコード形式かバイナリ形式か、変更するかしないかを問わず、
 *	以下の条件を満たす場合に限り、再頒布および使用が許可されます。
 *
 *	- ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、
 *		および下記免責条項を含めること。
 *
 *	- バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の
 *		資料に、上記の著作権表示、本条件一覧、および下記免責条項を
 *		含めること。
 *
 *	- 書面による特別の許可なしに、本ソフトウェアから派生した製品の
 *		宣伝または販売促進に、本ソフトウェアの著作権者の名前または
 *		コントリビューターの名前を使用してはならない。
 *
 *	本ソフトウェアは、著作権者およびコントリビューターによって「現
 *	状のまま」提供されており、明示黙示を問わず、商業的な使用可能性、
 *	および特定の目的に対する適合性に関す暗黙の保証も含め、またそれ
 *	に限定されない、いかなる保証もないものとします。著作権者もコン
 *	トリビューターも、事由のいかんを問わず、損害発生の原因いかんを
 *	問わず、かつ責任の根拠が契約であるか厳格責任であるか(過失その
 *	他の)不法行為であるかを問わず、仮にそのような損害が発生する可
 *	能性を知らされていたとしても、本ソフトウェアの使用によって発生
 *	した(代替品または代用サービスの調達、使用の喪失、データの喪失、
 *	利益の喪失、業務の中断も含め、またそれに限定されない)直接損害、
 *	間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 *	ついて、一切責任を負わないものとします。
 *
 ****************************************************************************/

#define FK_DEF_SIZETYPE
#include <FK/FileOutput.H>
#include <FK/DataBase.H>
#include <FK/Palette.h>
#include <FK/Vertex.h>
#include <FK/Half.h>
#include <FK/Edge.h>
#include <FK/Loop.h>

using namespace std;

fk_FileOutput::fk_FileOutput(void)
{
	DB = NULL;
	palette = NULL;
	sizeMode = true;
	return;
}

fk_FileOutput::~fk_FileOutput()
{
	return;
}

void fk_FileOutput::SetDataBase(fk_DataBase *argDB)
{
	DB = argDB;
	return;
}

void fk_FileOutput::SetPalette(fk_Palette *argPal)
{
	palette = argPal;
	return;
}

bool fk_FileOutput::PutShapeData(string argFileName, fk_DataFormatMode argMode)
{
	FILE			*fp;

	switch(argMode) {
	  case FK_TEXT_FILE:
		fp = fopen(argFileName.c_str(), "w");
		break;

	  case FK_BINARY_FILE:
		fp = fopen(argFileName.c_str(), "wb");
		break;

	  default:
		return false;
	}

	if(fp == NULL) {
		return false;
	}

	PutHeader(argMode, fp);
	if(PutShapeData_(argMode, fp) == false) {
		fclose(fp);
		return false;
	}

	fclose(fp);
	return true;
}	
	
bool fk_FileOutput::PutShapeData(FILE *argFP, fk_DataFormatMode argMode)
{
	return PutShapeData_(argMode, argFP);
}

bool fk_FileOutput::PutPaletteData(string argFileName,
								   fk_DataFormatMode argMode)
{
	FILE			*fp;

	switch(argMode) {
	  case FK_TEXT_FILE:
		fp = fopen(argFileName.c_str(), "w");
		break;

	  case FK_BINARY_FILE:
		fp = fopen(argFileName.c_str(), "wb");
		break;

	  default:
		return false;
	}

	if(fp == NULL) {
		return false;
	}

	PutHeader(argMode, fp);
	if(PutPaletteData_(argMode, fp) == false) {
		fclose(fp);
		return false;
	}

	fclose(fp);
	return true;
}	
	
bool fk_FileOutput::PutPaletteData(FILE *argFP, fk_DataFormatMode argMode)
{
	return PutPaletteData_(argMode, argFP);
}

void fk_FileOutput::PutHeader(fk_DataFormatMode argMode, FILE *argFP)
{
	int buffer[4];
	
	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "$FK_DATA_FILE$\n");
		fprintf(argFP, "$VER: %d %d %d $\n",
				FK_FILE_CURRENT_MAJOR_VERSION,
				FK_FILE_CURRENT_MINOR_VERSION,
				FK_FILE_CURRENT_SUBMINOR_VERSION);

		return;

	  case FK_BINARY_FILE:
		
		buffer[0] = FK_FILE_MASK;
		buffer[1] = FK_FILE_CURRENT_MAJOR_VERSION;
		buffer[2] = FK_FILE_CURRENT_MINOR_VERSION;
		buffer[3] = FK_FILE_CURRENT_SUBMINOR_VERSION;
		
		BWrite(buffer, 4, argFP);
		return;

	  default:
		break;
	}
	return;
}

bool fk_FileOutput::PutShapeData_(fk_DataFormatMode argMode, FILE *argFP)
{
	_st		i, vSize, hSize, eSize, lSize;
	int		setSize[5];

	vSize = DB->vSet.size();
	hSize = DB->hSet.size();
	eSize = DB->eSet.size();
	lSize = DB->lSet.size();
	
	setSize[0] = int(vSize);
	setSize[1] = int(hSize);
	setSize[2] = int(eSize);
	setSize[3] = int(lSize);
	setSize[4] = 0;

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "num\t%d\t%d\t%d\t%d\n",
				setSize[0], setSize[1], setSize[2], setSize[3]);
		break;

	  case FK_BINARY_FILE:

		BWrite(setSize, 5, argFP);
		break;

	  default:
		return false;
	}

	if(argMode == FK_TEXT_FILE) fprintf(argFP, "vData\n");
	for(i = 0; i < vSize; i++) {
		PutVertexData(argMode, argFP, DB->vSet[i]);
	}

	if(argMode == FK_TEXT_FILE) fprintf(argFP, "hData\n");
	for(i = 0; i < hSize; i++) {
		PutHalfData(argMode, argFP, DB->hSet[i]);
	}

	if(argMode == FK_TEXT_FILE) fprintf(argFP, "eData\n");
	for(i = 0; i < eSize; i++) {
		PutEdgeData(argMode, argFP, DB->eSet[i]);
	}

	if(argMode == FK_TEXT_FILE) fprintf(argFP, "lData\n");
	for(i = 0; i < lSize; i++) {
		PutLoopData(argMode, argFP, DB->lSet[i]);
	}

	PutAdminDataFile(argMode, argFP, &(DB->vAdmin), "vadmin");
	PutAdminDataFile(argMode, argFP, &(DB->hAdmin), "hadmin");
	PutAdminDataFile(argMode, argFP, &(DB->eAdmin), "eadmin");
	PutAdminDataFile(argMode, argFP, &(DB->lAdmin), "ladmin");

	return true;
}


void fk_FileOutput::PutVertexData(fk_DataFormatMode argMode,
								  FILE *argFP, fk_Vertex *argV)
{
	fk_Vector	position;
	int			IDSet[3];
	double		pos[3], size;

	IDSet[0] = argV->getElemMaterialID();
	IDSet[1] = argV->getElemMaterialMode();

	if(argV->getOneHalf() != NULL) {
		IDSet[2] = argV->getOneHalf()->getID();
	} else {
		IDSet[2] = FK_UNDEFINED;
	}

	position = argV->getPosition();
	pos[0] = position.x;
	pos[1] = position.y;
	pos[2] = position.z;
	size = argV->getDrawSize();

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "\tv\t%d\t%d\t%d\t%d\t%g %g %g",
				argV->getID(), IDSet[0], IDSet[1], IDSet[2],
				pos[0], pos[1], pos[2]);
		if(sizeMode == true) {
			fprintf(argFP, " %g", size);
		}
		fprintf(argFP, "\n");
		break;
		
	  case FK_BINARY_FILE:
		
		BWrite(IDSet, 3, argFP);
		BWrite(pos, 3, argFP);
		if(sizeMode == true) {
			BWrite(&size, 1, argFP);
		}
		
		break;
		
	  default:
		break;
	}

	return;
}

void fk_FileOutput::PutHalfData(fk_DataFormatMode argMode,
								FILE *argFP, fk_Half *argH)
{
	int			nHID, pHID, pLID;
	fk_Half		*nH;
	fk_Half		*pH;
	fk_Loop		*pL;
	fk_Vertex	*v;
	int			IDSet[4];

	nHID = pHID = pLID = FK_UNDEFINED;
	nH = argH->getNextHalf();
	pH = argH->getPrevHalf();
	pL = argH->getParentLoop();
	v = argH->getVertex();

	if(nH != NULL) {
		nHID = nH->getID();
	}
	if(pH != NULL) {
		pHID = pH->getID();
	}
	if(pL != NULL) {
		pLID = pL->getID();
	}

	IDSet[0] = v->getID();
	IDSet[1] = nHID;
	IDSet[2] = pHID;
	IDSet[3] = pLID;

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "\th\t%d\t%d\t%d\t%d\t%d\n",
				argH->getID(), IDSet[0], IDSet[1], IDSet[2], IDSet[3]);
		break;
		
	  case FK_BINARY_FILE:		
		
		BWrite(IDSet, 4, argFP);
		break;
		
	  default:
		break;
	}

	return;
}

void fk_FileOutput::PutEdgeData(fk_DataFormatMode argMode,
								FILE *argFP, fk_Edge *argE)
{
	fk_Half		*lH, *rH;
	int			IDSet[4];
	double		width;

	lH = argE->getLeftHalf();
	rH = argE->getRightHalf();

	IDSet[0] = argE->getElemMaterialID();
	IDSet[1] = argE->getElemMaterialMode();
	IDSet[2] = lH->getID();
	IDSet[3] = rH->getID();
	width = argE->getDrawWidth();

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "\te\t%d\t%d\t%d\t%d\t%d",
				argE->getID(), IDSet[0], IDSet[1], IDSet[2], IDSet[3]);
		if(sizeMode == true) {
			fprintf(argFP, " %g", width);
		}
		fprintf(argFP, "\n");
		break;
		
	  case FK_BINARY_FILE:
		
		BWrite(IDSet, 4, argFP);
		if(sizeMode == true) {
			BWrite(&width, 1, argFP);
		}
		break;
		
	  default:
		break;
	}

	return;
}

void fk_FileOutput::PutLoopData(fk_DataFormatMode argMode,
								FILE *argFP, fk_Loop *argL)
{
	fk_Half		*h;
	int			oneHID = FK_UNDEFINED;
	int			IDSet[3];

	h = argL->getOneHalf();
	if(h != NULL) {
		oneHID = h->getID();
	}

	IDSet[0] = argL->getElemMaterialID();
	IDSet[1] = argL->getElemMaterialMode();
	IDSet[2] = oneHID;

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "\tl\t%d\t%d\t%d\t%d\n",
				argL->getID(), IDSet[0], IDSet[1], IDSet[2]);
		break;
		
	  case FK_BINARY_FILE:
		
		BWrite(IDSet, 3, argFP);
		break;
		
	  default:
		break;
	}

	return;
}

bool fk_FileOutput::PutAdminDataFile(fk_DataFormatMode argMode,
									 FILE *argFP, fk_IDAdmin *argAdmin,
									 const string &argTag)
{
	_st						eraseIDSize;
	int						*listArray = NULL;
	int						i;
	list<int>::iterator		listP;

	eraseIDSize = argAdmin->eraseIDSet->size();
	if(eraseIDSize > 0) {
		listArray = new int [eraseIDSize];
	}

	i = 0;
	for(listP = argAdmin->eraseIDSet->begin();
		listP != argAdmin->eraseIDSet->end(); ++listP) {
		listArray[i] = *listP;
		i++;
	}

	PutAdminHeader(argMode, argFP, argAdmin, argTag);
	PutAdminEraseList(argMode, argFP, listArray, int(eraseIDSize));

	delete [] listArray;

	return true;
}

void fk_FileOutput::PutAdminHeader(fk_DataFormatMode argMode,
								   FILE *argFP, fk_IDAdmin *argAdmin,
								   const string &argTag)
{
	int		sizeSet[2];

	sizeSet[0] = int(argAdmin->eraseIDSet->size());
	sizeSet[1] = int(argAdmin->existFlagSet.size());

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "%s\n", argTag.c_str());
		fprintf(argFP, "\t%d\t%d\n", sizeSet[0], sizeSet[1]);
		break;
		
	  case FK_BINARY_FILE:
		
		BWrite(sizeSet, 2, argFP);
		break;
		
	  default:
		break;
	}

	return;
}

void fk_FileOutput::PutAdminEraseList(fk_DataFormatMode argMode, FILE *argFP,
									  int *argArray, int argSize)
{
	int		i;

	switch(argMode) {
	  case FK_TEXT_FILE:
		for(i = 0; i < argSize; i++) {
			fprintf(argFP, "\t\t%d\n", argArray[i]);
		}
		break;
		
	  case FK_BINARY_FILE:
		if(argSize != 0) {
			BWrite(argArray, size_t(argSize), argFP);
		}
		break;
		
	  default:
		break;
	}

	return;
}

bool fk_FileOutput::PutPaletteData_(fk_DataFormatMode argMode, FILE *argFP)
{
	unsigned int			i;
	vector<fk_Material>		*matVec;
	int						valueSet[2];
	fk_Material				dummyMat;


	matVec = palette->getMaterialVector();

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "mat\t%d\t%d\n",
				palette->getObjMaterialID(), int(matVec->size()));

		if(PutMaterialData(FK_TEXT_FILE, argFP, &dummyMat) == false) {
			return false;
		}

		for(i = 0; i < matVec->size(); i++) {
			if(PutMaterialData(FK_TEXT_FILE, argFP,
							   &((*matVec)[i])) == false) {
				return false;
			}
		}

		break;

	  case FK_BINARY_FILE:
		valueSet[0] = palette->getObjMaterialID();
		valueSet[1] = static_cast<int>(matVec->size());

		BWrite(valueSet, 2, argFP);

		if(PutMaterialData(FK_BINARY_FILE, argFP, &dummyMat) == false) {
			return false;
		}

		for(i = 0; i < matVec->size(); i++) {
			if(PutMaterialData(FK_BINARY_FILE, argFP,
							   &((*matVec)[i])) == false) {
				return false;
			}
		}

		break;

	  default:
		return false;
	}

	return true;
}

bool fk_FileOutput::PutMaterialData(fk_DataFormatMode argMode, FILE *argFP,
									fk_Material *argMat)
{
	fk_Color		*col;
	float			value;
	float			colArray[12];

	switch(argMode) {
	  case FK_TEXT_FILE:
		fprintf(argFP, "\talpha\t%g\n", argMat->getAlpha());

		col = argMat->getAmbient();
		fprintf(argFP, "\tamb\t%g\t%g\t%g\n",
				col->col[0], col->col[1], col->col[2]);

		col = argMat->getDiffuse();
		fprintf(argFP, "\tdiff\t%g\t%g\t%g\n",
				col->col[0], col->col[1], col->col[2]);

		col = argMat->getSpecular();
		fprintf(argFP, "\tspec\t%g\t%g\t%g\n",
				col->col[0], col->col[1], col->col[2]);

		col = argMat->getEmission();
		fprintf(argFP, "\temis\t%g\t%g\t%g\n",
				col->col[0], col->col[1], col->col[2]);

		fprintf(argFP, "\tshini\t%g\n", argMat->getShininess());

		break;

	  case FK_BINARY_FILE:
		value = argMat->getAlpha();
		if(BWrite(&value, 1, argFP) != 1) return false;

		for(int i = 0; i < 3; i++) {
			colArray[i] = argMat->getAmbient()->col[i];
			colArray[i+3] = argMat->getDiffuse()->col[i];
			colArray[i+6] = argMat->getSpecular()->col[i];
			colArray[i+9] = argMat->getEmission()->col[i];
		}
		
		if(BWrite(colArray, 12, argFP) == false) return false;
		
		value = argMat->getShininess();
		if(BWrite(&value, 1, argFP) != 1) return false;

		break;

	  default:
		return false;

	}

	return true;
}

void fk_FileOutput::SetSizeMode(bool argMode)
{
	sizeMode = argMode;
	return;
}
