/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.plugin.internal;

import com.small_it_office.flatserve.core.InfrastructureException;
import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginImplementation;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.request.internal.RequestParameterReader;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.flatserve.core.service.internal.HttpServiceExecutor;
import com.small_it_office.flatserve.core.service.internal.HttpServiceFactory;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private static final String KEY_PLUGIN_CLASS = "plugin.class";
    private static final String KEY_PLUGIN_IMPLEMENTATION_CLASS = "plugin.implementation_class";
    private Map<Class<? extends PluginPart>, PluginPart> pluginParts = new HashMap<Class<? extends PluginPart>, PluginPart>();
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());
    private Config config;

    public PluginLoader(Config config) {
        this.config = config;
        this.init();
    }

    private void init() {
        List<String> pluginDefs = this.loadPluginProperties();
        List<PluginImplementation> pluginImplementations = this.createPluginImplementationInstances(pluginDefs);
        ArrayList<RequestParameterReader> readers = new ArrayList<RequestParameterReader>();
        ArrayList<HttpServiceFactory> factories = new ArrayList<HttpServiceFactory>();
        ArrayList<HttpServiceExecutor> executors = new ArrayList<HttpServiceExecutor>();
        ArrayList<ResponseSender> senders = new ArrayList<ResponseSender>();
        for (PluginImplementation p : pluginImplementations) {
            p.init(this.config);
            readers.add(p.getRequestParameterReader());
            factories.add(p.getHttpServiceFactory());
            executors.add(p.getHttpServiceExecutor());
            senders.add(p.getResponseSender());
        }
        Comparator<PluginPart> comparator = this.pluginPriorityComparator();
        Collections.sort(readers, comparator);
        Collections.sort(factories, comparator);
        Collections.sort(executors, comparator);
        Collections.sort(senders, comparator);
        this.setUpPluginInstance(RequestParameterReader.class, readers);
        this.setUpPluginInstance(HttpServiceFactory.class, factories);
        this.setUpPluginInstance(HttpServiceExecutor.class, executors);
        this.setUpPluginInstance(ResponseSender.class, senders);
    }

    private List<String> loadPluginProperties() {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            resources = loader.getResources("META-INF/flatserveplugin.properties");
        }
        catch (IOException e) {
            throw new InfrastructureException(e);
        }
        ArrayList<String> plugins = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Properties props = new Properties();
            try {
                props.load(url.openStream());
            }
            catch (IOException e) {
                throw new InfrastructureException(e);
            }
            String pluginImplementation = props.getProperty(KEY_PLUGIN_IMPLEMENTATION_CLASS);
            String plugin = props.getProperty(KEY_PLUGIN_CLASS);
            if (!this.config.isPluginAutoDetect() && (!this.config.isAvailablePlugin(plugin) || pluginImplementation == null)) continue;
            plugins.add(pluginImplementation);
        }
        return plugins;
    }

    private List<PluginImplementation> createPluginImplementationInstances(List<String> pluginDefs) {
        ArrayList<PluginImplementation> pluginImplementations = new ArrayList<PluginImplementation>();
        for (String pluginDef : pluginDefs) {
            Object instance;
            Class<?> clazz;
            this.logger.debug("FS-LOGD038", pluginDef);
            try {
                clazz = Class.forName(pluginDef);
            }
            catch (ClassNotFoundException e) {
                throw new UnexpectedException(e);
            }
            try {
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
            pluginImplementations.add((PluginImplementation)PluginImplementation.class.cast(instance));
        }
        return pluginImplementations;
    }

    private Comparator<PluginPart> pluginPriorityComparator() {
        Comparator<PluginPart> comparator = new Comparator<PluginPart>(){

            @Override
            public int compare(PluginPart p1, PluginPart p2) {
                if (p1 == null && p2 == null) {
                    return 0;
                }
                if (p1 == null) {
                    return 1;
                }
                if (p2 == null) {
                    return -1;
                }
                return p1.priority() - p2.priority();
            }
        };
        return comparator;
    }

    private <T extends PluginPart> void setUpPluginInstance(Class<T> pluginInterface, List<T> pluginPartList) {
        this.logger.debug("FS-LOGD040", pluginInterface.getSimpleName(), ((PluginPart)pluginPartList.get(0)).getClass().getName());
        for (int i = 0; i < pluginPartList.size(); ++i) {
            PluginPart part = (PluginPart)pluginPartList.get(i);
            if (!part.nest()) {
                part.init(this.config);
                break;
            }
            this.logger.debug("FS-LOGD039", part.getClass().getName(), ((PluginPart)pluginPartList.get(i + 1)).getClass().getName());
            part.setNestedObject((PluginPart)pluginPartList.get(i + 1));
            part.init(this.config);
        }
        this.pluginParts.put((Class<? extends PluginPart>)pluginInterface, (PluginPart)pluginPartList.get(0));
    }

    public <T extends PluginPart> T load(Class<T> clazz) {
        PluginPart result = (PluginPart)clazz.cast(this.pluginParts.get(clazz));
        return (T)result;
    }
}

