/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.request.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.ParameterMappingException;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapping;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanParameterMapping
implements RequestParameterMapping {
    private Class<?> beanType;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public BeanParameterMapping(Class<?> beanType) {
        this.beanType = beanType;
    }

    @Override
    public Object mapParameter(RequestContext context, Annotation[] annotations) {
        Object bean;
        this.logger.debug("FS-LOGD020", this.beanType.getName(), this.getClass().getSimpleName());
        try {
            bean = this.beanType.newInstance();
        }
        catch (Exception e) {
            throw new ParameterMappingException(Message.get("FS-ERR012", this.beanType.getName()), e);
        }
        this.logger.debug("FS-LOGD021", bean.getClass().getName());
        this.populate(bean, this.castMap(context.getHttpServletRequest().getParameterMap()));
        this.logger.debug("FS-LOGD022", bean.getClass().getName());
        return bean;
    }

    private Map<String, String[]> castMap(Map map) {
        return map;
    }

    void populate(Object bean, Map<String, String[]> params) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = this.beanType; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            fields.addAll(Arrays.asList(fieldArray));
        }
        for (Field field : fields) {
            Param annotation = field.getAnnotation(Param.class);
            String requestParamName = annotation == null ? field.getName() : annotation.value();
            String[] paramValues = params.get(requestParamName);
            if (paramValues == null) {
                this.processNullParameter(bean, field, requestParamName);
                continue;
            }
            field.setAccessible(true);
            try {
                this.setValueToField(bean, field, requestParamName, paramValues);
            }
            catch (Exception e) {
                throw new UnexpectedException(e);
            }
        }
    }

    protected void processNullParameter(Object bean, Field field, String requestParamName) {
        this.logger.debug("FS-LOGD023", field.getName(), requestParamName);
    }

    protected void setValueToField(Object bean, Field field, String requestParamName, String[] paramValues) throws IllegalAccessException {
        if (field.getType() == String.class) {
            field.set(bean, paramValues[0]);
            this.logger.debug("FS-LOGD024", field.getName(), requestParamName);
        } else if (field.getType() == String[].class) {
            field.set(bean, paramValues);
            this.logger.debug("FS-LOGD024", field.getName(), requestParamName);
        } else {
            this.logger.debug("FS-LOGD037", field.getName(), requestParamName);
        }
    }

    protected Class<?> getBeanType() {
        return this.beanType;
    }
}

