/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.response;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.AbstractResponse;
import com.small_it_office.flatserve.core.response.ResponseFailException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ForwardResponse
extends AbstractResponse {
    private String forwardPath;
    private Map<String, Object> requestScope = new HashMap<String, Object>();
    private Map<String, Object> sessionScope = new HashMap<String, Object>();
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public ForwardResponse(String path) {
        this.forwardPath = path;
    }

    protected String getContentType() {
        return null;
    }

    protected void writeResponse(RequestContext context) throws IOException {
        HttpServletRequest request = context.getHttpServletRequest();
        HttpServletResponse response = context.getHttpServletResponse();
        Set<String> rKeys = this.requestScope.keySet();
        for (String key : rKeys) {
            request.setAttribute(key, this.requestScope.get(key));
        }
        Set<String> sKeys = this.sessionScope.keySet();
        for (String key : sKeys) {
            request.getSession().setAttribute(key, this.sessionScope.get(key));
        }
        this.logger.debug("FS-LOGD033", this.forwardPath);
        RequestDispatcher rd = request.getRequestDispatcher(this.forwardPath);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new ResponseFailException("FS-ERR016", e);
        }
    }

    public void setRequestScope(String key, Object o) {
        this.requestScope.put(key, o);
    }

    public void setSessionScope(String key, Object o) {
        this.sessionScope.put(key, o);
    }
}

