/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.response.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.response.AbstractResponse;
import com.small_it_office.flatserve.core.response.ResponseFailException;
import com.small_it_office.flatserve.core.response.internal.ResponseSender;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

public class ResponseSenderImpl
implements ResponseSender {
    private static final int PLUGIN_PRIORITY = 1024;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public void process(RequestContext context, Object responseObject) throws IOException {
        if (responseObject == null) {
            this.logger.debug("FS-LOGD035", new Object[0]);
            return;
        }
        HttpServletResponse response = context.getHttpServletResponse();
        this.logger.debug("FS-LOGD036", responseObject.getClass().getName());
        if (responseObject instanceof String) {
            String textRes = (String)responseObject;
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            PrintWriter out = response.getWriter();
            out.write(textRes);
        } else if (responseObject instanceof byte[]) {
            response.setContentType("application/octet-stream");
            response.getOutputStream().write((byte[])responseObject);
        } else if (responseObject instanceof AbstractResponse) {
            AbstractResponse webResponse = (AbstractResponse)responseObject;
            webResponse.sendResponse(context);
        } else {
            throw new ResponseFailException(Message.get("FS-ERR018", responseObject.getClass().getName()));
        }
        response.flushBuffer();
    }

    public boolean nest() {
        return false;
    }

    public void setNestedObject(PluginPart o) {
    }

    public void init(Config config) {
    }

    public int priority() {
        return 1024;
    }
}

