/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.core.service.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.service.HttpService;
import com.small_it_office.flatserve.core.service.IllegalHttpServiceException;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import com.small_it_office.shared.meslog.message.Message;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceResolver {
    private Class<?> serviceClass;
    private Method serviceMethod;
    private boolean sessionSynchronized;
    private Config config;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public HttpServiceResolver(Config config) {
        this.config = config;
    }

    public void resolveURI(String path, String contextPath) {
        String methodName;
        String pathWithoutContextRoot;
        this.logger.debug("FS-LOGD004", path);
        if (path.startsWith(contextPath)) {
            pathWithoutContextRoot = path.substring(contextPath.length() + 1);
        } else {
            pathWithoutContextRoot = path.substring(1);
            this.logger.warn("FS-LOGW001", path, contextPath);
        }
        int lastSlashIndex = pathWithoutContextRoot.lastIndexOf("/");
        int lastDotIndex = pathWithoutContextRoot.lastIndexOf(".");
        String pathWithoutExtention = lastSlashIndex < lastDotIndex ? pathWithoutContextRoot.substring(0, lastDotIndex) : pathWithoutContextRoot;
        if (pathWithoutExtention.endsWith("/")) {
            this.logger.debug("FS-LOGD005", path);
            return;
        }
        this.serviceClass = this.config.pathToClass(pathWithoutExtention);
        if (this.serviceClass == null) {
            String pathWithoutMethod;
            this.logger.debug("FS-LOGD006", path);
            methodName = pathWithoutExtention.substring(pathWithoutExtention.lastIndexOf("/") + 1);
            if (pathWithoutExtention.length() > methodName.length() && Character.isLowerCase(methodName.charAt(0))) {
                pathWithoutMethod = pathWithoutExtention.substring(0, pathWithoutExtention.indexOf(methodName) - 1);
                this.logger.debug("FS-LOGD007", methodName, pathWithoutMethod);
            } else {
                this.logger.debug("FS-LOGD008", path);
                methodName = "execute";
                pathWithoutMethod = pathWithoutExtention;
            }
            this.serviceClass = this.createServiceClass(pathWithoutMethod);
        } else {
            this.logger.debug("FS-LOGD009", path);
            methodName = "execute";
        }
        if (this.serviceClass == null) {
            this.logger.debug("FS-LOGD014", new Object[0]);
        } else {
            this.logger.debug("FS-LOGD010", this.serviceClass.getName(), methodName);
            this.serviceMethod = this.reflectTargetMethod(methodName, this.serviceClass);
            if (this.serviceMethod != null) {
                this.sessionSynchronized = this.serviceMethod.getAnnotation(HttpService.class).sessionSynchronized();
            }
        }
    }

    private Class<?> createServiceClass(String pathWithoutMethod) {
        Class<?> result = this.config.pathToClass(pathWithoutMethod);
        if (result == null) {
            String className;
            this.logger.debug("FS-LOGD011", pathWithoutMethod);
            String packageFromPath = pathWithoutMethod.replaceAll("/", ".");
            String packageHeadName = this.config.getPackageHeadName();
            if (packageHeadName == null) {
                className = packageFromPath;
            } else {
                this.logger.debug("FS-LOGD012", packageFromPath, packageHeadName);
                className = packageHeadName + "." + packageFromPath;
            }
            this.logger.debug("FS-LOGD013", className);
            try {
                result = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        } else {
            this.logger.debug("FS-LOGD015", pathWithoutMethod);
        }
        return result;
    }

    private Method reflectTargetMethod(String methodName, Class<?> serviceClass) {
        boolean methodFound = false;
        Method method = null;
        for (Class<?> currentClass = serviceClass; currentClass != null && !methodFound; currentClass = currentClass.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = currentClass.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                methodFound = true;
                if (!this.isHttpServiceAnnotated(m)) {
                    this.logger.debug("FS-LOGD016", currentClass.getName(), m.getName());
                    continue;
                }
                if (!Modifier.isPublic(m.getModifiers())) {
                    this.logger.debug("FS-LOGD017", currentClass.getName(), m.getName());
                    continue;
                }
                if (method != null) {
                    throw new IllegalHttpServiceException(Message.get("FS-ERR010", m.getName(), currentClass.getName()));
                }
                this.logger.debug("FS-LOGD018", currentClass.getName(), m.getName());
                method = m;
            }
        }
        if (method == null) {
            this.logger.debug("FS-LOGD019", serviceClass.getName(), methodName);
        }
        return method;
    }

    private boolean isHttpServiceAnnotated(Method method) {
        HttpService annotation = method.getAnnotation(HttpService.class);
        return annotation != null;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public Method getServiceMethod() {
        return this.serviceMethod;
    }

    public boolean isMethodSynchronized() {
        return this.sessionSynchronized;
    }
}

