/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.shared.meslog.log;

import com.small_it_office.shared.meslog.log.EmptyLogger;
import com.small_it_office.shared.meslog.log.JavaStandardLogger;
import com.small_it_office.shared.meslog.log.Log4jLogger;
import com.small_it_office.shared.meslog.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static LoggerFactory instance = new LoggerFactory();
    private LoggerType loggerType = LoggerType.STANDARD;
    private boolean loggerEnabled = true;

    private LoggerFactory() {
    }

    public static void setLoggerType(String strLoggerType) {
        LoggerType type = LoggerType.get(strLoggerType);
        LoggerFactory factory = LoggerFactory.getInstance();
        factory.loggerEnabled = true;
        factory.loggerType = type;
        if (type == LoggerType.LOG4J) {
            try {
                Class.forName("org.apache.log4j.Logger");
            }
            catch (ClassNotFoundException e) {
                factory.loggerEnabled = false;
            }
        }
    }

    public static LoggerFactory getInstance() {
        return instance;
    }

    public Logger getLogger(Class<?> clazz) {
        switch (this.loggerType) {
            case NONE: {
                return EmptyLogger.getInstance();
            }
            case STANDARD: {
                return new JavaStandardLogger(clazz);
            }
            case LOG4J: {
                return this.loggerEnabled ? new Log4jLogger(clazz) : EmptyLogger.getInstance();
            }
        }
        throw new RuntimeException(this.getClass().getName() + " error. maybe BUG in shared-meslog.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoggerType {
        NONE,
        STANDARD,
        LOG4J;


        static LoggerType get(String str) {
            if ("NONE".equalsIgnoreCase(str)) {
                return NONE;
            }
            if ("STANDARD".equalsIgnoreCase(str)) {
                return STANDARD;
            }
            if ("LOG4J".equalsIgnoreCase(str)) {
                return LOG4J;
            }
            System.err.println("warning by " + LoggerFactory.class.getName() + ". logger type '" + str + "' is wrong.");
            return NONE;
        }
    }
}

