/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.botiboti.flextyle.core.SystemException;

public class ConnectionFactory {
    private static final String defaultJndiName_ = "java:comp/env/jdbc/datasource";
    private static DataSource dataSource_ = null;
    private static JDBCSetting setting_ = null;

    protected static void initialize(DataSource dataSource) {
        dataSource_ = dataSource;
    }

    protected static void initialize() {
        ConnectionFactory.initialize(defaultJndiName_);
    }

    protected static void initialize(String jndi) {
        try {
            ConnectionFactory.initialize((DataSource)new InitialContext().lookup(jndi));
        }
        catch (NamingException ex) {
            throw new SystemException("failure for lookup datasource.:" + jndi, ex);
        }
    }

    protected static void initialize(String driverName, String connectString) {
        ConnectionFactory.initialize(driverName, connectString, null);
    }

    protected static void initialize(String driverName, String connectString, Properties props) {
        ConnectionFactory.initialize(driverName, connectString, null, null, props);
    }

    protected static void initialize(String driverName, String connectString, String userName, String password) {
        ConnectionFactory.initialize(driverName, connectString, userName, password, null);
    }

    protected static void initialize(String driverName, String connectString, String userName, String password, Properties props) {
        setting_ = new JDBCSetting();
        ConnectionFactory.setting_.driverClassName = driverName;
        ConnectionFactory.setting_.connectString = connectString;
        ConnectionFactory.setting_.userName = userName;
        ConnectionFactory.setting_.password = password;
        ConnectionFactory.setting_.properties = props;
    }

    static final Connection getConnection() {
        if (dataSource_ == null && setting_ == null) {
            ConnectionFactory.initialize();
        }
        try {
            if (dataSource_ != null) {
                return dataSource_.getConnection();
            }
            Class.forName(ConnectionFactory.setting_.driverClassName);
            if (ConnectionFactory.setting_.userName != null && ConnectionFactory.setting_.password != null) {
                return DriverManager.getConnection(ConnectionFactory.setting_.connectString, ConnectionFactory.setting_.userName, ConnectionFactory.setting_.password);
            }
            if (ConnectionFactory.setting_.properties != null) {
                return DriverManager.getConnection(ConnectionFactory.setting_.connectString, ConnectionFactory.setting_.properties);
            }
            return DriverManager.getConnection(ConnectionFactory.setting_.connectString);
        }
        catch (ClassNotFoundException ex) {
            throw new SystemException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093.", ex);
        }
        catch (SQLException ex) {
            throw new SystemException("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u304b\u3089\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093.", ex);
        }
    }

    protected ConnectionFactory() {
    }

    private static class JDBCSetting {
        String driverClassName = null;
        String connectString = null;
        String userName = null;
        String password = null;
        Properties properties = null;

        private JDBCSetting() {
        }
    }
}

