/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.botiboti.flextyle.core.ConnectionFactory;
import jp.botiboti.flextyle.core.RecordSet;
import jp.botiboti.flextyle.core.SQLQueryCall;
import jp.botiboti.flextyle.core.SQLUpdateCall;
import jp.botiboti.flextyle.core.SQLUtil;
import jp.botiboti.flextyle.core.SystemException;
import jp.botiboti.flextyle.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBConnect {
    private static final RecordSet.RecordSetFriend friendCaller = new RecordSet.RecordSetFriend(){};
    private static final Logger log = new Log.LoggerFriend(){}.fxt();

    protected abstract TransactionContext getTrxContext();

    public int SQL_Update(String sql) {
        return this.SQL_Update(sql, (Map<String, Object>)null);
    }

    public int SQL_Update(String sql, RecordSet params) {
        return this.SQL_Update(sql, friendCaller.getMap(params));
    }

    public int SQL_Update(String sql, RecordSet params, int index) {
        return this.SQL_Update(sql, friendCaller.getMap(params), index);
    }

    public int SQL_Update(String sql, Map<String, Object> params) {
        return this.SQL_Update(sql, params, -1);
    }

    public int SQL_Update(String sql, Map<String, Object> params, int index) {
        return this.SQL_Update(params != null ? SQLUtil.parseAndReplace(sql, params, index) : null, sql);
    }

    public int SQL_Update(String sql, Object ... args) {
        Object[] objs = args;
        return this.SQL_Update(args != null ? SQLUtil.parseAndReplace(sql, Arrays.asList(objs)) : null, sql);
    }

    private int SQL_Update(final SQLUtil.Parsed parsedSQL, String sql) {
        String query = parsedSQL == null ? sql : parsedSQL.query;
        return this.SQL_Update(query, new SQLUpdateCall(){

            public int impl(PreparedStatement stmt) throws SQLException {
                int i = 0;
                while (parsedSQL != null && parsedSQL.parameter != null && i < parsedSQL.parameter.size()) {
                    stmt.setObject(i + 1, parsedSQL.parameter.get(i));
                    ++i;
                }
                return stmt.executeUpdate();
            }
        });
    }

    public int SQL_Update(String sql, SQLUpdateCall caller) {
        Statement stmt = null;
        try {
            log.fine("SQL: " + sql);
            stmt = this.getTrxContext().conn().prepareStatement(sql);
            int cnt = caller.impl((PreparedStatement)stmt);
            if (cnt != 0) {
                this.getTrxContext().DB_Changed();
            }
            int n = cnt;
            return n;
        }
        catch (SQLException ex) {
            throw new SystemException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u95a2\u9023\u306e\u51e6\u7406\u3067\u306e\u30a8\u30e9\u30fc\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002", ex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                throw new SystemException("\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u3059\u308b\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex);
            }
        }
    }

    public RecordSet SQL_Query(String sql) {
        return this.SQL_Query(sql, (Map<String, Object>)null);
    }

    public RecordSet SQL_Query(String sql, RecordSet params) {
        return this.SQL_Query(sql, friendCaller.getMap(params));
    }

    public RecordSet SQL_Query(String sql, RecordSet params, int index) {
        return this.SQL_Query(sql, friendCaller.getMap(params), index);
    }

    public RecordSet SQL_Query(String sql, Map<String, Object> params) {
        return this.SQL_Query(sql, params, -1);
    }

    public RecordSet SQL_Query(String sql, Map<String, Object> params, int index) {
        return this.SQL_Query(params != null ? SQLUtil.parseAndReplace(sql, params, index) : null, sql);
    }

    public RecordSet SQL_Query(String sql, String ... args) {
        String[] objs = args;
        return this.SQL_Query(args != null ? SQLUtil.parseAndReplace(sql, Arrays.asList(objs)) : null, sql);
    }

    private RecordSet SQL_Query(final SQLUtil.Parsed parsedSQL, String sql) {
        String query = parsedSQL == null ? sql : parsedSQL.query;
        return this.SQL_Query(query, new SQLQueryCall(){

            public ResultSet impl(PreparedStatement stmt) throws SQLException {
                int i = 0;
                while (parsedSQL != null && parsedSQL.parameter != null && i < parsedSQL.parameter.size()) {
                    stmt.setObject(i + 1, parsedSQL.parameter.get(i));
                    ++i;
                }
                return stmt.executeQuery();
            }
        });
    }

    public RecordSet SQL_Query(String sql, SQLQueryCall caller) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            log.fine("SQL: " + sql);
            stmt = this.getTrxContext().conn().prepareStatement(sql);
            rs = caller.impl((PreparedStatement)stmt);
            RecordSet record = new RecordSet();
            String[] columns = null;
            int i = 0;
            while (rs.next()) {
                if (i == 0) {
                    ResultSetMetaData meta = rs.getMetaData();
                    columns = new String[meta.getColumnCount() + 1];
                    int col = 1;
                    while (col < columns.length) {
                        columns[col] = meta.getColumnLabel(col).toLowerCase();
                        ++col;
                    }
                }
                int col = 1;
                while (col < columns.length) {
                    record.add(columns[col], i, rs.getObject(col));
                    ++col;
                }
                ++i;
            }
            RecordSet recordSet = record;
            return recordSet;
        }
        catch (SQLException ex) {
            throw new SystemException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u95a2\u9023\u306e\u51e6\u7406\u3067\u306e\u30a8\u30e9\u30fc\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002", ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                throw new SystemException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u95a2\u9023\u306e\u51e6\u7406\u3067\u306e\u30a8\u30e9\u30fc\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002", ex);
            }
        }
    }

    public String SQL_Trace(String sql) {
        return this.SQL_Trace(sql, (Map<String, Object>)null);
    }

    public String SQL_Trace(String sql, RecordSet params) {
        return this.SQL_Trace(sql, friendCaller.getMap(params));
    }

    public String SQL_Trace(String sql, RecordSet params, int index) {
        return this.SQL_Trace(sql, friendCaller.getMap(params), index);
    }

    public String SQL_Trace(String sql, Map<String, Object> params) {
        return this.SQL_Trace(sql, params, -1);
    }

    public String SQL_Trace(String sql, Map<String, Object> params, int index) {
        return this.SQL_Trace(params != null ? SQLUtil.parseAndReplace(sql, params, index) : null, sql);
    }

    public String SQL_Trace(String sql, Object ... args) {
        Object[] objs = args;
        return this.SQL_Trace(args != null ? SQLUtil.parseAndReplace(sql, Arrays.asList(objs)) : null, sql);
    }

    private String SQL_Trace(SQLUtil.Parsed parsedSQL, String sql) {
        if (parsedSQL == null || parsedSQL.parameter == null) {
            return sql;
        }
        sql = parsedSQL.query;
        int i = 0;
        while (i < parsedSQL.parameter.size()) {
            sql = sql.replaceFirst("\\?", parsedSQL.parameter.get(i).toString());
            ++i;
        }
        return sql;
    }

    protected final void closeConnection() {
        if (this.getTrxContext().isDBChanged()) {
            try {
                log.warning("[WARNING] \u672a\u30b3\u30df\u30c3\u30c8\u306e\u5909\u66f4\u304c\u3042\u308a\u307e\u3057\u305f\u306e\u3067\u3001\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u3057\u307e\u3059.");
                this.getTrxContext().conn().rollback();
            }
            catch (SQLException sqlex) {
                log.log(Level.SEVERE, "\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u3092\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f.", sqlex);
            }
        }
        try {
            if (this.getTrxContext().isOpenConnection()) {
                this.getTrxContext().conn().close();
            }
        }
        catch (SQLException sqlex) {
            throw new SystemException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3092\u30af\u30ed\u30fc\u30ba\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f.", sqlex);
        }
        this.getTrxContext().DB_NotChanged();
    }

    public void commit() {
        try {
            this.getTrxContext().conn().commit();
        }
        catch (SQLException ex) {
            throw new SystemException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u3092\u30b3\u30df\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f.", ex);
        }
        this.getTrxContext().DB_NotChanged();
    }

    public void rollback() {
        try {
            this.getTrxContext().conn().rollback();
        }
        catch (SQLException ex) {
            throw new SystemException("\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u3092\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f.", ex);
        }
        this.getTrxContext().DB_NotChanged();
    }

    protected static class TransactionContext {
        private Connection conn_ = null;
        private boolean changed_ = false;

        protected TransactionContext() {
        }

        private Connection conn() throws SQLException {
            if (this.conn_ == null) {
                this.conn_ = ConnectionFactory.getConnection();
                this.conn_.setAutoCommit(false);
            }
            return this.conn_;
        }

        private boolean isOpenConnection() {
            try {
                return this.conn_ != null ? !this.conn_.isClosed() : false;
            }
            catch (SQLException ex) {
                return false;
            }
        }

        private void DB_Changed() {
            this.changed_ = true;
        }

        private void DB_NotChanged() {
            this.changed_ = false;
        }

        private boolean isDBChanged() {
            return this.changed_;
        }
    }
}

