/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.core;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.botiboti.flextyle.core.DBConnect;
import jp.botiboti.flextyle.core.RecordSet;
import jp.botiboti.flextyle.util.Pair;
import jp.botiboti.flextyle.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicBase
extends DBConnect {
    private static final RecordSet.RecordSetFriend friendCaller = new RecordSet.RecordSetFriend(){};

    @Override
    protected abstract LogicContext getTrxContext();

    public Object getUserDataObject() {
        return this.getTrxContext().appData_;
    }

    public void addMessage(String key, Object errObj) {
        this.getTrxContext().addMessage(key, errObj);
    }

    public void addMessage(Object errObj) {
        this.getTrxContext().addMessage("LogicBase.NoKey", errObj);
    }

    public void addAllMessages(RecordSet rs) {
        this.getTrxContext().addAllMessages(rs);
    }

    public boolean hasMessages() {
        return this.getTrxContext().messages_ != null && this.getTrxContext().messages_.size() > 0;
    }

    public Map<String, Object> getMessages() {
        ArrayList<Object> li = new ArrayList<Object>();
        HashMap<String, Object> map = new HashMap<String, Object>(li){
            private static final long serialVersionUID = -3872353096475037976L;
            private List<Object> values;
            {
                this.values = list;
            }

            @Override
            public Object get(Object key) {
                Object obj = super.get(key);
                return obj == null && key.equals("values") ? this.values : obj;
            }
        };
        for (Pair p : this.getTrxContext().messages_) {
            li.add(p.val());
            map.put(p.key(), p.val());
        }
        return map;
    }

    public Timestamp sysDate() {
        return this.getTrxContext().sysDate(false);
    }

    public Timestamp sysDate(boolean isFresh) {
        return this.getTrxContext().sysDate(isFresh);
    }

    public String replace(String src, RecordSet rs) {
        return Util.replace(src, friendCaller.getMap(rs));
    }

    public String replace(String src, RecordSet rs, int index) {
        return Util.replace(src, friendCaller.getMap(rs), index);
    }

    protected class LogicContext
    extends DBConnect.TransactionContext {
        private Object appData_ = null;
        private List<Pair> messages_ = null;
        private Timestamp trTmsp_ = null;

        public LogicContext(Object appData) {
            this.appData_ = appData;
        }

        private void addMessage(String key, Object errObj) {
            if (this.messages_ == null) {
                this.messages_ = new ArrayList<Pair>();
            }
            this.messages_.add(new Pair(key, errObj));
        }

        private void addAllMessages(RecordSet rs) {
            if (rs == null) {
                return;
            }
            if (this.messages_ == null) {
                this.messages_ = new ArrayList<Pair>();
            }
            for (String key : rs.keySet()) {
                int i = 0;
                int max = rs.getCount(key);
                while (i < max) {
                    this.messages_.add(new Pair(key, rs.get(key, i)));
                    ++i;
                }
            }
        }

        private Timestamp sysDate(boolean isFresh) {
            if (isFresh) {
                return new Timestamp(System.currentTimeMillis());
            }
            if (this.trTmsp_ == null) {
                this.trTmsp_ = new Timestamp(System.currentTimeMillis());
            }
            return this.trTmsp_;
        }
    }
}

