/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.core;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.botiboti.flextyle.util.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordSet {
    private Map<String, Object> master_ = new HashMap<String, Object>();

    public RecordSet() {
    }

    public RecordSet(RecordSet rs) {
        this.master_.putAll(rs.master_);
    }

    public RecordSet(Map<String, ? extends Object> map) {
        for (String key : map.keySet()) {
            ArrayList obj = map.get(key);
            if (obj != null && obj.getClass().isArray()) {
                obj = new ArrayList(Arrays.asList((Object[])obj));
            }
            this.master_.put(key, obj);
        }
    }

    public void add(String key, Object value) {
        Object obj = this.master_.get(key);
        if (obj != null && obj instanceof List) {
            ((List)obj).add(value);
        } else if (obj != null) {
            this.add(key, 1, value);
        } else {
            this.set(key, value);
        }
    }

    public void add(String key, int index, Object value) {
        if (this.getCount(key) == 0 && index == 0) {
            this.set(key, value);
        } else {
            this.getList(key).add(index, value);
        }
    }

    public void set(String key, int index, Object value) {
        if (this.getCount(key) <= 1 && index == 0) {
            this.set(key, value);
        } else if (index == this.getCount(key)) {
            this.getList(key).add(value);
        } else {
            this.getList(key).set(index, value);
        }
    }

    public void set(String key, Object value) {
        this.master_.put(key, value);
    }

    public void addAll(RecordSet rs) {
        this.master_.putAll(rs.master_);
    }

    public void copy(String fromCol, String toCol) {
        int i = 0;
        while (i < this.getCount(fromCol)) {
            this.set(toCol, i, this.get(fromCol, i));
            ++i;
        }
    }

    public void clearAll() {
        this.master_.clear();
    }

    public Object remove(String col) {
        return this.master_.remove(col);
    }

    public Object remove(String col, int index) {
        Object obj = this.master_.get(col);
        if (obj != null && obj instanceof List) {
            return ((List)obj).remove(index);
        }
        if (index == 0) {
            return this.remove(col);
        }
        return null;
    }

    public void rename(String fromCol, String toCol) {
        this.copy(fromCol, toCol);
        this.remove(fromCol);
    }

    public Object getObject(String key) {
        return this.get(key);
    }

    public String getString(String key) {
        Object obj = this.get(key);
        return obj == null ? null : (obj instanceof String ? (String)obj : obj.toString());
    }

    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)this.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Number getNumber(String key) {
        return (Number)this.get(key);
    }

    public Timestamp getTimestamp(String key) {
        return (Timestamp)this.get(key);
    }

    public DateTime getDateTime(String key) {
        Object obj = this.get(key);
        return obj == null ? null : (obj instanceof DateTime ? (DateTime)obj : new DateTime((Date)obj));
    }

    public String getString(String key, int index) {
        return (String)this.get(key, index);
    }

    public BigDecimal getBigDecimal(String key, int index) {
        return (BigDecimal)this.get(key, index);
    }

    public Integer getInt(String key, int index) {
        return (Integer)this.get(key, index);
    }

    public Long getLong(String key, int index) {
        return (Long)this.get(key, index);
    }

    public Number getNumber(String key, int index) {
        return (Number)this.get(key, index);
    }

    public Timestamp getTimestamp(String key, int index) {
        return (Timestamp)this.get(key, index);
    }

    public DateTime getDateTime(String key, int index) {
        Object obj = this.get(key, index);
        return obj == null ? null : (obj instanceof DateTime ? (DateTime)obj : new DateTime((Date)obj));
    }

    public List<? extends Object> getListValues(String key) {
        return this.getList(key);
    }

    public boolean isEmpty() {
        return this.master_.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    private Map<String, Object> getMap() {
        return new HashMap<String, Object>(this.master_);
    }

    public Set<String> keySet() {
        return this.master_.keySet();
    }

    public Map<String, Object> getKeyAndVal(String keyCol, String valCol) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        int max = this.getCount(keyCol);
        while (i < max) {
            Object key = this.get(keyCol, i);
            result.put(key instanceof String ? (String)key : key.toString(), this.get(valCol, i));
            ++i;
        }
        return result;
    }

    public boolean contains(String refCol, Object refVal) {
        return this.findIndex(refCol, refVal) >= 0;
    }

    public int findIndex(String condition) {
        String[] colAndVal;
        String[] stringArray = colAndVal = condition.indexOf(61) >= 0 ? condition.split("=", 2) : condition.split("<>", 2);
        if (colAndVal == null || colAndVal.length != 2) {
            return -1;
        }
        return this.findIndex(colAndVal[0], colAndVal[1], condition.indexOf(61) >= 0);
    }

    public int findIndex(String refCol, Object refVal) {
        return this.findIndex(refCol, refVal, true);
    }

    public Object find(String tgtCol, String condition) {
        int i = this.findIndex(condition);
        return i >= 0 ? this.get(tgtCol, i) : null;
    }

    private int findIndex(String refCol, Object refVal, boolean equal) {
        int i = 0;
        int max = this.getCount(refCol);
        while (i < max) {
            if (equal && refVal.equals(this.get(refCol, i))) {
                return i;
            }
            if (!equal && !refVal.equals(this.get(refCol, i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toJSON() {
        return this.toJSON(JsonMode.OutputSingleValue, JsonMode.WithLineFeed);
    }

    public String toJSON(JsonMode ... mode) {
        boolean lineFeed = true;
        boolean outputArray = false;
        JsonMode[] jsonModeArray = mode;
        int n = mode.length;
        int n2 = 0;
        while (n2 < n) {
            JsonMode m = jsonModeArray[n2];
            if (m == JsonMode.NoLineFeed) {
                lineFeed = false;
            }
            if (m == JsonMode.OutputArray) {
                outputArray = true;
            }
            ++n2;
        }
        return this.toJSON(lineFeed, outputArray);
    }

    private String toJSON(boolean lineFeed, boolean outputArray) {
        String key;
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        if (lineFeed) {
            buf.append("\n\t");
        }
        Iterator<String> itr = this.master_.keySet().iterator();
        while (itr.hasNext() && (key = itr.next()) != null) {
            if (this.getCount(key) > 1 || outputArray) {
                buf.append("\"").append(key).append("\"").append(": [");
                int i = 0;
                int max = this.getCount(key);
                while (i < max) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    RecordSet.toJSONString(buf, this.get(key, i));
                    ++i;
                }
                buf.append("]");
            } else {
                buf.append("\"").append(key).append("\"").append(": ");
                RecordSet.toJSONString(buf, this.get(key));
            }
            if (itr.hasNext()) {
                buf.append(",");
            }
            if (!lineFeed) continue;
            buf.append("\n");
        }
        return buf.append("}").toString();
    }

    private static void toJSONString(StringBuffer buf, Object obj) {
        if (obj == null) {
            buf.append("null");
        } else if (obj instanceof Boolean) {
            buf.append(obj.toString());
        } else if (obj instanceof Number) {
            buf.append(obj.toString());
        } else if (obj instanceof List) {
            buf.append("[ ");
            int i = 0;
            while (i < ((List)obj).size()) {
                if (i > 0) {
                    buf.append(", ");
                }
                RecordSet.toJSONString(buf, ((List)obj).get(i));
                ++i;
            }
            buf.append(" ]");
        } else if (obj instanceof Map) {
            Object key;
            buf.append("{ ");
            Iterator itr = ((Map)obj).keySet().iterator();
            while (itr.hasNext() && (key = itr.next()) != null) {
                buf.append("\"").append(key).append("\"").append(": ");
                RecordSet.toJSONString(buf, ((Map)obj).get(key));
                if (!itr.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(" }");
        } else {
            String str = obj.toString().replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"").replace("'", "\\'");
            buf.append("\"").append(str).append("\"");
        }
    }

    public RecordSet subSet(int startRow, int recordCount) {
        RecordSet result = new RecordSet();
        for (String key : this.master_.keySet()) {
            int i = 0;
            int max = this.getCount(key);
            while (i < max) {
                if (i + 1 >= startRow && i + 1 < startRow + recordCount) {
                    result.add(key, this.get(key, i));
                }
                ++i;
            }
        }
        return result;
    }

    public void iterate(String key, Itr itr) {
        int i = 0;
        int max = this.getCount(key);
        while (i < max) {
            this.set(key, i, itr.process(this.get(key, i)));
            ++i;
        }
    }

    public void apply(String key, Itr itr) {
        this.iterate(key, itr);
    }

    public void iterate(String tgtCol, ItrIndex itr) {
        int i = 0;
        int max = this.getCount(tgtCol);
        while (i < max) {
            this.set(tgtCol, i, itr.process(this.get(tgtCol, i), i));
            ++i;
        }
    }

    public void apply(String tgtCol, ItrIndex itr) {
        this.iterate(tgtCol, itr);
    }

    public void applyToMatched(String tgtCol, final Itr itr, String condition) {
        this.applyToMatched(tgtCol, new ItrIndex(){

            public Object process(Object obj, int index) {
                return itr.process(obj);
            }
        }, condition);
    }

    public void applyToMatched(String tgtCol, ItrIndex itr, String condition) {
        String[] colAndVal;
        String[] stringArray = colAndVal = condition.indexOf(61) >= 0 ? condition.split("=", 2) : condition.split("<>", 2);
        if (colAndVal == null || colAndVal.length != 2) {
            return;
        }
        boolean equal = condition.indexOf(61) >= 0;
        boolean notEqual = !equal;
        int i = 0;
        int max = this.getCount(tgtCol);
        while (i < max) {
            if (!(notEqual && this.get(colAndVal[0], i).equals(colAndVal[1]) || equal && !this.get(colAndVal[0], i).equals(colAndVal[1]))) {
                this.set(tgtCol, i, itr.process(this.get(tgtCol, i), i));
            }
            ++i;
        }
    }

    public void copyWith(String fromCol, String toCol, Itr itr) {
        int i = 0;
        int max = this.getCount(fromCol);
        while (i < max) {
            this.set(toCol, i, itr.process(this.get(fromCol, i)));
            ++i;
        }
    }

    public void copyWith(String fromCol, String toCol, ItrIndex itr) {
        int i = 0;
        int max = this.getCount(fromCol);
        while (i < max) {
            this.set(toCol, i, itr.process(this.get(fromCol, i), i));
            ++i;
        }
    }

    public int getCount(String key) {
        if (!this.master_.containsKey(key)) {
            return 0;
        }
        Object obj = this.master_.get(key);
        return obj instanceof List ? ((List)obj).size() : 1;
    }

    public int getCount() {
        Iterator<String> itr = this.master_.keySet().iterator();
        return itr.hasNext() ? this.getCount(itr.next()) : 0;
    }

    public Object get(String key, int index) {
        Object obj;
        if (!(index != 0 || (obj = this.master_.get(key)) != null && obj instanceof List)) {
            return obj;
        }
        return this.getList(key).get(index);
    }

    public Object get(String key) {
        Object obj = this.master_.get(key);
        if (obj != null && obj instanceof List) {
            List list = (List)obj;
            return list.isEmpty() ? null : list.get(0);
        }
        return obj;
    }

    public List<Map<String, Object>> toList(String baseColName) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int i = 0;
        int max = this.getCount(baseColName);
        while (i < max) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String key : this.master_.keySet()) {
                if (key == null) break;
                if (this.getCount(key) <= i) continue;
                row.put(key, this.get(key, i));
            }
            result.add(row);
            ++i;
        }
        return result;
    }

    public List<Map<String, Object>> toSortedList(final String baseColName) {
        List<Map<String, Object>> result = this.toList(baseColName);
        Collections.sort(result, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> p1, Map<String, Object> p2) {
                if (p1 == null || p1.get(baseColName) == null || !(p1.get(baseColName) instanceof Comparable)) {
                    return -1;
                }
                if (p2 == null || p2.get(baseColName) == null || !(p2.get(baseColName) instanceof Comparable)) {
                    return 1;
                }
                return ((Comparable)p1.get(baseColName)).compareTo(p2.get(baseColName));
            }
        });
        return result;
    }

    public List<Map<String, Object>> toSortedList(final String baseColName, final Comparator<? super Object> cmptr) {
        List<Map<String, Object>> result = this.toList(baseColName);
        Collections.sort(result, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> p1, Map<String, Object> p2) {
                return cmptr.compare(p1 == null ? null : p1.get(baseColName), p2 == null ? null : p2.get(baseColName));
            }
        });
        return result;
    }

    private List<Object> getList(String key) {
        Object obj = this.master_.get(key);
        if (obj != null && obj instanceof List) {
            return (List)obj;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.master_.containsKey(key)) {
            list.add(obj);
        }
        this.master_.put(key, list);
        return list;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (String key : this.master_.keySet()) {
            int i = 0;
            int max = this.getCount(key);
            while (i < max) {
                buf.append(key).append("[").append(i).append("]: ");
                buf.append(this.get(key, i)).append("\n");
                ++i;
            }
        }
        return buf.toString();
    }

    public static interface Itr {
        public Object process(Object var1);
    }

    public static interface ItrIndex {
        public Object process(Object var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsonMode {
        OutputArray,
        OutputSingleValue,
        NoLineFeed,
        WithLineFeed;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecordSetFriend {
        private static final String[] allowed = new String[]{"jp.botiboti.flextyle.core.DBConnect", "jp.botiboti.flextyle.core.LogicBase", "jp.botiboti.flextyle.web.RecordSetForJSP"};

        protected RecordSetFriend() {
            String className = this.getClass().getName();
            String[] stringArray = allowed;
            int n = allowed.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedClassName = stringArray[n2];
                if (className.startsWith(allowedClassName)) {
                    return;
                }
                ++n2;
            }
            throw new RuntimeException(String.valueOf(className) + "is not allowed to access");
        }

        public Map<String, Object> getMap(RecordSet rs) {
            return rs.getMap();
        }
    }
}

