/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date currentDate_ = null;
    private static int currentDateYear_ = -1;
    private static int currentDateMonth_ = -1;
    private static int currentDateDay_ = -1;
    public static Timestamp currentTime_ = null;

    private DateUtil() {
    }

    public static Timestamp today() {
        if (currentDate_ != null) {
            return new Timestamp(currentDate_.getTime());
        }
        return new Timestamp(DateUtil.resetTime(Calendar.getInstance()).getTime().getTime());
    }

    public static Timestamp now() {
        if (currentTime_ != null) {
            return currentTime_;
        }
        if (currentDate_ != null) {
            if (currentDateYear_ == -1) {
                Calendar current = Calendar.getInstance();
                current.setTime(currentDate_);
                currentDateYear_ = current.get(1);
                currentDateMonth_ = current.get(2);
                currentDateDay_ = current.get(5);
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, currentDateYear_);
            cal.set(2, currentDateMonth_);
            cal.set(5, currentDateDay_);
            return new Timestamp(cal.getTime().getTime());
        }
        return new Timestamp(System.currentTimeMillis());
    }

    public static int dayOfWeek(Timestamp date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static Timestamp prevDay(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        cal.add(5, -1);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp nextDay(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        cal.add(5, 1);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp beforeNDay(Timestamp date, int n) {
        Calendar cal = DateUtil.cal(date);
        cal.add(5, -n);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp afterNDay(Timestamp date, int n) {
        Calendar cal = DateUtil.cal(date);
        cal.add(5, n);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp prevMonth(Timestamp date) {
        return DateUtil.beforeNMonth(date, 1);
    }

    public static Timestamp nextMonth(Timestamp date) {
        return DateUtil.afterNMonth(date, 1);
    }

    public static Timestamp beforeNMonth(Timestamp date, int n) {
        Calendar cal = DateUtil.cal(date);
        cal.add(2, -n);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp afterNMonth(Timestamp date, int n) {
        Calendar cal = DateUtil.cal(date);
        cal.add(2, n);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp beforeNYear(Timestamp date, int n) {
        Calendar cal = DateUtil.cal(date);
        cal.add(1, -n);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp afterNYear(Timestamp date, int n) {
        Calendar cal = DateUtil.cal(date);
        cal.add(1, n);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp firstOfYearCycle(Integer year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, 3, 1);
        DateUtil.resetTime(cal);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp lastOfYearCycle(Integer year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year + 1, 2, 31);
        DateUtil.resetTime(cal);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp firstOfYearCycle(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2);
        if (month < 3) {
            --year;
        }
        cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, 3, 1);
        DateUtil.resetTime(cal);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp lastOfYearCycle(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2);
        if (month < 3) {
            --year;
        }
        cal = Calendar.getInstance();
        cal.clear();
        cal.set(year + 1, 2, 31);
        DateUtil.resetTime(cal);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Integer yearCycle(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2);
        if (month < 3) {
            --year;
        }
        return new Integer(year);
    }

    public static Timestamp firstOfMonth(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        cal.set(5, 1);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp lastOfMonth(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp firstOfNextMonth(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        cal.set(5, 1);
        cal.add(2, 1);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp firstOfPrevMonth(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        cal.set(5, 1);
        cal.add(2, -1);
        return new Timestamp(cal.getTime().getTime());
    }

    public static boolean isFirstOfMonth(Timestamp date) {
        return date.equals(DateUtil.firstOfMonth(date));
    }

    public static boolean isLastOfMonth(Timestamp date) {
        return date.equals(DateUtil.lastOfMonth(date));
    }

    public static Timestamp parseYYYYMM(String str) {
        if (str == null || 6 != str.length()) {
            return null;
        }
        return DateUtil.parseYYYYMMDD(String.valueOf(str) + "01");
    }

    public static Timestamp parseYYYYMMDD(String str) {
        block3: {
            try {
                if (str != null && 8 == str.length()) break block3;
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        int year = Integer.parseInt(str.substring(0, 4));
        int mon = Integer.parseInt(str.substring(4, 6));
        int day = Integer.parseInt(str.substring(6, 8));
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.set(year, mon - 1, day);
        return new Timestamp(DateUtil.resetTime(cal).getTime().getTime());
    }

    public static String toYYYYMMDD(Date date) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dt = cal.get(5);
        return String.valueOf(year * 10000 + month * 100 + dt);
    }

    public static String toYYYYMM(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return String.valueOf(year * 100 + month);
    }

    public static String toYYYY(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        return String.valueOf(cal.get(1));
    }

    public static String toMM(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        return String.valueOf(cal.get(2) + 1);
    }

    public static String toDD(Timestamp date) {
        Calendar cal = DateUtil.cal(date);
        return String.valueOf(cal.get(5));
    }

    public static String toYYYYMMDDf(Timestamp date) {
        return DateUtil.toYYYYMMDDf(date, "/");
    }

    public static String toYYYYMMDDf(Timestamp date, String delim) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dt = cal.get(5);
        return String.valueOf(String.valueOf(year * 10000) + delim + month * 100 + delim + dt);
    }

    public static String toYYYYMMf(Timestamp date) {
        return DateUtil.toYYYYMMf(date, "/");
    }

    public static String toYYYYMMf(Timestamp date, String delim) {
        Calendar cal = DateUtil.cal(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String month_ = String.valueOf(month);
        if (month < 10) {
            month_ = "0" + month_;
        }
        return String.valueOf(String.valueOf(year) + delim + month_);
    }

    public static String format(String str) {
        if (str == null || str.indexOf(47) != -1) {
            return str;
        }
        if (str.length() == 4) {
            return String.valueOf(str.substring(0, 2)) + "/" + str.substring(2, 4);
        }
        if (str.length() == 6) {
            return String.valueOf(str.substring(0, 4)) + "/" + str.substring(4, 6);
        }
        if (str.length() == 8) {
            return String.valueOf(str.substring(0, 4)) + "/" + str.substring(4, 6) + "/" + str.substring(6, 8);
        }
        return str;
    }

    public static String strip(String str) {
        if (str.indexOf(47) == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != '/') {
                buf.append(str.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static String wareki(String str) {
        int yyyy = Integer.parseInt(str);
        int wareki = yyyy - 1989;
        return String.valueOf(wareki + 1);
    }

    private static Calendar cal(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DateUtil.resetTime(cal);
    }

    private static Calendar resetTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }
}

