/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.botiboti.flextyle.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchParser {
    private static DispatchParser defaultInstance = null;
    public static final String defaultUrlPattern = "/(?:[^/]+/)*([a-zA-Z_][\\w\\.]*[\\w])::([a-zA-Z_][\\w]+)(?::([^:]*))?(?::([^:]*))?(?::([^:]*))?(?::([^:]*))?";
    public static final String defaultExpressionOfClassName = "$1";
    public static final String defaultExpressionOfMethodName = "$2";
    public static final String[] defaultExpressionOfParameter = new String[]{"$3", "$4", "$5", "$6"};
    private StrFromURL classNameFromURL = null;
    private StrFromURL methodNameFromURL = null;
    private StrFromURL[] parameterFromURL = null;
    private Pattern urlPattern = null;

    DispatchParser() {
        if (defaultInstance == null) {
            defaultInstance = this;
        }
    }

    public static final DispatchParser defaultInstance() {
        return defaultInstance;
    }

    public void setUrlPattern(String ptrn) {
        this.urlPattern = Pattern.compile(Util.isNullOrBlank(ptrn) ? defaultUrlPattern : ptrn);
    }

    public void setClassNameExpression(String exp) {
        String expression = Util.isNotNullOrBlank(exp) ? exp : defaultExpressionOfClassName;
        this.classNameFromURL = this.StrFromURLObject(expression);
    }

    public void setMethodNameExpression(String exp) {
        String expression = Util.isNotNullOrBlank(exp) ? exp : defaultExpressionOfMethodName;
        this.methodNameFromURL = this.StrFromURLObject(expression);
    }

    public void setParameterExpressions(List<String> li) {
        this.parameterFromURL = new StrFromURL[li == null ? defaultExpressionOfParameter.length : li.size()];
        int i = 0;
        while (i < this.parameterFromURL.length) {
            this.parameterFromURL[i] = this.StrFromURLObject(li == null ? defaultExpressionOfParameter[i] : li.get(i));
            ++i;
        }
    }

    public Matcher parse(String url) {
        return this.urlPattern.matcher(url);
    }

    public String getClassName(Matcher matcher) {
        String className = this.classNameFromURL.get(matcher);
        return className.indexOf(47) == -1 ? className : className.replace('/', '.');
    }

    public String getMethodName(Matcher matcher) {
        return this.methodNameFromURL.get(matcher);
    }

    public List<String> getParameters(Matcher matcher, String url) {
        ArrayList<String> parameter = null;
        int i = 0;
        while (i < this.parameterFromURL.length) {
            String s = this.parameterFromURL[i].get(matcher);
            if (s == null) break;
            if (!s.equals("")) {
                if (parameter == null) {
                    parameter = new ArrayList<String>();
                    if (i != 0) {
                        parameter.addAll((Collection)Collections.nCopies(i, null));
                    }
                }
                parameter.add(s);
            }
            ++i;
        }
        return parameter;
    }

    private StrFromURL StrFromURLObject(String expression) {
        if (expression.startsWith("$") && Util.isNumber(expression.substring(1))) {
            final int i = Integer.parseInt(expression.substring(1));
            return new StrFromURL(){

                public String get(Matcher urlMatcher) {
                    return urlMatcher.group(i);
                }
            };
        }
        final String[] partsOfExprssn = expression.split("\\$[\\d]+", -1);
        Matcher replace$Matcher = Pattern.compile(".*(\\$[\\d]+).*").matcher(expression);
        final int[] replace$Index = new int[replace$Matcher.matches() ? replace$Matcher.groupCount() : 0];
        int i = 1;
        int max = replace$Index.length;
        while (i <= max) {
            replace$Index[i - 1] = Integer.parseInt(replace$Matcher.group(i).substring(1));
            ++i;
        }
        return new StrFromURL(){

            public String get(Matcher urlMatcher) {
                StringBuffer result = new StringBuffer(partsOfExprssn[0]);
                int i = 1;
                while (i < partsOfExprssn.length) {
                    result.append(urlMatcher.group(replace$Index[i - 1]));
                    result.append(partsOfExprssn[i]);
                    ++i;
                }
                return result.toString();
            }
        };
    }

    public static class ParseResult {
        public String className;
        public String methodName;
        public List<String> parameters;
    }

    private static interface StrFromURL {
        public String get(Matcher var1);
    }
}

