/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.web;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.botiboti.flextyle.core.LogicCall;
import jp.botiboti.flextyle.core.SystemException;
import jp.botiboti.flextyle.util.Log;
import jp.botiboti.flextyle.util.ReflectionUtil;
import jp.botiboti.flextyle.web.UserDataFactory;
import jp.botiboti.flextyle.web.WebBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher {
    private static final Logger logger = new Log.LoggerFriend(){}.fxt();
    private static Dispatcher defaultInstance = null;

    Dispatcher() {
        if (defaultInstance == null) {
            defaultInstance = this;
        }
    }

    public static final Dispatcher defaultInstance() {
        return defaultInstance;
    }

    public WebBean createWebBean(final String className) {
        return (WebBean)new ReflectionUtil<WebBean>(){

            @Override
            public WebBean impl() throws Exception {
                Class<?> beanClass = Class.forName(className);
                if (!WebBean.class.isAssignableFrom(beanClass)) {
                    throw new SystemException("\u6307\u5b9a\u3055\u308c\u305f\u30af\u30e9\u30b9\u306f\u3001WebBean\u306e\u30b5\u30d6\u30af\u30e9\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + className);
                }
                return (WebBean)beanClass.newInstance();
            }
        }.createInstance();
    }

    public Object dispatch(HttpServletRequest req, HttpServletResponse res, final WebBean bean, final String methodName, final List<String> parameter) {
        bean.setRequest(new RequestWrapper(req));
        Object result = bean.start(new LogicCall<Object>(){

            @Override
            public Object impl() {
                try {
                    ReflectionUtil<Object> ref = new ReflectionUtil<Object>(){

                        @Override
                        public Object impl() throws Exception {
                            Method[] methodArray = bean.getClass().getMethods();
                            int n = methodArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Method method = methodArray[n2];
                                if (method.getName().equals(methodName)) {
                                    Object[] p = new Object[method.getParameterTypes().length];
                                    return method.invoke((Object)bean, parameter == null ? p : parameter.toArray(p));
                                }
                                ++n2;
                            }
                            throw new SystemException("\u6307\u5b9a\u3055\u308c\u305f\u30e1\u30bd\u30c3\u30c9[" + methodName + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                        }
                    };
                    ref.addExceptionHandler(InvocationTargetException.class, new ReflectionUtil.ExceptionHandler<Object>(){

                        @Override
                        public Object handle(Exception ex) {
                            logger.log(Level.SEVERE, "\u30d3\u30b8\u30cd\u30b9\u30ed\u30b8\u30c3\u30af\u306e\u5b9f\u884c\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex.getCause() != null ? ex.getCause() : ex);
                            return null;
                        }
                    });
                    return ref.invokeMethod();
                }
                catch (RuntimeException ex) {
                    logger.log(Level.SEVERE, "\u30d3\u30b8\u30cd\u30b9\u30ed\u30b8\u30c3\u30af\u306e\u5b9f\u884c\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex.getCause() != null ? ex.getCause() : ex);
                    return null;
                }
            }
        }, UserDataFactory.getUserData(req));
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestWrapper
    extends WebBean.RequestWrapper {
        private HttpServletRequest request;

        RequestWrapper(HttpServletRequest req) {
            this.request = req;
        }

        @Override
        public Map<String, Object> getAttributeMap() {
            HashMap<String, Object> result = null;
            Enumeration enu = this.request.getAttributeNames();
            String key = null;
            while (enu.hasMoreElements() && (key = (String)enu.nextElement()) != null) {
                if (result == null) {
                    result = new HashMap<String, Object>();
                }
                result.put(key, this.request.getAttribute(key));
            }
            return result;
        }

        @Override
        public Map<String, Object> getParameterMap() {
            return this.request.getParameterMap();
        }

        @Override
        public Object getAttribute(String arg0) {
            return this.request.getAttribute(arg0);
        }

        @Override
        public String getHeader(String arg0) {
            return this.request.getHeader(arg0);
        }

        @Override
        public Enumeration<String> getHeaders(String arg0) {
            return this.request.getHeaders(arg0);
        }

        @Override
        public Enumeration<String> getHeaderNames() {
            return this.request.getHeaderNames();
        }

        @Override
        public String getMethod() {
            return this.request.getMethod();
        }

        @Override
        public int getContentLength() {
            return this.request.getContentLength();
        }

        @Override
        public String getContentType() {
            return this.request.getContentType();
        }

        @Override
        public Reader getReader() throws IOException {
            return this.request.getReader();
        }
    }
}

