package jp.botiboti.flextyle.core;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.botiboti.flextyle.util.Pair;
import jp.botiboti.flextyle.util.Util;

/**
 * DBConnectNXgArWlXWbN邽߂̊NXł. <br>
 * 
 * @author tanaka ken
 */
abstract public class LogicBase extends DBConnect {
	
	private static final RecordSet.RecordSetFriend friendCaller = new RecordSet.RecordSetFriend() { };
	
	protected class LogicContext	extends DBConnect.TransactionContext {

		/** AvP[VŎgp郆[UƂ̃f[^iԂ̓AvP[VƂɒ`j */
		private Object appData_ = null;

		public LogicContext(Object appData) {
			this.appData_ = appData;
		}
		
		/** G[i[RNV */
		private List<Pair> messages_ = null;

		private void addMessage(String key, Object errObj) {
			if (this.messages_ == null) {
				this.messages_ = new ArrayList<Pair>();
			}
			this.messages_.add(new Pair(key, errObj));
		}

		private void addAllMessages(RecordSet rs) {
			if (rs == null)
				return;
			if (this.messages_ == null)
				this.messages_ = new ArrayList<Pair>();

			for (String key: rs.keySet()) {
				for (int i = 0, max = rs.getCount(key); i < max; i++)
					this.messages_.add(new Pair(key, rs.get(key, i)));
			}
		}

		/** YgUNVňӂȃVXet */
		private Timestamp trTmsp_ = null;

		private Timestamp sysDate(boolean isFresh) {
			if (isFresh)
				return new Timestamp(System.currentTimeMillis());

			if (this.trTmsp_ == null)
				this.trTmsp_ = new Timestamp(System.currentTimeMillis());

			return this.trTmsp_;
		}
	}
	
	/**
	 * ReLXg擾钊ۃ\bh
	 * eNXŒ`ꂽ\bh́A߂lTuNXɕύX
	 */
	abstract protected LogicContext getTrxContext();

	/**
	 * [Uf[^Object^Ŏ擾. <br>
	 * eAvP[Vł́ArWlXWbN x[XNXɂāÃ\bh̃bv\bh쐬Ďgp邱Ƃz肵Ă܂.
	 * 
	 * @return Object [Uf[^IuWFNg
	 */
	public Object getUserDataObject() {
		return this.getTrxContext().appData_;
	}

	public void addMessage(String key, Object errObj) {
		this.getTrxContext().addMessage(key, errObj);
	}

	public void addMessage(Object errObj) {
		this.getTrxContext().addMessage("LogicBase.NoKey", errObj);
	}

	public void addAllMessages(RecordSet rs) {
		this.getTrxContext().addAllMessages(rs);
	}

	public boolean hasMessages() {
		return this.getTrxContext().messages_ != null && this.getTrxContext().messages_.size() > 0;
	}

	/**
	 * Returns messages in Map. you can get list of messages by call method get("values").
	 * @return
	 */
	public Map<String,Object> getMessages() {

		final List<Object> li = new ArrayList<Object>();		
		
		final Map<String,Object> map = new HashMap<String,Object>() {
			private static final long serialVersionUID = -3872353096475037976L;
			private List<Object> values = li; 
			
			public Object get(Object key) {
				Object obj = super.get(key);
				return (obj == null && key.equals("values")) ? this.values: obj;
			}
		};
		
		for (Pair p: this.getTrxContext().messages_) {
			
			li.add(p.val());
			map.put(p.key(), p.val());
		}
		return map;
	}
	
	public Timestamp sysDate() {
		return this.getTrxContext().sysDate(false);
	}

	public Timestamp sysDate(boolean isFresh) {
		return this.getTrxContext().sysDate(isFresh);
	}

	public String replace(String src, RecordSet rs) {
		return Util.replace(src, friendCaller.getMap(rs));
	}

	public String replace(String src, RecordSet rs, int index) {
		return Util.replace(src, friendCaller.getMap(rs), index);
	}
}
