package jp.botiboti.flextyle.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import jp.botiboti.flextyle.util.Log;
import jp.botiboti.flextyle.util.Util;

/**
 * SQL ̒us[eBeBNX. <br>
 * SQL ̒úASQL sOɒusI SQL idynamicjƁA
 * SQL sɒuszXgϐihostvarj 2 ܂.
 *
 * @author tanaka ken
 */
public class SQLUtil {
	
	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
  private static String DYNAMIC_ = "${"; // ISQL̒us̊JnL
  private static String _DYNAMIC = "}";  // ISQL̒us̏IL
  private static String HOSTVAR_ = "?{"; // zXgϐ̒us̊JnL
  private static String _HOSTVAR = "}";  // zXgϐ̒us̏IL

  private SQLUtil() { }

  /**
   * ͂SQLŃLbV邽߂̃}bv
   */
  private static Map<String,Parsed> cache = new HashMap<String,Parsed>();
  /**
   * LbVgp邩ǂ
   * @return boolean
   */
  private static boolean isCacheMode() {
    return cache != null;
  }
  /**
   * LbVA͍ςSQL擾
   * @param sql String ͑OSQL
   * @return Parsed ͌SQL
   */
  private static Parsed getFromCache(String sql) {
    return (Parsed)cache.get(sql);
  }
  /**
   * LbVɉ͍ςSQLۑ
   * @param sql String ͑OSQL
   * @param parsed Parsed ͌SQL
   */
  private static void addToCache(String sql, Parsed parsed) {
    cache.put(sql, parsed);
  }

  /**
   * uSQLi[NX.
   */
  public static class Parsed {
    public String query;
    public List<Object> parameter;
    public Parsed createCopy() {
      Parsed copy = new Parsed();
      copy.query = this.query;
      copy.parameter = this.parameter;
      return copy;
    }
  }

  /**
   * SQL ̒us܂.
   * @param sql String
   * @param params Map
   * @return Result
   */
  public static Parsed parseAndReplace(String sql, Map<String,Object> params) {
    return parseAndReplace(sql, params, -1);
  }

  /**
   * SQL ̉́iujs܂.
   * @param sql String
   * @param params Map
   * @param index 
   * @return ͌SQLIuWFNg
   */
  public static Parsed parseAndReplace(String sql, Map<String,Object> params, int index) {

    Parsed parsed = null;

    if (isCacheMode() == false || (parsed = getFromCache(sql)) == null) {
    	
      String replaced = Util.replace(sql, params, index, DYNAMIC_, _DYNAMIC);
      parsed = replaceHostvar(replaced);
      if (isCacheMode()) {
        addToCache(replaced, parsed.createCopy());
      }
    }
    else {
      // LbVꂽIuWFNg̃Rs[쐬
      parsed = parsed.createCopy();
    }

    // uϐ݂ꍇAۂ̕ϐKp
    if (parsed.parameter != null)
      applyParameter(parsed, params, index);

    return parsed;
  }

  /**
   * SQL ̉́iujs܂. ̃\bhł́AzXgϐ̒û݂s܂.
   * ܂AŎw肳ꂽXĝ܂܁AzXgϐ̒uɎgp܂.
   * @param sql String
   * @param list
   * @return ͌SQLIuWFNg
   */
  public static Parsed parseAndReplace(String sql, List<Object> list) {

    Parsed parsed = null;

    if (isCacheMode() == false || (parsed = getFromCache(sql)) == null) {
    	
      parsed = replaceHostvar(sql);
      
      if (isCacheMode()) {
        addToCache(sql, parsed.createCopy());
      }
    }
    else {
      // LbVꂽIuWFNg̃Rs[쐬
      parsed = parsed.createCopy();
    }

    // uϐ݂ꍇAۂ̕ϐKp
    if (parsed.parameter != null)
      parsed.parameter = list;

    return parsed;
  }
  
  // ?{..}uvCx[g\bh
  // sɂ́Asql ?{..}A?ɒu.
  private static Parsed replaceHostvar(String sql) {

    Parsed result = new Parsed();
    String[] partsSQL = Util.split(sql, HOSTVAR_);

    if (partsSQL.length == 1) {
      result.query = sql;
      return result;
    }
    StringBuffer buf = new StringBuffer(partsSQL[0]);

    for (int i = 1; i < partsSQL.length; i++) {

      // Lŕ
      String[] splited = Util.split(partsSQL[i], _HOSTVAR, 2);

      // L݂Ȃꍇ
      if (splited == null || splited.length == 1) {
        log.fine("SQL̒u ?{} ̋LqɌ肪܂.");
        buf.append(partsSQL[i]);
        continue;
      }
      // uϐi[pXg쐬ȂAō쐬
      if (result.parameter == null) result.parameter = new ArrayList<Object>();

      // ũL[Xgɒǉ
      result.parameter.add(splited[0]);

      // u "?" ݒ肵Aɂ̌̕A
      buf.append("?").append(splited[1]);
    }

    // sSQLm
    result.query = buf.toString();
    return result;
  }

  /**
   * ͍ςSQLɁAۂ̒uϐKp.
   * sɂ́Asql.parameter ɒl̃XgZbg.
   * 
   * @param sql Parsed ͌SQL
   * @param params Map uϐێ}bv
   * @param index u̓Y
   */
  private static void applyParameter(Parsed sql, Map<String,Object> params, int index) {

    List<Object> parameters = new ArrayList<Object>();

    for (int i = 0; sql.parameter != null && i < sql.parameter.size(); i++) {

      String key = (String)sql.parameter.get(i);
      
      // CfbNX̃p[^ǂ
      boolean isIndexedParams = false;
      
      // uϐ݂Ȃꍇ
      if (params.get(key) == null) {
      	if (key.indexOf('[') > 0 && params.get(key.substring(0, key.indexOf('['))) != null) {
            
            isIndexedParams = key.trim().endsWith("[n]") || key.trim().endsWith("[i]");
            key = key.substring(0, key.indexOf('['));
      	}
      	else {
      		log.fine("SQL̒u[" + key + "]ɊYlNULLł:" + params);
      		parameters.add(null);
      		continue;
        }
      }

      // uϐ擾
      Object obj = params.get(key);

      // CfbNXt̕ϐŁAzA܂̓Xg̏ꍇ
      if (isIndexedParams && (obj.getClass().isArray() || obj instanceof List)) {
        // indexԖڂ̒lp[^ƂĐݒ肷
        parameters.add((obj instanceof List)?((List<?>)obj).get(index): ((Object[])obj)[index]);
      }
      else {
    	// zA܂̓Xg̏ꍇ
    	if (obj.getClass().isArray() || obj instanceof List)
    	  // 0Ԗڂ̒lp[^ƂĐݒ肷
    	  parameters.add((obj instanceof List)?((List<?>)obj).get(0): ((Object[])obj)[0]);
    	else 
          parameters.add(obj);
      }
    }
    // uϐXgݒ
    sql.parameter = parameters;
  }

  /**
   * 2007.11 dlύX
   *   ł́AIuWFNĝ܂toString()lԂ悤ɂ
   * 
   * Ŏw肳ꂽIuWFNǧ^ɉāAK؂SQLp[^쐬ĕԂ܂.
   * String^F "aaa"  "'aaa'"
   * Integer^F 10  "10"
   * Timestamp^F 2007/01/23  "TO_DATE('20070123', 'YYYYMMDD')"
   * ȊǑ^F null Ԃ.
   *
   * @param obj Object
   * @return String
   */
//  public static String toSQLParameter(Object obj) {
//	  return Util.nullToBlank((String)obj);
//    if (obj instanceof String) {
//      return "'" + obj + "'";
//    }
//    else if (obj instanceof Timestamp) {
//      return "TO_DATE('" + DateUtil.toYYYYMMDD((Timestamp)obj) + "', 'YYYYMMDD')";
//    }
//    else if (obj instanceof Number) {
//      return obj.toString();
//    }
//    return null;
//  }
}
