package jp.botiboti.flextyle.extension;

import java.util.HashMap;
import java.util.Map;

import jp.botiboti.flextyle.core.RecordSet;

public class IndexedRecordSet extends RecordSet {

	private Map<String,Map<String, Integer>> indexes_ = null;
	  
	public IndexedRecordSet() {
	}
	
	public IndexedRecordSet(RecordSet rs) {
		super(rs);
	}
	
	public IndexedRecordSet(Map<String,Object> map) {
		super(map);
	}
	
	/**
	 * w肳ꂽJɃCfbNXǉ܂. CfbNX͂̃\bhĂ΂ꂽ_
	 * 쐬Ǎ͍XV܂Bvf̒ǉA폜ꍇɂ͍ēx̃\bhĂяo
	 * CfbNX̍č쐬sĂ.
	 * w肵Jɏdl݂ꍇ́Ä͖܂B
	 * @param key String CfbNXǉJ
	 */
	public void setIndex(String col) {
		if (this.indexes_ == null) this.indexes_ = new HashMap<String,Map<String,Integer>>();
		this.indexes_.put(col, new HashMap<String,Integer>());
		for (int i = 0, max = getCount(col); i < max; i++) {
			this.indexes_.get(col).put((String)get(col, i), new Integer(i));
		}
	}
	
	public void clearAll() {
		
		if (this.indexes_ != null) this.indexes_.clear();
		super.clearAll();
	}
	
	public Object findByIndex(String tgtCol, String refCol, String refVal) {
		Map<String,Integer> obj = null;
		Integer itg = null;
		
		if ((obj = indexes_.get(refCol)) == null) return null;
		if ((itg = obj.get(refVal)) == null) return null;
		return get(tgtCol, itg.intValue());
	}
	
	public int findIndex(String refCol, Object refVal) {
		Map<String,Integer> obj = null;
		Integer itg = null;
		
		if ((obj = indexes_.get(refCol)) == null) return super.findIndex(refCol, refVal);
		return ((itg = obj.get(refVal)) == null) ? -1: itg.intValue();
	}
	
}
