package jp.botiboti.flextyle.extension;

import java.util.HashMap;
import java.util.Map;

import jp.botiboti.flextyle.core.RecordSet;

/**
 * ʂ̌ꍇɁAy[Wi1-10A11-20Ȃǂ̐j
 * s߂̃wp[NX. <br /><br />
 * ygz<br />
 * Pager p = new Pager(); //    <br/> 1y[W̌=10ŁAy[WsCX^X쐬
 * Pager p = new Pager(8); //    <br/>1y[W̌=8ŁAy[WsCX^X쐬
 * Pager p = new Pager(2, Pager.NEXT); //1y[W̌=10ŁA2y[Wڂ̎y[Ŵ߂̃y[WsCX^X쐬    <br/>
 * Pager p = new Pager(2, Pager.PREV); //1y[W̌=10ŁA2y[Wڂ̑Oy[Ŵ߂̃y[WsCX^X쐬    <br/>
 * Pager p = new Pager(2, Pager.REFRESH); //1y[W̌=10ŁA2y[Wڂ̍ēx̂߂̃y[WsCX^X쐬    <br/>
 * Pager p = new Pager(2, Pager.NEXT, 8); //1y[W̌=8ŁA2y[Wڂ̎y[Ŵ߂̃y[WsCX^X쐬    <br/>
 *  JSPŁAname="${pager.currentPageKey}" value="${pager.shownPageNum}" Ƃhiddenڂ쐬Ăꍇ́A
 *    ȉ̕@PagerCX^X쐬邱ƂŁÃ݂y[WɂĐPagerIuWFNgɔC邱ƂłB   <br/>
 * Pager p = new Pager(input, Pager.NEXT); //1y[W̌=10ŁÃ݂y[W̎y[Ŵ߂̃y[WsCX^X쐬    <br/>
 * Pager p = new Pager(input, Pager.PREV); //1y[W̌=10ŁÃ݂y[W̑Oy[Ŵ߂̃y[WsCX^X쐬    <br/>
 * Pager p = new Pager(input, Pager.NEXT, 8); //1y[W̌=8ŁÃ݂y[W̎y[Ŵ߂̃y[WsCX^X쐬    <br/>
 * <br/>
 * RecordSet resutl = SQL_Query("...");   <br/>
 * RecordSet subset = p.paging(result); // ʂAݒ肳ꂽɏ]i荞 <br/>
 * <br/>
 * p.getShownPageNum(); // ʂAy[W̉y[Wڂł邩擾 <br/>
 * p.getMaxPageNum();   // ʂASŉy[W邩擾 <br/>
 * p.getMaxRowNum();   // ʂASŉ邩擾 <br/>
 * p.getShownStartRow(); // ʂ̐擪sAŜ̒̉ڂł邩擾 <br/>
 * p.getShownEndRow(); // ʂ̍Ō̍sAŜ̒̉ڂł邩擾 <br/>
 * p.getHasNext(); // ʂɁÃy[W邩ǂ擾 <br/>
 * p.getHasPrev(); // ʂɁAÕy[W邩ǂ擾 <br/>
 * p.getCurrentPageKey(); // y[Wp߂̃L[ <br/>
 * <br/>
 * y̑̋@\z<br/>
 * rWlXWbNŎgpACӂ̌PagerIuWFNgɕRtĕێ
 * ƂłB́ArWlXWbNŃZbgJSPŎoƂ
 * z肵ĂB<br/>
 * <br/>
 * p.setJoken("order_no", "001-2400100557"); <br/>
 * p.setJoken("entry_date", "20080105"); <br/>
 * <br/>
 * JSPł́Aȉ̂悤ɋLq邱ƂŒloƂłB<br/>
 * ${pager.joken.order_no} <br/>
 * ${pager.joken.entry_date} <br/>
 * 
 * @author tanaka ken
 */
public class Pager {

	private static final int DEFAULT_RECORD_COUNT = 10;
	private static final String CURRENT_PAGE_KEY = "Pagenator.currentPage";
	
	// 1y[W̕\siCX^X쐬ɕK{wj
	private int recordCount = -1;
	// ̃y[WOiCX^X쐬ɔCӎwj
	private Direction direction = null;
	// ݂̃y[W (CX^X쐬ɔCӎwj
	private int currentPage = -1;
	// YiɕKZbgj
	private int maxRow = -1;
	
	public static final Direction NEXT = new Direction();
	public static final Direction PREV = new Direction();
	public static final Direction REFRESH = new Direction();

	private static class Direction {	};

	// Constractor ///////////////////////////////////////////////
	
	public Pager() {
		this(DEFAULT_RECORD_COUNT);
	}
	
	public Pager(int pageSize) {
		this.recordCount = pageSize;
	}
	
	public Pager(int currentPage, Direction direc) {
		this(currentPage, direc, DEFAULT_RECORD_COUNT);
	}
	
	public Pager(int currentPage, Direction direc, int pageSize) {
		this.direction = direc;
		this.currentPage = currentPage;
		this.recordCount = pageSize;		
	}

	public Pager(RecordSet input, Direction direc) {
		this(input, direc, DEFAULT_RECORD_COUNT);
	}
	
	public Pager(RecordSet input, Direction direc, int pageSize) {
		this(Integer.parseInt(input.getString(CURRENT_PAGE_KEY)), direc, pageSize);
	}
	

	// Getter //////////////////////////////////////////////////////
	
	// iɁj\y[W
	public int getShownPageNum() {

		return (direction == NEXT)? this.currentPage + 1: (direction == PREV)? this.currentPage - 1:
				(direction == REFRESH)? this.currentPage: 1;
	}

	// y[W̍ő吔
	public int getMaxPageNum() {

		return this.maxRow / recordCount + ((this.maxRow % recordCount == 0)? 0: 1);
	}
	
	// Yʐ
	public int getMaxRowNum() {

		return this.maxRow;
	}
	
	// iɁj\錟ʂ́AJns
	public int getShownStartRow() {

		return (this.getShownPageNum()-1) * this.recordCount + 1;				
	}

	// iɁj\錟ʂ́AIs
	public int getShownEndRow() {

		int pageEndRow = this.getShownPageNum() * this.recordCount;
		return (this.getMaxRowNum() < pageEndRow)? this.getMaxRowNum(): pageEndRow;
	}

	// ݃y[W̎̃y[W邩ǂ
	public boolean getHasNext() {
		return getShownPageNum() < getMaxPageNum();
	}
	
	// ݃y[W̑Õy[W邩ǂ
	public boolean getHasPrev() {
		return getShownPageNum() > 1;
	}

	/**
	 * ݃y[Wێ邽߂̃L[擾.
	 * &gt;input type="hidden" name="${pager.currentPageKey}" value="${pager.shownPageNum}" /&lt;
	 * Ƃgz.
	 */ 
	public String getCurrentPageKey() {
		return CURRENT_PAGE_KEY;
	}
	
	// Paging ////////////////////////////////////////////////////////
	
	// y[WOɂAYʂ݂̂ɍi荞
	public RecordSet paging(RecordSet result) {
		
		this.maxRow = (result.isEmpty())? 0: result.getCount();
		
		return result.subSet(this.getShownStartRow(), this.recordCount);
	}

	Map<String, String> pagingJoken = new HashMap<String, String>();
	
	// JSPAvP[V̌擾ł悤ɂ邽߂̃\bh
	public Map<String, String> getJoken() {
		return pagingJoken;
	}

	// AvP[V̌ێ邽߂ Setter
	public String setJoken(String key, String value) {
		return pagingJoken.put(key, value);
	}

}
