package jp.botiboti.flextyle.jsf;

import java.util.Map;

import jp.botiboti.flextyle.core.LogicBase;
import jp.botiboti.flextyle.core.RecordSet;

public class Context extends LogicBase {

	private static final String ERR_MSGS_KEY = "CommonData_ErrorMsgs";
	
	private final Map<String,String[]> reqParameterMap;
	private final Map<String,Object> requestMap;
	private final Map<String,Object> sessionMap;

	private LogicBase.LogicContext trxCtx_ = null;

	protected final LogicBase.LogicContext getTrxContext() {
		return this.trxCtx_;
	}
	
	Context(Map<String,String[]> aReqParameterValues, 
			Map<String,Object> aRequestMap, 
			Map<String,Object> aSessionMap) {
		
		this.reqParameterMap = aReqParameterValues;
		this.requestMap = aRequestMap;
		this.sessionMap = aSessionMap;

		// [U̎擾
		Object userDataObj = this.sessionMap.get("UserData");
		
		// ReLXg쐬
		this.trxCtx_ = new LogicBase.LogicContext(userDataObj);
	}
	
	// gUNV̏I
	protected void finalizeContext() {
				
		// [UZbVɊi[
		sessionMap.put("UserData", this.getUserDataObject());
		
		if (super.hasMessages()) {
			requestMap.put(ERR_MSGS_KEY, super.getMessages());
		}
		// eNX̏I
		super.closeConnection();
		
		// Iɉ
		this.trxCtx_ = null;
	}

	
	/**
	 * NGXgp[^̃}bvԂ܂.
	 * @return
	 */
	public RecordSet getInputData() {
		return new RecordSet(this.reqParameterMap);	
	}
	
//	/**
//	 * NGXgReLXgɁAOtŃf[^Zbg܂.
//	 */
//	public void storeToRequestCtx(String key, Object val) {
//		this.requestMap.put(key, val);
//	}

}
