package jp.botiboti.flextyle.util;

import java.util.Calendar;
import java.util.Date;
import java.sql.Timestamp;

/**
 * t̑s[eBeBNX.
 * @author tanaka ken
 */
public class DateUtil {
  private DateUtil() {
  }

  /**
   * ̃CX^Xϐ̓eXgɋIɓtς
   * sꍇɂ̂ݎgp܂.
   */
  public static Date currentDate_ = null;
  private static int currentDateYear_ = -1;
  private static int currentDateMonth_ = -1;
  private static int currentDateDay_ = -1;

  /**
   * ̃CX^Xϐ̓eXgɋIɓς
   * sꍇɂ̂ݎgp܂.
   */
  public static Timestamp currentTime_ = null;

  /**
   * ݓt擾܂.
   * @return Timestamp
   */
  public static Timestamp today() {
    if (currentDate_ != null) {
      return new Timestamp(currentDate_.getTime());
    }
    return new Timestamp(resetTime(Calendar.getInstance()).getTime().getTime());
  }

  /**
   * ݓ擾܂.
   * @return Timestamp ݓ
   */
  public static Timestamp now() {
    if (currentTime_ != null) {
      return currentTime_;
    }
    if (currentDate_ != null) {
      if (currentDateYear_ == -1) {
        Calendar current = Calendar.getInstance();
        current.setTime(currentDate_);

        currentDateYear_ = current.get(Calendar.YEAR);
        currentDateMonth_ = current.get(Calendar.MONTH);
        currentDateDay_ = current.get(Calendar.DATE);
      }
      Calendar cal = Calendar.getInstance();
      cal.set(Calendar.YEAR, currentDateYear_);
      cal.set(Calendar.MONTH, currentDateMonth_);
      cal.set(Calendar.DATE, currentDateDay_);
      return new Timestamp(cal.getTime().getTime());
    }
    return new Timestamp(System.currentTimeMillis());
  }

  /**
   * j킷lԂ.l̒`́Ajava.util.Calendar NX̂Ƃł.
   * @param date Ώۓ
   * @return int j킷l
   */
  public static int dayOfWeek(Timestamp date) {
    Calendar cal = Calendar.getInstance();
    cal.setTime(date);
    return cal.get(Calendar.DAY_OF_WEEK);
  }

  /**
   * O킷 Timestamp IuWFNgԂ.
   */
  public static Timestamp prevDay(Timestamp date) {
    Calendar cal = cal(date);
    cal.add(Calendar.DATE, -1);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * 킷 Timestamp IuWFNgԂ.
   */
  public static Timestamp nextDay(Timestamp date) {
    Calendar cal = cal(date);
    cal.add(Calendar.DATE, 1);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * 	NO킷 Timestamp IuWFNgԂ.
   */
  public static Timestamp beforeNDay(Timestamp date, int n) {
    Calendar cal = cal(date);
    cal.add(Calendar.DATE, -n);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * N킷 Timestamp IuWFNgԂ.
   */
  public static Timestamp afterNDay(Timestamp date, int n) {
    Calendar cal = cal(date);
    cal.add(Calendar.DATE, n);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * 1O킷 Timestamp IuWFNgԂ.
   * beforeNMonth(date, 1) Ɠ`ł.
   */
  public static Timestamp prevMonth(Timestamp date) {
    return beforeNMonth(date, 1);
  }

  /**
   * 1킷 Timestamp IuWFNgԂ.
   * afterNMonth(date, 1)Ɠ`ł.
   */
  public static Timestamp nextMonth(Timestamp date) {
    return afterNMonth(date, 1);
  }

  /**
   * NO킷 Timestamp IuWFNgԂ.
   */
  public static Timestamp beforeNMonth(Timestamp date, int n) {
    Calendar cal = cal(date);
    cal.add(Calendar.MONTH, -n);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * N킷 Timestamp IuWFNgԂ.
   */
  public static Timestamp afterNMonth(Timestamp date, int n) {
    Calendar cal = cal(date);
    cal.add(Calendar.MONTH, n);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * NNO̓t쐬ĕԂ.
   */
  public static Timestamp beforeNYear(Timestamp date, int n) {
    Calendar cal = cal(date);
    cal.add(Calendar.YEAR, -n);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * NN̓t쐬ĕԂ.
   */
  public static Timestamp afterNYear(Timestamp date, int n) {
    Calendar cal = cal(date);
    cal.add(Calendar.YEAR, n);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * Nxw肵āA4/1 ̓tԂ.
   */
  public static Timestamp firstOfYearCycle(Integer year) {
    Calendar cal = Calendar.getInstance();
    cal.clear();
    cal.set(year.intValue(), Calendar.APRIL, 1);
    resetTime(cal);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * Nxw肵āA3/31 ̓tԂ.
   */
  public static Timestamp lastOfYearCycle(Integer year) {
    Calendar cal = Calendar.getInstance();
    cal.clear();
    cal.set(year.intValue() +1, Calendar.MARCH, 31);
    resetTime(cal);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * tw肵āA4/1 ̓tԂ.
   */
  public static Timestamp firstOfYearCycle(Timestamp date) {

    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH);
    if (month < 3) {
      year--;
    }
  	cal = Calendar.getInstance();
    cal.clear();
    cal.set(year, Calendar.APRIL, 1);
    resetTime(cal);
    return new Timestamp(cal.getTime().getTime());
  }
  
  /**
   * tw肵āA3/31 ̓tԂ.
   */
  public static Timestamp lastOfYearCycle(Timestamp date) {

    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH);
    if (month < 3) {
      year--;
    }
    cal = Calendar.getInstance();
    cal.clear();
    cal.set(year+1, Calendar.MARCH, 31);
    resetTime(cal);
    return new Timestamp(cal.getTime().getTime());
  }
  
  /**
   *@tw肵āANx\ Integer Ԃ.
   */
  public static Integer yearCycle(Timestamp date) {
    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH);
    if (month < 3) {
      year--;
    }
    return new Integer(year);
  }

  /**
   * 擾.
   */
  public static Timestamp firstOfMonth(Timestamp date) {
    Calendar cal = cal(date);
    cal.set(Calendar.DATE, 1);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * 擾.
   */
  public static Timestamp lastOfMonth(Timestamp date) {
    Calendar cal = cal(date);
    cal.set(Calendar.DATE, 1);
    // P
    cal.add(Calendar.MONTH, 1);
    cal.add(Calendar.DATE, -1);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * 擾.
   */
  public static Timestamp firstOfNextMonth(Timestamp date) {
    Calendar cal = cal(date);
    cal.set(Calendar.DATE, 1);
    cal.add(Calendar.MONTH, 1);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * O擾.
   */
  public static Timestamp firstOfPrevMonth(Timestamp date) {
    Calendar cal = cal(date);
    cal.set(Calendar.DATE, 1);
    cal.add(Calendar.MONTH, -1);
    return new Timestamp(cal.getTime().getTime());
  }

  /**
   * tw肵āA̓\ǂԂ.
   * @param date
   * @return
   */
  public static boolean isFirstOfMonth(Timestamp date) {
  	return date.equals(DateUtil.firstOfMonth(date));
  }
  
  /**
   * tw肵āA̓\ǂԂ.
   * @param date
   * @return
   */
  public static boolean isLastOfMonth(Timestamp date) {
  	return date.equals(DateUtil.lastOfMonth(date));
  }
  /**
   * 'yyyyMM' `̕ATimestamp Ԃ.
   * @param str 'yyyyMM'`̕
   * @return w肳ꂽiNjł킳tiP킷tj
   */
  public static Timestamp parseYYYYMM(String str) {
    if (null == str || 6 != str.length()) {
      return null;
    }
    return parseYYYYMMDD(str + "01");
  }

  /**
   * 'yyyyMMdd' `̕ATimestamp Ԃ.
   * @param str 'yyyyMMdd'`̕
   * @return w肳ꂽł킳t
   */
  public static Timestamp parseYYYYMMDD(String str) {

    try {
      if (null == str || 8 != str.length()) {
        return null;
      }
      int year = Integer.parseInt(str.substring(0, 4));
      int mon = Integer.parseInt(str.substring(4, 6));
      int day = Integer.parseInt(str.substring(6, 8));

      Calendar cal = Calendar.getInstance();
      cal.setLenient(false);
      cal.set(year, mon - 1, day);
      return new Timestamp(resetTime(cal).getTime().getTime());
    }
    catch (NumberFormatException e) {
      return null;
    }
  }

  /**
   * tIuWFNgYYYYMMDD`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String YYYYMMDD`̕
   */
  public static String toYYYYMMDD(Date date) {
    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    int dt = cal.get(Calendar.DATE);
    return String.valueOf(year*10000 + month*100 + dt);
  }

  /**
   * tIuWFNgYYYYMM`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String YYYYMM`̕
   */
  public static String toYYYYMM(Timestamp date) {
    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    return String.valueOf(year*100 + month);
  }

  /**
   * tIuWFNgYYYY`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String YYYY`̕
   */
  public static String toYYYY(Timestamp date) {
    Calendar cal = cal(date);
    return String.valueOf(cal.get(Calendar.YEAR));
  }
  
  /**
   * tIuWFNgMM`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String MM`̕
   */
  public static String toMM(Timestamp date) {
    Calendar cal = cal(date);
    return String.valueOf(cal.get(Calendar.MONTH) + 1);
  }
  
  /**
   * tIuWFNgDD`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String DD`̕
   */
  public static String toDD(Timestamp date) {
    Calendar cal = cal(date);
    return String.valueOf(cal.get(Calendar.DATE));
  }
  
  /**
   * tIuWFNgYYYY/MM/DD`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String YYYY/MM/DD`̕
   */
  public static String toYYYYMMDDf(Timestamp date) {
  	return DateUtil.toYYYYMMDDf(date, "/");
  }

  /**
   * tIuWFNgYYYY[؂蕶]MM[؂蕶]DD`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @param delim N̋؂蕶
   * @return String YYYY/MM/DD`̕
   */
  public static String toYYYYMMDDf(Timestamp date, String delim) {

    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    int dt = cal.get(Calendar.DATE);

    return String.valueOf(year*10000 + delim + month*100 + delim + dt);
  }

  /**
   * tIuWFNgYYYY/MM`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @return String YYYY/MM`̕
   */
  public static String toYYYYMMf(Timestamp date) {
  	return DateUtil.toYYYYMMf(date, "/");
  }

  /**
   * tIuWFNgYYYY[؂蕶]MM`̕ƂĕԂ܂.
   * @param date ϊΏۂ̓tIuWFNg
   * @param delim N̋؂蕶
   * @return String 
   */
  public static String toYYYYMMf(Timestamp date, String delim) {

    Calendar cal = cal(date);
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1;
    String month_ = String.valueOf(month);
    if (month < 10) {
    	month_ = "0" + month_;
    }

    return String.valueOf(year + delim + month_);
  }

  /**
   * w肳ꂽt`̕ɃXbVtĕԂ܂.
   * ̃\bhł͈ȉ̓܂.<br>
   * Ew肳ꂽ"/"܂܂ĂꍇÂ܂ܕԂ܂.<br>
   * Ew肳ꂽ񂪂S̏ꍇA"00/00"`̕Ԃ܂.<br>
   * Ew肳ꂽ񂪂ȔꍇA"0000/00"`̕Ԃ܂.<br>
   * Ew肳ꂽ񂪂W̏ꍇA"0000/00/00"`̕Ԃ܂.<br>
   * Ew肳ꂽ񂪂SAUAWȊȌꍇÂ܂ܕԂ܂.<br>
   *
   * @param str 4A6A8̓t
   * @return XbVҏWςݕ
   */
  public static String format(String str) {
    if (str == null || str.indexOf('/') != -1) {
      return str;
    }
    if (str.length() == 4) {
      return str.substring(0,2) + "/" + str.substring(2,4);
    }
    if (str.length() == 6) {
      return str.substring(0,4) + "/" + str.substring(4,6);
    }
    if (str.length() == 8) {
      return str.substring(0,4) + "/" + str.substring(4,6) + "/" + str.substring(6,8);
    }
    return str;
  }

  /**
   * Ɋ܂܂XbV폜ĕԂ܂. XbV܂܂Ȃꍇ͂̂܂ܕԂ܂.
   * @param str ϊΏە
   * @return XbV폜ςݕ
   */
  public static String strip(String str) {
    if (str.indexOf('/') == -1) {
      return str;
    }
    StringBuffer buf = new StringBuffer();
    for (int i = 0; i < str.length(); i++) {
      if (str.charAt(i) == '/') {
        continue;
      }
      buf.append(str.charAt(i));
    }
    return buf.toString();
  }
  
  /**
   * w肵̘aî݁jԂ.
   * <p>
   * At͍lȂ.
   * </p>
   * @param str i1981N`j
   * @return
   */
  public static String wareki(String str) {
	  
	  int yyyy = Integer.parseInt(str);
	  
	  int wareki = yyyy - 1989;
	  
	  return String.valueOf(wareki+1);
  }

  // ** private methods ****************************

  /**
   * tw肵ăJ_[IuWFNg擾܂.
   * ߂l̃J_[IuWFNg̎ԕ͂OŏĂ܂.
   * @param date tw肷iԕ͖܂.)
   * @return Calendar J_[IuWFNg
   */
  private static Calendar cal(Date date) {
    Calendar cal = Calendar.getInstance();
    cal.setTime(date);
    return resetTime(cal);
  }

  // J_[NXt݂̂ɂȂ悤ɃZbg.
  private static Calendar resetTime(Calendar cal) {
    cal.set(Calendar.HOUR_OF_DAY, 0);
    cal.set(Calendar.MINUTE, 0);
    cal.set(Calendar.SECOND, 0);
    cal.set(Calendar.MILLISECOND, 0);
    return cal;
  }

}
