package jp.botiboti.flextyle.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter extends Formatter {
	
  /**
   * Log̏o͕𐶐B
   * o͏F<br>
   * N/// ::b.~b XbhID Ox NX::\bh bZ[W
   */    
  @Override
  public synchronized String format(final LogRecord aRecord) {
      
  	final StringBuffer message = new StringBuffer(131);

  	message.append(String.format("%tD %<tT.%<tL", aRecord.getMillis()));
  	message.append(' ');
  	message.append(aRecord.getThreadID());
  	message.append(' ');
  	message.append(aRecord.getLevel().toString());
  	message.append(' ');

  	String className = aRecord.getSourceClassName();
  	message.append(className != null ? className : aRecord.getLoggerName());
  	message.append("::");
  	String methodName = aRecord.getSourceMethodName();
  	message.append(methodName != null ? methodName : "N/A");
  	message.append(" ");
  	
  	message.append(formatMessage(aRecord));
  	message.append('\n');
  	
  	Throwable throwable = aRecord.getThrown();
  	if (throwable != null) {
  		
  		message.append(throwable.toString());
  		message.append('\n');
  		for (StackTraceElement trace : throwable.getStackTrace()) {
  			message.append('\t');
  			message.append(trace.toString());
  			message.append('\n');
  		}
  	}
  	return message.toString();
  }
  
}