package jp.botiboti.flextyle.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

import jp.botiboti.flextyle.core.SystemException;

public class PropertyUtil {

	@SuppressWarnings("unchecked")
	public static Object get(Object obj, String name) {		
		try {
			if (obj instanceof Map)
				return ((Map)obj).get(name);
			
			Method getter = obj.getClass().getMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1));
			return getter.invoke(obj);
		}
		catch (NoSuchMethodException ex) {
			throw new SystemException("object[" + obj + "] has not property[" + name + "].", ex);			
		}
		catch (IllegalAccessException ex) {
			throw new SystemException("access to property[" + name + "] of object[" + obj + "] is not allowed.", ex);			
		}
		catch (InvocationTargetException ex) {
			throw new SystemException("exception occurred while calling getter method.", ex);
		}
	}

	public static Object getIgnoreError(Object obj, String name) {		
		try {
			return PropertyUtil.get(obj, name);
		}
		catch (Exception ex) {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public static void set(Object obj, String name, Object param) {		
		try {
			if (obj instanceof Map)
				((Map)obj).put(name, param);
			
			Method getter = obj.getClass().getMethod("set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), param.getClass());
			getter.invoke(obj, param);
		}
		catch (NoSuchMethodException ex) {
			throw new SystemException("object[" + obj + "] has not property[" + name + "].", ex);			
		}
		catch (IllegalAccessException ex) {
			throw new SystemException("access to property[" + name + "] of object[" + obj + "] is not allowed.", ex);			
		}
		catch (InvocationTargetException ex) {
			throw new SystemException("exception occurred while calling getter method.", ex);
		}
	}

	public static void setIgnoreError(Object obj, String name, Object param) {		
		try {
			PropertyUtil.set(obj, name, param);
		}
		catch (Exception ex) {
			;
		}
	}
}
