package jp.botiboti.flextyle.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import jp.botiboti.flextyle.core.SystemException;

public class Util {
	
	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
	private Util() { }

  /**
   * Ŏw肳ꂽ񂪁AŎw肳ꂽTCYijɂȂ悤ɃXy[X߂܂.
   * ɕȊÕIuWFNgw肳ꂽꍇ́Asrc.toString()ʂԂ܂.
   * @param src Ώە
   * @param size Xy[X߂̃TCY
   * @return ϊ㕶
   */
  public static String fill(Object src, int size) {
    return (src instanceof String)? fill((String)src, size, ' '): src.toString();
  }

//  /**
//   * Ŏw肳ꂽ񂪁AŎw肳ꂽTCYijɂȂ悤ɃXy[X߂܂.
//   * @param src Ώە
//   * @param size Xy[X߂̃TCY
//   * @return ϊ㕶
//   */
//  public static String fill(String src, int size) {
//    return fill(src, size, ' ');
//  }

  public static boolean notEquals(String str1, String str2) {
    return !(str1 == str2 || (str1 != null && str1.equals(str2)));
  }
	  
  /**
   * @param str1 `FbNΏە
   * @return w肳ꂽNull܂̓uN̂ƂtrueԂ܂.
   */
  public static boolean isNullOrBlank(String str1) {
    return (str1 == null || str1.equals(""));
  }
	  
  /**
   * @param str1 `FbNΏە
   * @return w肳ꂽNull܂̓uN̂ƂtrueԂ܂.
   */
  public static boolean isNotNullOrBlank(String str1) {
    return !(str1 == null || str1.equals(""));
  }
  
  /**
   * @param str `FbNΏە
   * @return w肳ꂽ񂪐ō\ĂꍇtrueԂ
   */
  public static boolean isNumber(String str) {
	  for (int i = 0, max = str.length(); i < max; i++) {
		  char c = str.charAt(i);
		  if (c < '0' && c > '9')  return false;
	  }
	  return true;
  }
	  
  /**
   * Ŏw肳ꂽ񂪁AŎw肳ꂽTCYijɂȂ悤ɁA
   * Ŏw肳ꂽŕ⊮܂.
   * @param src Ώە
   * @param size ⊮̃TCY
   * @return ϊ㕶
   */
  public static String fill(String src, int size, char ch) {
    if (src.length() >= size) return src;
    StringBuffer buf = new StringBuffer(src);
    while (buf.length() < size) {
      buf.append(ch);
    }
    return buf.toString();
  }

  /**
   * Ŏw肳ꂽlAŎw肳ꂽTCYij̕
   * Ȃ悤ɁA[߂܂.
   * @param src Ώېl
   * @param size ⊮̃TCY
   * @return ϊ㕶
   */
  public static String zeroPad(Number src, int size) {
	int iSrc = src.intValue(); 
    if (iSrc >= Math.pow(10, size-1)) return src.toString();
    StringBuffer buf = new StringBuffer().append(iSrc);
    while (buf.length() < size) 
      buf.insert(0, "0");
    
    return buf.toString();
  }

  /**
   * ̃gp\bh.
   * src  String ^ł͂ȂꍇAsrc.toString() lgĕԂ.
   * src  null ̏ꍇɂG[ƂȂȂ.
   * @param src Object gΏە
   * @return String g㕶
   */
  public static String trim(Object src) {
    return (src != null)? src.toString().trim(): (String)src;
  }

  public static String trimW(String str) {
  	final char SPACE = ' ';
    final char ZSPACE = '@';
    
    if (str == null)
    	return null;
    
    int head = 0;
    int tail = str.length() - 1;
    
    for (int i = 0, length = str.length(); i < length; i++) {
    	char c = str.charAt(i);
    	if (c == SPACE || c == ZSPACE)
    		head++;
    	else
    		break;
    }

    for (int i = str.length() -1; i > head; i--) {
    	char c = str.charAt(i);
    	if (c == SPACE || c == ZSPACE)
    		tail--;
    	else
    		break;
    }
    return str.substring(head, tail+1);
  }
  
  /**
   * Ŏw肳ꂽlNULL̏ꍇɁAŎw肳ꂽlԂ܂.
   * @param obj NULLǂ̔IuWFNg
   * @param replace obj==null̏ꍇɒuIuWFNg
   * @return ʃIuWFNg
   */
  public static <T> T ifnull(T obj, T replace) {
    return obj == null? replace: obj;
  }

  /**
   * Ŏw肳ꂽNULL̏ꍇɁA󕶎""Ԃ܂.
   * @param str NULL̏ꍇɁA󕶎ɒu镶
   * @return String ʕ
   */
  public static String nullToBlank(String str) {
    return ifnull(str, "");
  }

  /**
   * Ŏw肳ꂽ񂪋󕶎""̏ꍇɁANULLԂ܂.
   * @param str 
   * @return String ʕ
   */
  public static String blankToNull(String str) {
	  return "".equals(str)? null: str;
  }

  /**
   * JDK1.3 ł String.split \bhȂ̂ŁA̋@\.
   * @param str O̕
   * @param separator L
   * @return String[] ̕
   */
  public static String[] split(String str, String separator) {
    return split(str, separator, Integer.MAX_VALUE);
  }

  /**
   * JDK1.3 ł String.split \bhȂ̂ŁA̋@\.
   * @param str O̕
   * @param separator L
   * @param count i. Qɕꍇ 2 w肷j
   * @return String[] ̕
   */
  public static String[] split(String str, String separator, int count) {
    List<String> list = null;
    int index = 0;

    for (int i = 1; i < count && str.indexOf(separator, index) != -1; i++) {
      if (list == null) list = new ArrayList<String>();

      int tmpIndex = str.indexOf(separator, index);
      list.add(str.substring(index, tmpIndex));
      index = tmpIndex + separator.length();
    }
    // separator ݂Ȃꍇ
    if (list == null) return new String[]{ str };

    list.add(str.substring(index));
    return (String[])list.toArray(new String[list.size()]);
  }

  public static String insert(String src, int pos, String str) {
  	return (src.length() < pos)? src: src.substring(0, pos) + str + src.substring(pos);  
  }

  // MD5gĈÍ
  public static String toMD5(String str) {
	  
  	try {
  		MessageDigest md = MessageDigest.getInstance("MD5");
  		md.update(str.getBytes());
  		
  		byte[] digest = md.digest();
  		StringBuffer sb = new StringBuffer();
  		
  		for(int i = 0; i < digest.length; i++) {
  			sb.append(Integer.toHexString((digest[i] >> 4) & 0x0f)); // ʃju1
  			sb.append(Integer.toHexString( digest[i] & 0x0f)); // ʃju1
  		}
  		return new String(sb);	  
  	}
  	catch (NoSuchAlgorithmException exp) {
  		throw new SystemException("Í[MD5]܂łB", exp);
  	}
  }
  
  /**
   * ́A${hoge}̕ params.get("hoge") Œu.
   *  
   * @param str u
   * @param params uΏەi[}bv
   * @return u㕶
   */
  public static String replace(String str, Map<String,Object> params) {
  	return replace(str, params, 0);
  }
  
  /**
   * ́A${hoge}̕ params.get("hoge")[index] Œu.
   *  
   * @param str u
   * @param params uΏەi[}bv
   * @param index CfbNXt̏ꍇɎw肷CfbNX
   * @return u㕶
   */
  public static String replace(String str, Map<String,Object> params, int index) {
  	return replace(str, params, index, "${", "}");
  }

  /**
   * ́A[BEGIN_]hoge[_END]̕ params.get("hoge")[index] Œu.
   *  
   * @param str u
   * @param params uΏەi[}bv
   * @param index CfbNXt̏ꍇɎw肷CfbNX
   * @param BEGIN_ uΏۃL[̊Jn
   * @param _END uΏۃL[̏I
   * @return u㕶
   */
  public static String replace(
  		String str, Map<String,Object> params, int index, String BEGIN_, String _END) {

    String[] partsSQL = Util.split(str, BEGIN_);
    if (partsSQL.length == 1) {
      return str;
    }

    StringBuffer buf = new StringBuffer(partsSQL[0]);

    for (int i = 1; i < partsSQL.length; i++) {

      // Lŕ
      String[] splited = Util.split(partsSQL[i], _END, 2);

      // L݂Ȃꍇ
      if (splited == null || splited.length == 1) {
        log.fine("̒u ${} ̋LqɌ肪܂.");
        buf.append(partsSQL[i]);
        continue;
      }
      
      boolean isIndexedParams =
        splited[0].trim().endsWith("[n]") || splited[0].trim().endsWith("[i]");

      String paramKey = isIndexedParams ? splited[0].substring(0, splited[0].length()-3): splited[0];
      
      // uϐ݂Ȃꍇ
      if (params.get(paramKey) == null) {
      	
      	log.fine("̒u[" + paramKey + "]ɊYl܂:" + params);
      	buf.append(partsSQL[i]);
      	continue;
      }

      // uϐ擾
      Object obj = params.get(paramKey);

      // zA܂̓Xg̏ꍇ
      if (obj.getClass().isArray() || obj instanceof List) {
        Object[] objs = (obj instanceof List)? ((List<?>)obj).toArray(): (Object[])obj;

        // CfbNXt̃p[^̏ꍇ
        if (isIndexedParams) 
          buf.append(ifnull(objs[index], ""));
        // CfbNXtł͂Ȃiʏ́jp[^̏ꍇA0Ԗڂgp
        else
         buf.append(ifnull(objs[0], ""));
        
      }
      // zAXgȊȌꍇ
      else {
        buf.append(ifnull(obj, ""));
      }
      // ǔ̕A
      buf.append(splited[1]);
    }

    // sSQLm
    return buf.toString();
  }
  
}
