package jp.botiboti.flextyle.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet implementation class for Servlet: DataSourceServlet
 * ;
 */
public class DataSourceServlet extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {
	static final long serialVersionUID = 1L;
	static final String PROPERTY_FILE_DIR = "conf";
	static final String PROPERTY_FILE = "conf" + File.separator + "datasource.properties";
	
	public DataSourceServlet() {
		System.out.print("datasource servlet start.");
	}
	/** override */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doPostOrGet(request, response);
	}  	
	
	/**	override */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doPostOrGet(request, response);
	}
	
	private void doPostOrGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    Properties prop = new Properties();
    
    File file = new File(PROPERTY_FILE_DIR);
    if (!file.exists())
    	// efBNg쐬
    	file.mkdirs();
    else {
    	InputStream istream = null;
    	
    	try { 
    		istream = new FileInputStream(PROPERTY_FILE); 	
    	
    		prop.load(istream);
    		istream.close();
    		
    	}	catch (FileNotFoundException ignore) { 	}
    }

		// o^̏ꍇ
		if (request.getParameter("actionRegister") != null) {
			
			prop.setProperty("driverClass" , request.getParameter("driverClass"));
			prop.setProperty("url" , request.getParameter("url"));
			prop.setProperty("user" , request.getParameter("user"));
			prop.setProperty("password" , request.getParameter("password"));
      
      // save
			OutputStream ostream = new FileOutputStream(PROPERTY_FILE);
      prop.store(ostream, "this file is auto saved, and configure application datasouce.");
      
      ostream.close();
		}
		
		response.setContentType("text/html; charset=UTF-8");
		// ʍ쐬
		PrintWriter writer = response.getWriter();
		writer.write("<html>");
		writer.write("<head><title>Flextyle Datasource Configuration</title></head>");
		writer.write("<body><form action=\"./DataSourceConfig\" method=\"post\" />");
		writer.write("<div style=\"margin:200px auto 0px auto; border:solid 2px #dddddd; width:360px; text-align:center; padding: 4px;\">");
		writer.write("<table style=\"color:#666666; font-weight:bold;\" >");
		writer.write("");
		writer.write("<tr><td>JDBChCo[NX</td><td><input type=\"text\"     name=\"driverClass\" value=\"" + prop.getProperty("driverClass")+ "\" /></td></tr>");
		writer.write("<tr><td>f[^x[XURL			</td><td><input type=\"text\"     name=\"url\" value=\"" + prop.getProperty("url")+ "\" /></td></tr>");
		writer.write("<tr><td>ڑ[U				</td><td><input type=\"text\"     name=\"user\" value=\"" + prop.getProperty("user")+ "\" /></td></tr>");
		writer.write("<tr><td>ڑpX[h			</td><td><input type=\"password\" name=\"password\" value=\"" + prop.getProperty("password")+ "\" /></td></tr>");
		writer.write("");
		writer.write("</table>");
		writer.write("<input type=\"submit\" style=\"padding:3px;width:80px;font-size:12px;\" name=\"actionRegister\" value=\"o^\" />");
		writer.write("</div>");
		writer.write("</form></body>");
		writer.write("</html>");
		
		writer.flush();
	}
	
}