package jp.botiboti.flextyle.web;

import static jp.botiboti.flextyle.util.Util.isNotNullOrBlank;
import static jp.botiboti.flextyle.web.WebErrorUtil.writeErrorPage;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.botiboti.flextyle.core.ConnectionFactory;
import jp.botiboti.flextyle.core.RecordSet;
import jp.botiboti.flextyle.util.Log;
import jp.botiboti.flextyle.util.ReflectionUtil;

public class DispatchFilter implements Filter {
	
	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(datasource-jndi)̃L[̒`
	 */
	public static final String INI_KEY_DATASOURCE_JNDI = "datasource-jndi";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(url-pattern)̃L[̒`
	 */
	public static final String INI_KEY_URL_PATTERN = "url-pattern";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(class-name)̃L[̒`
	 */
	public static final String INI_KEY_CLASS_NAME = "class-name";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(method-name)̃L[̒`@
	 */
	public static final String INI_KEY_METHOD_NAME = "method-name";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(parameter)̃L[̒`@
	 */
	public static final String INI_KEY_PARAMETER = "parameter";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(navigator-aliases)̃L[̒`
	 */
	public static final String INI_KEY_NAVIGATOR_ALIASES = "navigator-aliases";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(run-mode)̃L[̒`@
	 */
	public static final String INI_KEY_RUNMODE = "run-mode";
	
	/**
	 * DispatchFilterfvCgLqqɋLqƂ́AIvV(groovy-filepath)̃L[̒`@
	 */
	public static final String iNI_KEY_GROOVY_PATH = "groovy-filepath";
	
	// ZbVɃ_CNg̊Ԃێf[^i[Ƃ̃L[
	private static final String SES_KEY_FOR_REDIRECT = DispatchFilter.class.getName() + "_DataForRedirect";
	
	// G[bZ[WNGXgɊi[Ƃ̃L[
	private static final String MESSAGES_KEY = "Messages";

	// rWlXIuWFNgւ̃fBXpb`iIuWFNg
	private Dispatcher dispatcher = null;
	
	// url parser of related this filter.
	private DispatchParser parser = null;
	
	// ʑJځiJSPւ̃tH[hj肷IuWFNg
	private PageNavigator navigator = null;

	// interface for get deployment timestamp.
	private interface DeployTimestamp {
		String get();
	}
	
	// object for get deployment timestamp.
	private DeployTimestamp deployTimestamp = null;

	/**
	 * p[^̓ǂݍ
	 */
	public void init(FilterConfig arg0) throws ServletException {
				
		{ 
			final String jndi = arg0.getInitParameter(INI_KEY_DATASOURCE_JNDI); if (isNotNullOrBlank(jndi)) {
			// NXConnectionFactoryp
			new ConnectionFactory() {
				private void init() {
					ConnectionFactory.initialize(jndi.startsWith("java:comp/env/") ? jndi: "java:comp/env/" + jndi);
				}
			}.init();
		}}

		{ 
			this.parser = new DispatchParser();
			this.parser.setUrlPattern(arg0.getInitParameter(INI_KEY_URL_PATTERN));
			this.parser.setClassNameExpression(arg0.getInitParameter(INI_KEY_CLASS_NAME));
			this.parser.setMethodNameExpression(arg0.getInitParameter(INI_KEY_METHOD_NAME));

			String exp = arg0.getInitParameter(INI_KEY_PARAMETER + "1");
			List<String> li = null;
			for (int i = 1; isNotNullOrBlank(exp); i++, exp = arg0.getInitParameter(INI_KEY_PARAMETER + i))
				(li == null? li = new ArrayList<String>(): li).add(exp);
				
			this.parser.setParameterExpressions(li);
		}
		
		{
			String exp = arg0.getInitParameter(INI_KEY_RUNMODE);
			if (exp != null && exp.equals("product")) {
				final String timestamp = "?" + System.currentTimeMillis();
				this.deployTimestamp = new DeployTimestamp() {	public String get() { return timestamp; }	};
			}
			else
				this.deployTimestamp = new DeployTimestamp() {	public String get() { return "?" + System.currentTimeMillis(); }	};
		}

		{
			String fnm = arg0.getInitParameter(INI_KEY_NAVIGATOR_ALIASES); 			
			String fileName = isNotNullOrBlank(fnm)? fnm: PageNavigator.defaultNavigatorAliases;
			this.navigator = new PageNavigator(arg0.getServletContext().getRealPath(fileName));
		}
		
		{
			String groovyPath = arg0.getInitParameter(iNI_KEY_GROOVY_PATH);
			this.dispatcher = isNotNullOrBlank(groovyPath) ? new DispatcherWithGroovy(groovyPath): new Dispatcher();
		}
	}

	/**
	 * \bhfBXpb`̎s
	 * @param arg0 NGXgIuWFNg
	 * @param arg1 X|XIuWFNg
	 * @param chain tB^[`F[
	 */
	public void doFilter(ServletRequest arg0, ServletResponse arg1,	FilterChain chain) {
		try {
			this.doFileterImpl((HttpServletRequest)arg0, (HttpServletResponse)arg1, chain);
		}
		catch (RuntimeException ex) {
			writeErrorPage((HttpServletResponse)arg1, ex.getMessage(), ex);
		}
		catch (Exception ex) {
			writeErrorPage((HttpServletResponse)arg1, ex.getMessage(), ex);
		}	
	}
	
	/*
	 * \bhfBXpb`̎\bh
	 * @param req NGXgIuWFNg
	 * @param res X|XIuWFNg
	 * @param chain tB^[`F[
	 */
	private void doFileterImpl(HttpServletRequest req, HttpServletResponse res,	FilterChain chain) throws IOException, ServletException {
	
		{ 
			String pInfo = req.getPathInfo(); if (pInfo != null) {
    	if (pInfo.startsWith("/WEB-INF") || pInfo.startsWith("/META-INF")) { 
				res.setStatus(404);
      	return;
     	}
    }}

		{ 
			if (req.getCharacterEncoding() == null)
				req.setCharacterEncoding("UTF-8");

			req.setAttribute("timestamp", this.deployTimestamp.get());
		}
		
		{ 
			if (req.getSession() != null) {
				
				@SuppressWarnings("unchecked")
				Map<String,Object> tmp = (Map<String,Object>)req.getSession().getAttribute(DispatchFilter.SES_KEY_FOR_REDIRECT);
				
				if (tmp != null) {
					for (String s: tmp.keySet()) {
						Object obj = tmp.get(s);
						req.setAttribute(s, obj instanceof RecordSetForJSP ?	((RecordSetForJSP)obj).getRecordSet(): obj);
					}
					req.getSession().removeAttribute(DispatchFilter.SES_KEY_FOR_REDIRECT);
				}
			}
		}
		
		String url = req.getPathInfo() == null? req.getServletPath(): req.getPathInfo() + req.getServletPath();
		Matcher matcher = this.parser.parse(url);
			
		// whether matches url-pattern ?
		if (! matcher.matches()) {			
			chain.doFilter(req, res);	return;
		}

		String className = this.parser.getClassName(matcher);
		String methodName = this.parser.getMethodName(matcher);
		List<String> parameter = this.parser.getParameters(matcher, url);

		WebBean bean = this.dispatcher.createWebBean(className);
		Object obj = this.dispatcher.dispatch(req, res, bean, methodName, parameter);

		if (obj == null || !(obj instanceof String)) {
			writeErrorPage(res, "return value of accessed method [" + className + ". " + methodName + "] is invalid." + obj, null);
			return;
		}

		final String result = (String)obj;

		// Bean Ń_CNgpɕۑistoreForRedirectjꂽf[^΃ZbVɃZbg
		{ 
			Map<String,Object> tmp;	if ((tmp  = bean.getStoredForRedirect()) != null) {
			
				for (String s: tmp.keySet()) {
					if (tmp.get(s) instanceof RecordSet)
						tmp.put(s, new RecordSetForJSP((RecordSet)tmp.get(s)));
				}
				req.getSession().setAttribute(SES_KEY_FOR_REDIRECT, tmp);
			}
		}

		// Bean ŕۑꂽG[bZ[W΃NGXgɃZbg
		{ 
			if (bean.hasMessages()) {
				req.setAttribute(MESSAGES_KEY, bean.getMessages());
			}
		}
		
		// JSON`̃f[^̏ꍇ
		if (result.startsWith("{")) {
			
			this.writeText(res, result); 
			return;
		}
		
		// ̂܂܃X|Xɏޕf[^̏ꍇ
		else if (result.startsWith(WebBean.returnEcho)) {
			
			this.writeText(res, result.substring(WebBean.returnEcho.length())); 
			return;
		}
		
		// ʂURLi_CNgj̏ꍇ
		else if (result.startsWith(WebBean.returnRedirect)) {
			
			res.sendRedirect(result.substring(WebBean.returnRedirect.length())); 
			return;
		}
		
		// NXŏꍇ
		else if (result.startsWith(WebBean.returnWriterClass)) {
		
			// Bean ŕۑistorejꂽf[^NGXgɃZbg
			{ 
				Map<String,Object> tmp; if ((tmp = bean.getStoredValues()) != null) {

					String prefix = className.substring(className.lastIndexOf('.')+1) + ".";
					for (String s: tmp.keySet())
						req.setAttribute(prefix + s, tmp.get(s));
				}
			}
			
			new ReflectionUtil<WebWriter>() {
				public WebWriter impl() throws Exception {
					return (WebWriter)Class.forName(result.substring(WebBean.returnWriterClass.length())).newInstance();
				}
			}.createInstance().write(req, res);
			
			return;
		}

		// Bean ŕۑistorejꂽf[^΃NGXgɃZbg
		{ 
			Map<String,Object> tmp;	if ((tmp = bean.getStoredValues()) != null) {

				for (String s: tmp.keySet()) {
					if (tmp.get(s) instanceof RecordSet)
						tmp.put(s, new RecordSetForJSP((RecordSet)tmp.get(s)));
				}
				req.setAttribute(className.substring(className.lastIndexOf('.')+1), tmp);
			}
		}

		// other case, go forward.		
		String symbol = result;
		
		// resolve aliases, if exists 
		if (this.navigator.isValid()) {
				// TODO: implementation..
		}

		// forward
		req.getRequestDispatcher(symbol).forward(new ForwardRequestWrapper(req), res);
	}
	
	/**
	 * j
	 */
	public void destroy() {	}
	
	// f[^̂܂܃X|Xɏo͂
	private void writeText(HttpServletResponse response, String textdata) {
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain; charset=UTF-8");
		
		PrintWriter writer; try {
			response.setHeader("progma","no-cache");
			response.setHeader("Cache-Control","no-cache");
			response.setDateHeader("Expires" , -1);
			writer = response.getWriter();
		}
		catch (IOException ioEx) {
			log.log(Level.SEVERE, "X|Xf[^쐬ɁAIOG[܂B", ioEx); return;
		}
		writer.write(textdata);
		writer.close();
	}
  
}