package jp.botiboti.flextyle.web;

import static jp.botiboti.flextyle.util.Util.isNotNullOrBlank;
import static jp.botiboti.flextyle.util.Util.isNullOrBlank;
import static jp.botiboti.flextyle.util.Util.isNumber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * URLANXA\bhAp[^擾ij
 * ߂̃NX
 * 
 * @author tanaka ken
 */
public class DispatchParser {
	
	private static DispatchParser defaultInstance = null;	
  
  DispatchParser() {
  	if (defaultInstance == null) defaultInstance = this;
  }
  
	/**
	 * @return first created instance of DispatchParser 
	 */
  public static final DispatchParser defaultInstance() {	return defaultInstance;	}
	
	/**
	 * url-pattern ̃ftHgl
	 */
	public static final String defaultUrlPattern = "/(?:[^/]+/)*([a-zA-Z_][\\w\\.]*[\\w])::([a-zA-Z_][\\w]+)(?::([^:]*))?(?::([^:]*))?(?::([^:]*))?(?::([^:]*))?";

	/**
	 * class-name ̃ftHgl
	 */
	public static final String defaultExpressionOfClassName = "$1";

	/**
	 * method-name ̃ftHgl
	 */
	public static final String defaultExpressionOfMethodName = "$2";
	
	/**
	 * parameter ̃ftHgl
	 */
	public static final String[] defaultExpressionOfParameter = {"$3", "$4", "$5", "$6"};

	// interface for parse string(ex.className, methodName, etc) from url string.
	private interface StrFromURL {	
		String get(Matcher urlMatcher); 
	};
	
	// 
	private StrFromURL classNameFromURL = null;
	//
	private StrFromURL methodNameFromURL = null;
	//
	private StrFromURL[] parameterFromURL = null;
	//
	private Pattern urlPattern = null;
	
	public void setUrlPattern(String ptrn) {
		this.urlPattern = Pattern.compile((isNullOrBlank(ptrn)? defaultUrlPattern: ptrn));
	}
	
	public void setClassNameExpression(String exp) {
		String expression = isNotNullOrBlank(exp)? exp: defaultExpressionOfClassName;
		this.classNameFromURL = this.StrFromURLObject(expression);
	}
	
	public void setMethodNameExpression(String exp) {
		String expression = isNotNullOrBlank(exp)? exp: defaultExpressionOfMethodName;
		this.methodNameFromURL = this.StrFromURLObject(expression);			
	}
	
	public void setParameterExpressions(List<String> li) {
		this.parameterFromURL = new StrFromURL[li == null ? defaultExpressionOfParameter.length: li.size()];
		for (int i = 0; i < this.parameterFromURL.length; i++)
			this.parameterFromURL[i] = this.StrFromURLObject(li == null ? defaultExpressionOfParameter[i]: li.get(i));
	}
	
	public static class ParseResult {
		public String className;
		public String methodName;
		public List<String> parameters;
	}
	
	public Matcher parse(String url) {
		return this.urlPattern.matcher(url);	
	}

	public String getClassName(Matcher matcher) {
		String className = this.classNameFromURL.get(matcher);
	  // XbV؂̏ꍇ́Ahbg؂
		return className.indexOf('/') == -1? className: className.replace('/', '.');
	}
	
	public String getMethodName(Matcher matcher) {
		return this.methodNameFromURL.get(matcher);
	}
	
	public List<String> getParameters(Matcher matcher, String url) {
		
		List<String> parameter = null;
		for (int i = 0; i < this.parameterFromURL.length; i++) {
			
			String s = this.parameterFromURL[i].get(matcher);		
			
			if (s == null)	break; else if (s.equals("")) continue;
		
			if (parameter == null) {
				parameter = new ArrayList<String>();
				if (i != 0) parameter.addAll(Collections.nCopies(i, (String)null));
			}
			parameter.add(s);
		}

		return parameter;
	}
	
	
	// expression ̒́A$1,$2,$3..𓮓Iɒu悤ɂ邽߂
	// IuWFNgi=StrFromURLj쐬
	private StrFromURL StrFromURLObject(String expression) {
		// $d݂̂ō\Ăꍇ
		if (expression.startsWith("$") && isNumber(expression.substring(1))) {
			final int i = Integer.parseInt(expression.substring(1));
			return new StrFromURL() {
				public String get(Matcher urlMatcher) {
					return urlMatcher.group(i);	
				}
			};
		}
		
		final String[] partsOfExprssn = expression.split("\\$[\\d]+", -1);

		Matcher replace$Matcher = Pattern.compile(".*(\\$[\\d]+).*").matcher(expression);
		final int[] replace$Index = new int[replace$Matcher.matches() ? replace$Matcher.groupCount(): 0];
		
		for (int i = 1, max = replace$Index.length; i <= max; i++)
			replace$Index[i-1] = Integer.parseInt(replace$Matcher.group(i).substring(1));
		
		return new StrFromURL() {
			public String get(Matcher urlMatcher) {
				StringBuffer result = new StringBuffer(partsOfExprssn[0]);
				for (int i = 1; i < partsOfExprssn.length; i++) {
					result.append( urlMatcher.group(replace$Index[i-1]) );
					result.append( partsOfExprssn[i] );
				}
				return result.toString();
			}
		};
	}
}
