package jp.botiboti.flextyle.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 * Wrapper of HttpServletRequest for forwarding. 
 */
public class ForwardRequestWrapper extends HttpServletRequestWrapper {	

	private String servletPath;
	private String pathInfo;
	private String requestURI;
	private StringBuffer requestURL;

	ForwardRequestWrapper(HttpServletRequest request) {
		super(request);
		this.servletPath = request.getServletPath();
		this.pathInfo = request.getPathInfo();
		this.requestURI = request.getRequestURI();
		this.requestURL = request.getRequestURL();
	}
	
	public String getOriginalServletPath() { return this.servletPath;	}
	public String getOriginalPathInfo() { return this.pathInfo;	}
	public String getOriginalRequestURI() { return this.requestURI;	}
	public StringBuffer getOriginalRequestURL() { return this.requestURL; }
}
