package jp.botiboti.flextyle.web;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import jp.botiboti.flextyle.util.Log;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PageNavigator {

	private static final Logger log = new Log.LoggerFriend() { }.fxt();
	
	/**
	 * navigator-aliases ̃ftHgt@CpX
	 */
	public static final String defaultNavigatorAliases = "/WEB-INF/navigator-aliases.xml";

	// ʑJځiJSPւ̃tH[hjsۂɎgpGCAX̃RNV
	private Map<String,String> navigatorAliases = null;

	public PageNavigator(String filename) {
		File file = new File(filename);
		
		// t@C݂Aǂݍ߂ꍇ
		Document root = null;
		if (file.exists() && (root = getDocument(file)) != null) {
			// GCAX擾				
			this.navigatorAliases = new HashMap<String,String>();
			root.getDocumentElement();
			// TODO: implementation.
		}
	}

	public String getForward(String symbol) {
		return this.navigatorAliases.get(symbol);
	}
	
	// XMLt@CǂݍŁADocumentIuWFNg擾
	private Document getDocument(File xml) {
		try {
			return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
		}
		catch (ParserConfigurationException ex) {
			log.log(Level.SEVERE, xml.getName()+"̓ǂݍ݂ŃG[܂B", ex);
		}
		catch (SAXException ex) {
			log.log(Level.SEVERE, xml.getName()+"̓ǂݍ݂ŃG[܂B", ex);			
		}
		catch (IOException ex) {
			log.log(Level.SEVERE, xml.getName()+"̓ǂݍ݂ŃG[܂B", ex);			
		}
		return null; 
	}
	
	/**
	 * @return PageNavigatorLł邩ǂԂ.
	 */
	public boolean isValid() {
		return false;
	}
}
