package jp.botiboti.flextyle.web;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import jp.botiboti.flextyle.core.Logic;
import jp.botiboti.flextyle.core.RecordSet;

public class WebBean extends Logic {
	static final String returnEcho = "Echo: ";
	static final String returnRedirect = "Location: ";
	static final String returnWriterClass = "WriterClass: ";
	
	private RequestWrapper request = null;
	private Map<String,Object> storeValueMap_ = null;
	private Map<String,Object> storeForRedirectMap_ = null;
	
	protected final void setRequest(RequestWrapper req) {
		this.request = req;
	}

	/**
	 * this method returns request parameter and request attributes.
	 * this method equals getParameters() and getAttributes().
	 * @return
	 */
	protected final RecordSet getInputData() {

		Map<String,Object> attrs = this.request.getAttributeMap();
		Map<String,Object> params = this.request.getParameterMap();
		
		if (attrs == null || attrs.isEmpty()) 
			return new RecordSet(params);
		
		attrs.putAll(params);
		return new RecordSet(attrs);
	}

	/**
	 * Wrapper method of request.getParameterMap.
	 * @return RecordSet, contains request parameters.
	 */
	protected final RecordSet getParameters() {
		return new RecordSet(this.request.getParameterMap());
	}
	
	/**
	 * Wrapper method of request.getAttributeMap
	 * @return RecordSet, contains request attributes.
	 */
	protected final RecordSet getAttributes() {
		Map<String,Object> m = this.request.getAttributeMap();
		return (m != null)? new RecordSet(m): new RecordSet();
	}
	
	/**
	 * this method  equals to storeValue("attr", value);
	 * @param value any object to set request attribute. 
	 */
	protected final void store(Object value) {
		this.storeValue("attr", value);
	}
	
	/**
	 * this method is wrapper of request.setAttribute(key, value); 
	 * @param key any key of request attribute.
	 * @param value any value of request attribute.
	 */
	protected final void storeValue(String key, Object value) {
		if (this.storeValueMap_ == null) this.storeValueMap_ = new HashMap<String,Object>();
		this.storeValueMap_.put(key, value);
	}

	/**
	 * store "value" to session context for redirect. After redirected, you can get value by "getInputData().get(key);"
	 * @param key key of store to session.
	 * @param value any object.
	 */
	protected final void storeForRedirect(String key, Object value) {
		if (this.storeForRedirectMap_ == null) this.storeForRedirectMap_ = new HashMap<String,Object>();
		this.storeForRedirectMap_.put(key, value);
	}
	
	/**
	 * @return ̃rWlXWbN̎sœo^ꂽf[^擾
	 * ߂̃\bh. t[[NĂяo邱Ƃz.
	 */
	final Map<String,Object> getStoredValues() {
		return this.storeValueMap_;
	}
	
	/**
	 * @return ̃rWlXWbN̎sŁA_CNgpɓo^ꂽ
	 * f[^擾邽߂̃\bh. t[[NĂяo邱Ƃz.
	 */
	final Map<String,Object> getStoredForRedirect() {
		return this.storeForRedirectMap_;
	}
	
	/**
	 * Ŏw肳ꂽURLɃ_CNgƂɎgp
	 * @param url _CNg
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String redirect(String url) {
		return returnRedirect + url;
	}
		
	/**
	 * Ŏw肳ꂽURLɃ_CNgƂɎgp
	 * @param cls _CNgNX
	 * @param method _CNg惁\bh
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String redirect(Class<?> cls, String method) {
		return redirect(cls, method, ":");
	}
		
  /**
	 * Ŏw肳ꂽURLɃ_CNgƂɎgp
	 * @param cls _CNgNX
	 * @param method _CNg惁\bh
	 * @param separator NXƃ\bh̋؂蕶
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String redirect(Class<?> cls, String method, String separator) {
		return redirect(cls.getName() + separator + method);
	}
		
	/**
	 * Ŏw肳ꂽURLɃtH[hƂɎgp
	 * @param cls tH[hNX
	 * @param method tH[h惁\bh
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String forward(Class<?> cls, String method) {
		return forward(cls, method, ":");
	}
		
	/**
	 * Ŏw肳ꂽURLɃtH[hƂɎgp
	 * @param cls tH[hNX
	 * @param method tH[h惁\bh
	 * @param separator NXƃ\bh̋؂蕶
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String forward(Class<?> cls, String method, String separator) {
		return cls.getName() + separator + method;
	}
		
	/**
	 * Ŏw肳ꂽ̂܂܃X|XƂďo͂ƂɎgp
	 * @param textdata o͂镶
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String echo(String textdata) {
		return returnEcho + textdata;
	}
		
	/**
	 * Ŏw肳ꂽNXgăX|Xo͂ƂɎgp
	 * @param className o̓f[^쐬NX
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String writerClass(String className) {
		return returnWriterClass + className;
	}

	/**
	 * Ŏw肳ꂽNXgăX|Xo͂ƂɎgp
	 * @param cls o̓f[^쐬NX
	 * @return Jڐ킷irWlXWbN̖߂lƂȂjԂ
	 */
	protected final String writerClass(Class<? extends WebWriter> cls) {
		return writerClass(cls.getName());
	}

	/**
	 * HttpServletRequestIuWFNgzNX
	 */
	public static class RequestWrapper {
		public Map<String,Object> getParameterMap() { return null; }
		public Map<String,Object> getAttributeMap() { return null; }
		public Object getAttribute(String arg0) { return null; }		
		public String getHeader(String arg0) { return null; }
		public Enumeration<String> getHeaders(String arg0) { return null; }
		public Enumeration<String> getHeaderNames() { return null; }
		public String getMethod() { return null; }
		public int getContentLength() { return 0; }
		public String getContentType() { return null; }
		public Reader getReader() throws IOException { return null; }
	}
}
