package jp.botiboti.flextyle.web.taglib;

import java.util.List;
import java.util.regex.Matcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.VariableInfo;

import jp.botiboti.flextyle.core.RecordSet;
import jp.botiboti.flextyle.web.DispatchParser;
import jp.botiboti.flextyle.web.Dispatcher;
import jp.botiboti.flextyle.web.RecordSetForJSP;
import jp.botiboti.flextyle.web.WebBean;

/**
 * bean JX^^O̎NX.
 * 
 * <fxt:execute target="jp.co.fstylez.beans.DemoBean.foo" returnValue="itemName" />
 * 
 * @author tanaka ken
 */
public class BeanTag extends TagSupport {
	
	/** SerialNo */
	private static final long serialVersionUID = 6287255648727482638L;
	
	public static class TEI extends TagExtraInfo {
		public VariableInfo[] getVariableInfo(TagData tagData) {

			return new VariableInfo[] {
				new VariableInfo(tagData.getAttributeString("returnValue"), 
					"java.lang.Object",	true, VariableInfo.NESTED)
			};
		}
	}
	
	/** var property */
	private String returnValue;
	
	/** minSize property */
	private String target;
	
	public String getReturnValue() {
		return returnValue;
	}

	public void setReturnValue(String var) {
		this.returnValue = var;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String exec) {
		this.target = exec;
	}

	/** 
	 * ^OŎw肳ꂽeɏ]āAListIuWFNg쐬
	 */
	public int doStartTag() {
		if (this.target == null) 
			return SKIP_BODY;

		Matcher matcher = DispatchParser.defaultInstance().parse(this.target.startsWith("/")? this.target: "/" + this.target);
			
		// url-patternɃ}b`邩ǂ̔
		if (! matcher.matches())			
			return SKIP_BODY;
			
		String className = DispatchParser.defaultInstance().getClassName(matcher);
		String methodName = DispatchParser.defaultInstance().getMethodName(matcher);
		List<String> parameter = DispatchParser.defaultInstance().getParameters(matcher, this.target);

		HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
		HttpServletResponse res = (HttpServletResponse)pageContext.getResponse(); 
			
		WebBean bean = Dispatcher.defaultInstance().createWebBean(className);
		Object obj = Dispatcher.defaultInstance().dispatch(req, res, bean, methodName, parameter);
		
		if (this.returnValue != null)
			pageContext.setAttribute(this.returnValue, 
				obj instanceof RecordSet ? new RecordSetForJSP((RecordSet)obj): obj);
		
		return SKIP_BODY;
	}
		
	public int doEndTag() {
		return EVAL_PAGE;
	}

}
