package jp.botiboti.flextyle.web.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import jp.botiboti.flextyle.util.Util;

public class FormTag extends TagSupport {

	private static final long serialVersionUID = -6185771390289820867L;

	private String id;
	private String name;
	private String action;
	private String target;
	private String method;
	private String enctype;
	private String accept;
	private String acceptCharset; //accept-charset
	private String style;
	private String styleClass;
	private String direct;
	
	@Override
	public int doStartTag() throws JspException {
		try {
			if (Util.isNullOrBlank(this.id)) 
				throw new JspException("Attribute [id] is not appointed in form tag.");
			
			JspWriter w = this.pageContext.getOut();
			w.println("<script type=\"text/javascript\" ><!--");
			w.println("var " + this.id + ";");
			w.println("(function() {");
			w.println("  var _lookup_" + this.id + " = function() {");
			w.println("    if (" + this.id + ") return;");
			w.println("    var tmpobj = document.getElementById('" + this.id + "');");
			w.println("    if (!(tmpobj)) {");
			w.println("      setTimeout(arguments.callee, 1);");
			w.println("      return;");
			w.println("    }");
			w.println("    " + this.id + " = tmpobj;"); 
			w.println("    " + this.id + "._submit = " + this.id + ".submit;");
			w.println("    " + this.id + ".submit = function(sAction,sMethod) {");
			w.println("      if (this.action) this._action = this.action;");
			w.println("      if (this.method) this._method = this.method;");
			w.println("      if (sMethod) this.method = sMethod;");
			w.println("      this.action = this.action ? this.action + sAction: sAction;");
			w.println("      this._submit();");
			w.println("      if (this._action) { this.action = this._action; this._action = null; /*delete this._action;*/ }");
			w.println("      if (this._method) { this.method = this._method; this._method = null; /*delete this._method;*/ }");
			w.println("    };");
			w.println("  };");
			w.println("  if(window.addEventListener)");
			w.println("    window.addEventListener('DOMContentLoaded', _lookup_" + this.id + ", false);");
			w.println("  else if(window.attachEvent)");
			w.println("    window.attachEvent('onload', _lookup_" + this.id + ");");
			w.println("  ");
			w.println("  _lookup_" + this.id + "();");
			w.println("})();");
			w.println("//-->");
			w.println("</script>");
			
			w.print("<form id=\"" + this.id + "\"");

			if (this.name == null)
				w.print(" name=\"" + this.id + "\"");
			else
				w.print(" name=\"" + this.name + "\"");
			if (this.action != null)
				w.print(" action=\"" + this.action + "\"");
			if (this.target != null)
				w.print(" target=\"" + this.target + "\"");
			if (this.method != null)
				w.print(" method=\"" + this.method + "\"");
			if (this.enctype != null)
				w.print(" enctype=\"" + this.enctype + "\"");
			if (this.accept != null)
				w.print(" accept=\"" + this.accept + "\"");
			if (this.acceptCharset != null)
				w.print(" accept-charset=\"" + this.acceptCharset + "\"");
			if (this.style != null)
				w.print(" style=\"" + this.style + "\"");
			if (this.styleClass != null)
				w.print(" class=\"" + this.styleClass + "\"");
			if (this.direct != null)
				w.print(this.direct);
			
			w.print(" >");
			
			return EVAL_BODY_INCLUDE;
		}
		catch (IOException ex) {
			throw new JspException("Exception Occurs in taglib processing.", ex);
		}
	}
	
	@Override
	public int doEndTag() throws JspException {
		try {
			this.pageContext.getOut().println("</form>");
			return EVAL_PAGE;
		}
		catch (IOException ex) {
			throw new JspException("Exception Occurs in taglib processing.", ex);
		}
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public String getEnctype() {
		return enctype;
	}

	public void setEnctype(String enctype) {
		this.enctype = enctype;
	}

	public String getAccept() {
		return accept;
	}

	public void setAccept(String accept) {
		this.accept = accept;
	}

	public String getAcceptCharset() {
		return acceptCharset;
	}

	public void setAcceptCharset(String acceptCharset) {
		this.acceptCharset = acceptCharset;
	}

	public String getStyle() {
		return style;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public String getStyleClass() {
		return styleClass;
	}

	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	public String getDirect() {
		return direct;
	}

	public void setDirect(String direct) {
		this.direct = direct;
	}
	
}
