/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.foolishmerge.diff;

import java.util.List;
import jp.sourceforge.foolishmerge.FoolishMergeConfig;
import jp.sourceforge.foolishmerge.FoolishMergeUtils;
import jp.sourceforge.foolishmerge.diff.Delta;

class MergedDelta {
    private static final String START_SEPARATOR = FoolishMergeConfig.getStartSeparator();
    private static final String END_SEPARATOR = FoolishMergeConfig.getEndSeparator();
    private static final String REV_SEPARATOR = FoolishMergeConfig.getRevisionSeparator();
    private int firstLineNum = Integer.MIN_VALUE;
    private int lastLineNum = Integer.MIN_VALUE;
    private int size = Integer.MIN_VALUE;
    private String filename = null;
    private String revision = null;
    private String[] delta1Lines = null;
    private String[] delta2Lines = null;

    public MergedDelta(Delta delta, Delta delta2) {
        this.delta1Lines = delta.getModLines();
        this.delta2Lines = delta2.getModLines();
        this.firstLineNum = delta.getOrgFirstLineNum() < delta2.getOrgFirstLineNum() ? delta.getOrgFirstLineNum() : delta2.getOrgFirstLineNum();
        this.lastLineNum = delta.getOrgLastLineNum() > delta2.getOrgLastLineNum() ? delta.getOrgLastLineNum() : delta2.getOrgLastLineNum();
        this.size = this.delta1Lines.length + this.delta2Lines.length + 3;
    }

    public String[] getMergedLines() {
        String[] stringArray = new String[this.size];
        int n = 0;
        stringArray[n] = START_SEPARATOR;
        if (this.filename != null) {
            int n2 = n;
            stringArray[n2] = stringArray[n2] + " " + this.filename;
        }
        ++n;
        int n3 = 0;
        while (n3 < this.delta1Lines.length) {
            stringArray[n] = this.delta1Lines[n3];
            ++n3;
            ++n;
        }
        stringArray[n++] = REV_SEPARATOR;
        n3 = 0;
        while (n3 < this.delta2Lines.length) {
            stringArray[n] = this.delta2Lines[n3];
            ++n3;
            ++n;
        }
        stringArray[n] = END_SEPARATOR;
        if (this.revision != null) {
            int n4 = n;
            stringArray[n4] = stringArray[n4] + " " + this.revision;
        }
        return stringArray;
    }

    public String toString() {
        return FoolishMergeUtils.arrayToString(this.getMergedLines());
    }

    public int getFirstLineNum() {
        return this.firstLineNum;
    }

    public int getLastLineNum() {
        return this.lastLineNum;
    }

    public int getSize() {
        return this.size;
    }

    public String[] getDelta1Lines() {
        return this.delta1Lines;
    }

    public String[] getDelta2Lines() {
        return this.delta2Lines;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public int patch(List list, int n) {
        for (int i = this.lastLineNum; i <= this.firstLineNum; ++i) {
            list.remove(i + n);
        }
        list.add(this.firstLineNum + n, this);
        return this.size - (this.lastLineNum - this.firstLineNum + 1);
    }
}

