package jp.sourceforge.foolishmerge;

import jp.sourceforge.foolishmerge.diff.Diff;
import jp.sourceforge.foolishmerge.diff.DocDifference;
import jp.sourceforge.foolishmerge.diff.MergedDocument;

/**
 * 差分ユーティリティクラス。
 */
public final class DiffUtils {

	/**
	 * 文書差分
	 */
	private DocDifference difference = null;

	/**
	 * 指定された文書を使用して差分ユーティリティを構築する。
	 * 
	 * @param org 編集元文書
	 * @param mod 編集後文書
	 */
	public DiffUtils(String org, String mod) {
		// 文字列を配列に変換。
		String[] doc_a = FoolishMergeUtils.stringToArray(org);
		String[] doc_b = FoolishMergeUtils.stringToArray(mod);

		// 文書差分を取得。
		difference = Diff.diff(doc_a, doc_b);
	}

	/**
	 * 文書差分を取得する。
	 * 
	 * @return 文書差分
	 */
	public DocDifference getDifference() {
		// 文書差分を返す。
		return difference;
	}

	/**
	 * 文書差分の文字列表現を取得する。
	 * 
	 * @return 文書差分の文字列表現
	 */
	public String toString() {
		return difference.toString();
	}

	/**
	 * 同一の編集元文書から構築された差分情報をマージする。
	 * 
	 * @param fdiff 同一の編集元文書から構築された差分情報 
	 * @return マージされた文書
	 */
	public MergedDocument merge(DiffUtils fdiff) {
		// 差分情報をマージする。
		return difference.merge(fdiff.difference);
	}

	/**
	 * 差分情報をマージし、マージされた文書の文字列表現を取得する。
	 * 
	 * @param fdiff 同一の編集元文書から構築された差分情報 
	 * @return マージされた文書の文字列表現
	 */
	public String getMerged(DiffUtils fdiff) {
		// 差分情報をマージし、文字列表現を返す。
		return difference.merge(fdiff.difference).toString();
	}

}
