// Copyright 2011 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package jp.sourceforge.fosj.dictionary;

import android.app.Activity;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.widget.TextView;

import jp.sourceforge.fosj.dictionary.R;

public final class AboutActivity extends Activity {

    /** Called when the activity is first created. */
    @Override
    public void onCreate(final Bundle savedInstanceState) {
        DictionaryApplication.INSTANCE.init(getApplicationContext());
        setTheme(DictionaryApplication.INSTANCE.getSelectedTheme().themeId);

        super.onCreate(savedInstanceState);
        setContentView(R.layout.about_activity);
        String ver = "???";
        try {
            PackageManager pm = getPackageManager();
            if (pm != null) {
                PackageInfo p = pm.getPackageInfo(getPackageName(), 0);
                ver = p.versionName + " (ID " + p.versionCode + ")";
            }
        } catch (Exception ignored) {
        }
        TextView titleView = findViewById(R.id.titleText);
        titleView.setText("QuickDic " + ver);
    }

}
