package jp.sourceforge.fosj.sokobanj;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.RelativeLayout;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.MobileAds;

public class SokobanGameActivity extends Activity {

	/** Key under which the {@link SokobanGameState} is stored in the saved instance state bundle. */
	private static final String GAME_KEY = "GAME";
	/** Key under which the level to launch is set as an extra Intent attribute. */
	public static final String GAME_LEVEL_INTENT_EXTRA = "GAME_LEVEL";
	public static final String GAME_LEVEL_SET_EXTRA = "GAME_LEVEL_SET";
	public static int IMAGE_SIZE;
	/** Key under which the image size is stored. */
	public static final String IMAGE_SIZE_PREFS_KEY = "image_size";
	private static final String MY_APP_ID = "ca-app-pub-9209419102968336~5787006400";
	private static final String MY_AD_UNIT_ID = "ca-app-pub-9209419102968336/7263739601";
	/** If the help should be shown (when max level is one). */
	public static final String SHOW_HELP_INTENT_EXTRA = "SHOW_HELP";

	private AdView adView;

	public SokobanGameState gameState;
	private SokobanGameView view;

	@Override
	public void onBackPressed() {
		view.backPressed();
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		if (savedInstanceState != null) {
			gameState = (SokobanGameState) savedInstanceState.getSerializable(GAME_KEY);
		}
		if (gameState == null) {
			int level = 0;
			Intent intent = getIntent();
			int levelSet = 0;
			if (intent != null && intent.getExtras() != null) {
				level = intent.getExtras().getInt(GAME_LEVEL_INTENT_EXTRA, 0);
				if (intent.getExtras().getBoolean(SHOW_HELP_INTENT_EXTRA, false))
					showHelp(); // show when starting first level from menu
				levelSet = intent.getExtras().getInt(GAME_LEVEL_SET_EXTRA, 0);
			}
			gameState = new SokobanGameState(level, levelSet);
		}
		setContentView(R.layout.main);

		Display display = getWindowManager().getDefaultDisplay();
		int defaultImageSize = Math.min(display.getWidth(), display.getHeight()) / 11; // 11 = tile size of first level
		if (defaultImageSize % 2 != 0)
			defaultImageSize--;
		IMAGE_SIZE = getSharedPreferences(SokobanMenuActivity.SHARED_PREFS_NAME, MODE_PRIVATE).getInt(
				IMAGE_SIZE_PREFS_KEY, defaultImageSize);

		view = (SokobanGameView) findViewById(R.id.memoryview);

		// adView を作成する
		MobileAds.initialize(this, MY_APP_ID);
		adView = new AdView(this);
		adView.setAdUnitId(MY_AD_UNIT_ID);
		adView.setAdSize(AdSize.BANNER);

		// 属性 android:id="@+id/mainLayout" が与えられているものとして
		// LinearLayout をルックアップする
		RelativeLayout layout = (RelativeLayout)findViewById(R.id.main_view);

		// adView を追加する
		layout.addView(adView);

		// 一般的なリクエストを行う
		AdRequest adRequest = new AdRequest.Builder().addTestDevice("013B9AE2190161CD436B8E898125F303").build();
//		AdRequest adRequest = new AdRequest.Builder().addTestDevice("xxx").build();

		// 広告リクエストを行って adView を読み込む
		adView.loadAd(adRequest);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.options_menu, menu);
		return true;
	}

	/** Overridden to handle back button - see {@link SokobanGameActivity#onBackPressed() } */
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
			if (IMAGE_SIZE < 68)
				setImageSize(IMAGE_SIZE + 2);
			return true;
		} else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
			if (IMAGE_SIZE > 12)
				setImageSize(IMAGE_SIZE - 2);
			return true;
		}
		return super.onKeyDown(keyCode, event);
	}



	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_VOLUME_UP || keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
			// avoid the beep when pressing the buttons
			return true;
		}
		return super.onKeyUp(keyCode, event);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if (item.getItemId() == R.id.restart_menu) {
			gameState.restart();
			view.invalidate();
		} else if (item.getItemId() == R.id.back_menu) {
			finish();
		} else if (item.getItemId() == R.id.help_menu) {
			showHelp();
		}
		return super.onOptionsItemSelected(item);
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		outState.putSerializable(GAME_KEY, gameState);
	}

	private void setImageSize(int newSize) {
		IMAGE_SIZE = newSize;
		SharedPreferences prefs = getSharedPreferences(SokobanMenuActivity.SHARED_PREFS_NAME, MODE_PRIVATE);
		Editor editor = prefs.edit();
		editor.putInt(IMAGE_SIZE_PREFS_KEY, newSize);
		editor.commit();
		view.customSizeChanged();
		view.invalidate();
	}

	public void showHelp() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder
		.setMessage(R.string.helpMessage);
		builder.setPositiveButton(R.string.ok_button, null);
		builder.create().show();
	}

}