package jp.sourceforge.fosj.sudokufree;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class ThemeResolver {
    private static final String LIGHT = "CLASSIC";
    private static final String DARK = "DARK";

    private static final int ACTIVITY_THEME_LIGHT = R.style.Theme_Light;
    private static final int DIALOG_THEME_LIGHT = R.style.Theme_Light_Dialog;
    private static final int ACTIVITY_THEME_DARK = R.style.Theme_Dark;
    private static final int DIALOG_THEME_DARK = R.style.Theme_Dark_Dialog;

    public static int getActivityTheme(Context context) {
        String theme = getThemeName(context);
        if (LIGHT.equals(theme)) {
            return ACTIVITY_THEME_LIGHT;
        } else {
            return ACTIVITY_THEME_DARK;
        }
    }

    public static int getTextColor(Context context) {
        Theme theme = createThemeFromPreferences(context);
        return theme.getNameTextColor();
    }

    public static int getBackgroundColor(Context context) {
        Theme theme = createThemeFromPreferences(context);
        return theme.getPuzzleBackgroundColor();
    }

    private static String getThemeName(Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(context);
        return preferences.getString("color_theme", LIGHT);
    }

    public static boolean isLight(Context context) {
        String theme = getThemeName(context);
        return LIGHT.equals(theme);
    }

    public static int getDialogTheme(Context context) {
        String theme = getThemeName(context);
        if (LIGHT.equals(theme)) {
            return DIALOG_THEME_LIGHT;
        } else {
            return DIALOG_THEME_DARK;
        }
    }

    private static Theme createThemeFromPreferences(Context context) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences(context);

        ColorTheme.Builder builder = new ColorTheme.Builder(context.getResources());

        builder.areaColorPolicy = AreaColorPolicy.valueOf(settings.getString(
                Settings.KEY_COLORED_REGIONS, AreaColorPolicy.STANDARD_X_HYPER_SQUIGGLY.name()));
        builder.highlightDigitsPolicy = HighlightDigitsPolicy.valueOf(settings.getString(
                Settings.KEY_HIGHLIGHT_DIGITS, HighlightDigitsPolicy.ONLY_SINGLE_VALUES.name()));

        ColorThemePolicy colorThemePolicy = ColorThemePolicy.valueOf(settings.getString(
                Settings.KEY_COLOR_THEME, ColorThemePolicy.CLASSIC.name()));
        colorThemePolicy.customize(builder);

        Theme theme = builder.build();

        return theme;
    }
}
