/*
 * Decompiled with CFR 0.152.
 */
package com.google.marvin.widget;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;

public class TouchGestureControlOverlay
extends View {
    private final double left = 0.0;
    private final double upleft = 0.7853981633974483;
    private final double up = 1.5707963267948966;
    private final double upright = 2.356194490192345;
    private final double downright = -2.356194490192345;
    private final double down = -1.5707963267948966;
    private final double downleft = -0.7853981633974483;
    private final double right = Math.PI;
    private final double rightWrap = -Math.PI;
    private GestureListener cb = null;
    private double downX;
    private double downY;
    private Gesture currentGesture;

    public TouchGestureControlOverlay(Context context, GestureListener callback) {
        super(context);
        this.cb = callback;
    }

    public TouchGestureControlOverlay(Context context) {
        super(context);
    }

    public void setGestureListener(GestureListener callback) {
        this.cb = callback;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        Gesture prevGesture = null;
        switch (action) {
            case 0: {
                this.downX = x;
                this.downY = y;
                this.currentGesture = Gesture.CENTER;
                if (this.cb == null) break;
                this.cb.onGestureStart(this.currentGesture);
                break;
            }
            case 1: {
                prevGesture = this.currentGesture;
                this.currentGesture = this.evalMotion(x, y);
                if (this.currentGesture == null) {
                    this.currentGesture = prevGesture;
                }
                if (this.cb == null) break;
                this.cb.onGestureFinish(this.currentGesture);
                break;
            }
            default: {
                prevGesture = this.currentGesture;
                this.currentGesture = this.evalMotion(x, y);
                if (this.currentGesture == null) {
                    this.currentGesture = prevGesture;
                    break;
                }
                if (prevGesture == this.currentGesture || this.cb == null) break;
                this.cb.onGestureChange(this.currentGesture);
            }
        }
        return true;
    }

    public Gesture evalMotion(double x, double y) {
        float rTolerance = 25.0f;
        double thetaTolerance = 0.2617993877991494;
        double r = Math.sqrt((this.downX - x) * (this.downX - x) + (this.downY - y) * (this.downY - y));
        if (r < (double)rTolerance) {
            return Gesture.CENTER;
        }
        double theta = Math.atan2(this.downY - y, this.downX - x);
        if (Math.abs(theta - 0.0) < thetaTolerance) {
            return Gesture.LEFT;
        }
        if (Math.abs(theta - 0.7853981633974483) < thetaTolerance) {
            return Gesture.UPLEFT;
        }
        if (Math.abs(theta - 1.5707963267948966) < thetaTolerance) {
            return Gesture.UP;
        }
        if (Math.abs(theta - 2.356194490192345) < thetaTolerance) {
            return Gesture.UPRIGHT;
        }
        if (Math.abs(theta - -2.356194490192345) < thetaTolerance) {
            return Gesture.DOWNRIGHT;
        }
        if (Math.abs(theta - -1.5707963267948966) < thetaTolerance) {
            return Gesture.DOWN;
        }
        if (Math.abs(theta - -0.7853981633974483) < thetaTolerance) {
            return Gesture.DOWNLEFT;
        }
        if (theta > Math.PI - thetaTolerance || theta < -Math.PI + thetaTolerance) {
            return Gesture.RIGHT;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Gesture {
        UPLEFT,
        UP,
        UPRIGHT,
        LEFT,
        CENTER,
        RIGHT,
        DOWNLEFT,
        DOWN,
        DOWNRIGHT;

    }

    public static interface GestureListener {
        public void onGestureStart(Gesture var1);

        public void onGestureChange(Gesture var1);

        public void onGestureFinish(Gesture var1);
    }
}

