/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.clean;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.regexp.RE;
import org.cmc.music.clean.Diacriticals;
import org.cmc.music.metadata.MusicMetadataConstants;
import org.cmc.music.util.MyComparator;
import org.cmc.music.util.MyMap;
import org.cmc.music.util.TextUtils;

public class NameRectifier
implements MusicMetadataConstants {
    private static final String[] DEFAULTS = new String[]{"album", "artist", "title", "no title", "no artist", "undefined", "va", "mp3", "cd", "genre", "unknown", "name", "n/a", "Untitled"};
    private static final String[] DEFAULTS_VA;
    private static final String[] DEFAULTS_SOUNDTRACK;
    private static final String DEFAULT_ACAPELLA;
    private static final String ROMAN_NUMERALS = "ivx";
    private static final Map natural_numbers;
    private static final String[] PATTERNS_ALBUM;
    private static final String[] PATTERNS_ARTIST;
    private static final String[] FEATURING;
    private static final String ESCAPED = "^$.[|*+?\\(<)>#=/-{}";
    private static final RegExCache regex_cache;

    static {
        Arrays.sort(DEFAULTS, MyComparator.kToStringLengthReverse);
        DEFAULTS_VA = new String[]{"Compilation", "V.A", "V.A.", "V. A.", "V. A", "V/A", "Va", "V A", "Various Artists", "Various", "Varioius", "Varied Artists", "Varias", "Varios Interpretes", "Varios", "Various Artist", "Various Artistses", "Various Artits", "Various Artisis", "Various Aritsts", "Varius Artists", "Various Composers", "Various djs"};
        Arrays.sort(DEFAULTS_VA, MyComparator.kToStringLengthReverse);
        DEFAULTS_SOUNDTRACK = new String[]{"The Motion Picture".toLowerCase(), "Motion Picture".toLowerCase(), "Original Motion Picture".toLowerCase(), "Original Motion Picture Soundtrack".toLowerCase(), "The Soundtrack".toLowerCase(), "Music From The Motion Picture".toLowerCase(), "Original Soundtrack Recording".toLowerCase(), "Trilha Sonora Original".toLowerCase(), "ost", "original soundtrack", "soundtrack", "Music From The Motion Picture Soundtrack"};
        Arrays.sort(DEFAULTS_SOUNDTRACK, MyComparator.kToStringLengthReverse);
        DEFAULT_ACAPELLA = "Ac+ap+el+as?".toLowerCase();
        natural_numbers = new MyMap();
        natural_numbers.put("zero", new Integer(0));
        natural_numbers.put("one", new Integer(1));
        natural_numbers.put("two", new Integer(2));
        natural_numbers.put("three", new Integer(3));
        natural_numbers.put("four", new Integer(4));
        natural_numbers.put("five", new Integer(5));
        natural_numbers.put("six", new Integer(6));
        natural_numbers.put("seven", new Integer(7));
        natural_numbers.put("eight", new Integer(8));
        natural_numbers.put("nine", new Integer(9));
        natural_numbers.put("ten", new Integer(10));
        natural_numbers.put("eleven", new Integer(11));
        natural_numbers.put("twelve", new Integer(12));
        natural_numbers.put("thirteen", new Integer(13));
        natural_numbers.put("fourteen", new Integer(14));
        natural_numbers.put("fifteen", new Integer(15));
        natural_numbers.put("sixteen", new Integer(16));
        natural_numbers.put("seventeen", new Integer(17));
        natural_numbers.put("eighteen", new Integer(18));
        natural_numbers.put("nineteen", new Integer(19));
        natural_numbers.put("twenty", new Integer(20));
        PATTERNS_ALBUM = new String[]{"dvd", "10\"", "12 - Inch", "12 Inch", "12 Inch Single", "12\"", "12\" Ep", "12\" Vinyl", "7 Inch", "7\"", "Advance", "Advance Copy", "Bonus Disc", "Box", "Cd", "Cd Single", "Cdm", "Cdr", "Cds", "maxi", "maxi single", "Promo Cd", "Ep", "Full Vls", "Import", "Lp", "Promo", "Promo Cds", "Retail", "Single", "Vinyl", "Vinyl Single", "Vls", "cd", "cds", "ep", "unknown album", "Remastered"};
        Arrays.sort(PATTERNS_ALBUM, MyComparator.kToStringLengthReverse);
        PATTERNS_ARTIST = new String[]{"skit", "live"};
        Arrays.sort(PATTERNS_ARTIST, MyComparator.kToStringLengthReverse);
        FEATURING = new String[]{"f\\.", "ft\\.", "feat\\.", "featuring "};
        regex_cache = new RegExCache();
    }

    public String rectifyGeneric(String s) {
        return this.rectifyGeneric(s, null);
    }

    public String rectifyGeneric(String s, Map flags) {
        String old = s;
        while (true) {
            s = this.rectifyGeneric_1(s, flags);
            if ((s = this.removeQuotes(s)) == null) {
                return null;
            }
            if (s.equals(old)) {
                return s;
            }
            old = s;
        }
    }

    private String removeQuotes(String s) {
        if (s == null) {
            return null;
        }
        if (new RE("^\".+\"$").match(s) || new RE("^'.+'$").match(s) || new RE("^\\{.+\\}$").match(s) || new RE("^\\(.+\\)$").match(s) || new RE("^<.+>$").match(s) || new RE("^\\[.+\\]$").match(s)) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private boolean isRomanNumeral(String s) {
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (ROMAN_NUMERALS.indexOf(c) < 0 && ROMAN_NUMERALS.toUpperCase().indexOf(c) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Number parseNumber(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() < 1) {
            return null;
        }
        try {
            return Integer.valueOf(s.trim());
        }
        catch (Throwable throwable) {
            Number value = (Number)natural_numbers.get(s.toLowerCase());
            return value;
        }
    }

    private String clean(String s, Map flags) {
        s = s.trim();
        s = Diacriticals.convertDiacriticals(s);
        while (s.startsWith("-")) {
            s = s.substring(1);
        }
        if ((s = this.removeSafePrefixSuffix(s, DEFAULTS)) == null) {
            return null;
        }
        String[] kDISC_REGEXS = new String[]{"[-\\(\\[] ?dis[ck] ?([a-zA-Z\\d]+)[\\)\\]]?$", "[-\\(\\[] ?cd ?([a-zA-Z\\d]+)[\\)\\]]?$", "^[\\(\\[]?dis[ck] ?([a-zA-Z\\d]+) ?[-\\)\\]]", "^[\\(\\[]?cd ?([a-zA-Z\\d]+) ?[-\\)\\]]", "^dis[ck] ?([a-zA-Z\\d]+)$", "^cd[\\. \\-]*([a-zA-Z\\d]+)$"};
        int i = 0;
        while (i < kDISC_REGEXS.length) {
            String kDISC_REGEX = kDISC_REGEXS[i];
            RE re = new RE(kDISC_REGEX);
            if (re.match(s.toLowerCase()) && re.getParenCount() >= 2) {
                int start = re.getParenStart(0);
                int end = re.getParenEnd(0);
                String value = re.getParen(1);
                Number number = this.parseNumber(value);
                if (number != null) {
                    String fixed = String.valueOf(s.substring(0, start)) + s.substring(end);
                    if (flags != null) {
                        flags.put("disc_number", number);
                    }
                    s = fixed.trim();
                }
            }
            ++i;
        }
        String[] suffixes = new String[]{" ", "-", ".Mp3", " Mp3"};
        s = this.removeSuffixes(s, suffixes);
        String[] prefixes = new String[]{" ", "-"};
        s = this.removePrefixes(s, prefixes);
        s = s.replace('_', ' ');
        s = TextUtils.replace(s, "-", " - ");
        s = TextUtils.replace(s, "`", "'");
        s = TextUtils.replace(s, "\ufffd", "'");
        s = TextUtils.replace(s, "\ufffd", "'");
        s = TextUtils.replace(s, "[", "(");
        s = TextUtils.replace(s, "]", ")");
        s = TextUtils.replace(s, "(", " (");
        s = TextUtils.replace(s, "~", "-");
        s = TextUtils.replace(s, "  ", " ");
        s = TextUtils.replace(s, "  ", " ");
        s = TextUtils.replace(s, "..", ".");
        s = TextUtils.replace(s, "--", "-");
        s = TextUtils.replace(s, "- -", "-");
        String old = s = TextUtils.replace(s, "#", "No. ");
        if (!((s = this.removeSafePrefixSuffix(s, DEFAULTS_SOUNDTRACK, true)) != null && s.equals(old) || flags == null)) {
            flags.put("soundtrack", Boolean.TRUE);
        }
        if (s == null) {
            return null;
        }
        String temp = this.removeSafePrefixSuffix(s, DEFAULT_ACAPELLA, true);
        if (!(temp != null && s.equals(temp) || flags == null)) {
            flags.put("acapella", Boolean.TRUE);
        }
        old = s;
        if (!((s = this.removeSafePrefixSuffix(s, DEFAULTS_VA, true)) != null && s.equals(old) || flags == null)) {
            flags.put("compilation", Boolean.TRUE);
        }
        if (s == null) {
            return null;
        }
        String[] splits = TextUtils.split(s, " ");
        int i2 = 0;
        while (i2 < splits.length) {
            if (this.isRomanNumeral(splits[i2])) {
                splits[i2] = splits[i2].toUpperCase();
            }
            ++i2;
        }
        s = TextUtils.join(splits, " ");
        s = s.trim();
        s = this.toTitleCase(s);
        return s;
    }

    private String toTitleCase(String s) {
        StringBuffer result = new StringBuffer();
        char prev = '\u0000';
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isLetter(c)) {
                if (i == 0) {
                    result.append(Character.toUpperCase(c));
                } else if (prev == '\'') {
                    result.append(Character.toLowerCase(c));
                } else if (!Character.isLetter(prev)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(Character.toLowerCase(c));
                }
            } else {
                result.append(c);
            }
            prev = c;
            ++i;
        }
        return result.toString();
    }

    private String insertSpacesBeforeCaps(String s) {
        StringBuffer result = new StringBuffer();
        char prev = '\u0000';
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isLetter(c) && i > 0 && Character.isLetter(prev) && Character.isLowerCase(prev) && Character.isUpperCase(c)) {
                result.append(' ');
            }
            result.append(c);
            prev = c;
            ++i;
        }
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String rectifyGeneric_1(String s, Map flags) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() < 1) {
            return null;
        }
        if ((s = this.clean(s, flags)) == null) {
            return null;
        }
        s = TextUtils.replace(s, ".", ". ");
        s = TextUtils.replace(s, " .", " ");
        if (!new RE("^\\?+$").match(s = TextUtils.replace(s, "  ", " "))) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            s = s.substring(1);
lbl12:
            // 2 sources

            ** while (s.startsWith((String)"."))
        }
lbl13:
        // 1 sources

        s = TextUtils.replace(s, "Live @ ", "Live At ");
        if ((s = TextUtils.replace(s, "Live@", "Live At ")) == null) {
            return null;
        }
        if (s.endsWith(", The")) {
            s = "The " + s.substring(0, s.length() - 5);
        }
        return s;
    }

    public String rectifySongTitle(String s) {
        return this.rectifySongTitle(s, null);
    }

    public String rectifySongTitle(String s, Map flags) {
        String old = s;
        int i = 0;
        while ((s = this.rectifySongTitle_1(s, flags)) != null) {
            if (s.equals(old)) {
                return s;
            }
            old = s;
            ++i;
        }
        return null;
    }

    private void parseTrackNumber(String s, Map flags) {
        if (flags == null) {
            return;
        }
        try {
            s = s.trim();
            Integer number = new Integer(s);
            if (flags != null) {
                flags.put("track_number", number);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String removeTrackNumbers(String s, Map flags) {
        String after;
        int index;
        if (s == null) {
            return null;
        }
        if (new RE("^(audio)? ?track ?[- ]?[0-9][0-9]?$").match(s.toLowerCase())) {
            if (s.toLowerCase().startsWith("audio")) {
                s = s.substring(5).trim();
            }
            this.parseTrackNumber(s.substring(5), flags);
            return null;
        }
        if (new RE("^piste ?[- ]?[0-9][0-9]?$").match(s.toLowerCase())) {
            this.parseTrackNumber(s.substring(5), flags);
            return null;
        }
        if ((new RE("^[0-9][0-9] - ").match(s) || new RE("^[0-9][0-9][0-9] - ").match(s) || new RE("^[aAbBcCdD][0-9] - ").match(s)) && (index = s.indexOf(45)) >= 0 && (after = s.substring(index + 1).trim()).indexOf(45) < 0) {
            this.parseTrackNumber(s.substring(0, index), flags);
            s = after;
        }
        if ((new RE("^\\([0-9][0-9]\\) ").match(s) || new RE("^\\([abcdABCD][0-9]\\) ").match(s)) && (index = s.indexOf(41)) >= 0) {
            this.parseTrackNumber(s.substring(1, index), flags);
            s = s.substring(index + 1).trim();
        }
        return s;
    }

    private String rectifySongTitle_1(String s, Map flags) {
        if ((s = this.rectifyGeneric_1(s, flags)) == null) {
            return null;
        }
        if ((s = this.removeTrackNumbers(s, flags)) == null) {
            return null;
        }
        s = this.removeQuotes(s);
        return s;
    }

    private String removeSuffixes(String s, String[] suffixes) {
        return this.removeSuffixes(s, new Vector(Arrays.asList(suffixes)));
    }

    private String removeSuffixes(String s, Vector suffixes) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (i < suffixes.size()) {
            String suffix = (String)suffixes.get(i);
            if (s.toLowerCase().endsWith(suffix.toLowerCase())) {
                s = s.substring(0, s.length() - suffix.length());
            }
            ++i;
        }
        return s;
    }

    private String removePrefixes(String s, String[] prefixes) {
        return this.removePrefixes(s, new Vector(Arrays.asList(prefixes)));
    }

    private String removePrefixes(String s, Vector prefixes) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (i < prefixes.size()) {
            String prefix = (String)prefixes.get(i);
            if (s.toLowerCase().startsWith(prefix.toLowerCase())) {
                s = s.substring(prefix.length());
            }
            ++i;
        }
        return s;
    }

    private String discardMatches(String s, String[] patterns) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (i < patterns.length) {
            String prefix = patterns[i];
            if (s.equalsIgnoreCase(prefix)) {
                return null;
            }
            ++i;
        }
        return s;
    }

    public String rectifyAlbum(String s) {
        return this.rectifyAlbum(s, null);
    }

    public String rectifyAlbum(String s, Map flags) {
        String old = s;
        while ((s = this.rectifyAlbum_1(s, flags)) != null) {
            if (s.equals(old)) {
                return s;
            }
            old = s;
        }
        return null;
    }

    private String removeYearPrefixSuffix(String s) {
        String temp;
        int index;
        if (s == null) {
            return null;
        }
        if (new RE("^\\(199[0-9]\\)").match(s) || new RE("^\\(200[0-9]\\)").match(s)) {
            s = s.substring(7);
        }
        if (new RE("^\\( 199[0-9] \\)").match(s) || new RE("^\\( 200[0-9] \\)").match(s)) {
            s = s.substring(9);
        }
        if (new RE("\\(199[0-9]\\)$").match(s) || new RE("\\(200[0-9]\\)$").match(s)) {
            s = s.substring(0, s.length() - 7);
        }
        if (new RE("\\( 199[0-9] \\)$").match(s) || new RE("\\( 200[0-9] \\)$").match(s)) {
            s = s.substring(0, s.length() - 9);
        }
        if ((new RE("199[0-9] - ").match(s) || new RE("200[0-9] - ").match(s)) && (index = s.indexOf(45)) >= 0 && (temp = s.substring(index + 1)).indexOf(45) < 0) {
            s = temp;
        }
        if ((new RE("- 199[0-9]").match(s) || new RE(" - 200[0-9]").match(s)) && (index = s.lastIndexOf(45)) >= 0 && (temp = s.substring(0, index)).indexOf(45) < 0) {
            s = temp;
        }
        return s;
    }

    public String rectifyAlbum_1(String s, Map flags) {
        if ((s = this.rectifyGeneric_1(s, flags)) == null) {
            return null;
        }
        if ((s = this.removeSafePrefixSuffix(s, PATTERNS_ALBUM)) == null) {
            return null;
        }
        if (s.endsWith(" Box Set") && flags != null) {
            flags.put("compilation", Boolean.TRUE);
        }
        s = this.removeYearPrefixSuffix(s);
        s = this.removeURLs(s);
        String old = s = this.removeQuotes(s);
        if (!((s = this.removeSafePrefixSuffix(s, DEFAULT_ACAPELLA, true)) != null && s.equals(old) || flags == null)) {
            flags.put("acapella", Boolean.TRUE);
        }
        if (s == null) {
            return null;
        }
        if (s.endsWith(" !")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith(" (!)")) {
            s = s.substring(0, s.length() - 4);
        }
        return s;
    }

    private String removeURLs(String s) {
        if (s == null) {
            return null;
        }
        if (new RE("^http://").match(s.toLowerCase())) {
            return null;
        }
        String temp = s;
        RE re = new RE("^[\\w \\-]*\\.[\\w \\.\\-]*\\.(com|net|org|edu)$");
        if (re.match((temp = TextUtils.replace(temp, ". ", ".")).toLowerCase())) {
            return null;
        }
        return s;
    }

    public String rectifyArtist(String s) {
        return this.rectifyArtist(s, null);
    }

    public String rectifyArtist(String s, Map flags) {
        String old = s;
        while ((s = this.rectifyArtist_1(s, flags)) != null) {
            if (s.equals(old)) {
                return s;
            }
            old = s;
        }
        return null;
    }

    private String rectifyArtist_1(String s, Map flags) {
        if ((s = this.rectifyGeneric_1(s, flags)) == null) {
            return null;
        }
        if (s.equalsIgnoreCase("unknown artist")) {
            return null;
        }
        s = this.removeTrackNumbers(s, flags);
        s = this.removeYearPrefixSuffix(s);
        if ((s = this.removeSafePrefixSuffix(s, PATTERNS_ARTIST)) == null) {
            return null;
        }
        String old = s;
        if (!((s = this.removeSafePrefixSuffix(s, DEFAULT_ACAPELLA, true)) != null && s.equals(old) || flags == null)) {
            flags.put("acapella", Boolean.TRUE);
        }
        if (s == null) {
            return null;
        }
        s = this.removeQuotes(s);
        s = this.removeURLs(s);
        return s;
    }

    public String rectifyGenre(String s) {
        String old = s;
        while ((s = this.rectifyGenre_1(s)) != null) {
            if (s.equals(old)) {
                return s;
            }
            old = s;
        }
        return null;
    }

    private String rectifyGenre_1(String s) {
        if ((s = this.rectifyGeneric_1(s, null)) == null) {
            return null;
        }
        if (s.equalsIgnoreCase("music")) {
            return null;
        }
        s = this.removeQuotes(s);
        s = TextUtils.replace(s, " - ", "-");
        s = this.removeSafePrefixSuffix(s, "\ufffd", true);
        s = this.removeSafePrefixSuffix(s, DEFAULT_ACAPELLA, true);
        return s;
    }

    public String rectifyPublisher(String s) {
        String old = s;
        while ((s = this.rectifyPublisher_1(s)) != null) {
            if (s.equals(old)) {
                return s;
            }
            old = s;
        }
        return null;
    }

    private String rectifyPublisher_1(String s) {
        if ((s = this.rectifyGeneric_1(s, null)) == null) {
            return null;
        }
        s = this.removeURLs(s);
        s = this.removeQuotes(s);
        s = TextUtils.replace(s, " - ", "-");
        return s;
    }

    private Vector listToNames(RE re) {
        Vector<String> result = new Vector<String>();
        int count = re.getParenCount();
        int i = 0;
        while (i < count / 2) {
            String child = re.getParen(i * 2 + 1);
            child = this.rectifyArtist(child);
            result.remove(child);
            result.add(child);
            ++i;
        }
        return result;
    }

    private Vector debugRE(RE re) {
        Vector<String> result = new Vector<String>();
        int count = re.getParenCount();
        int i = 0;
        while (i < count) {
            String child = re.getParen(i);
            result.add(child);
            ++i;
        }
        return result;
    }

    public String processFeaturing(String s, Vector primary_artists, Vector featured_artists, String pattern) {
        if (s == null) {
            return null;
        }
        RE re = new RE(pattern);
        if (re.match(s.toLowerCase())) {
            RE re2;
            int startInside = re.getParenStart(1);
            int endInside = re.getParenEnd(1);
            String left = s.substring(0, startInside);
            String right = s.substring(startInside, endInside);
            int index = Integer.MAX_VALUE;
            int i = (right = right.trim()).indexOf(46);
            if (i >= 0) {
                index = Math.min(index, i);
            }
            if ((i = right.indexOf(32)) >= 0) {
                index = Math.min(index, i);
            }
            if (index < 0) {
                return s;
            }
            if ((right = right.substring(index + 1)).endsWith(")")) {
                right = right.substring(0, right.length() - 1);
            }
            if (left.endsWith("(")) {
                left = left.substring(0, left.length() - 1);
            }
            if ((re2 = new RE("(.*)(,.*)*\\&(.*)")).match(right = right.trim())) {
                Vector v = this.listToNames(re2);
                featured_artists.removeAll(v);
                featured_artists.addAll(v);
            } else {
                re2 = new RE("(.*)(,.*)*\\ And (.*)");
                if (re2.match(right)) {
                    Vector v = this.listToNames(re2);
                    featured_artists.removeAll(v);
                    featured_artists.addAll(v);
                } else {
                    right = this.rectifyArtist(right);
                    featured_artists.remove(right);
                    featured_artists.add(right);
                }
            }
            s = this.rectifyArtist(left);
        }
        return s;
    }

    public void processFeaturing(String s, Vector primary_artists, Vector featured_artists) {
        String regex;
        int i = 0;
        while (i < FEATURING.length) {
            regex = "\\((" + FEATURING[i] + ".*)\\)$";
            s = this.processFeaturing(s, primary_artists, featured_artists, regex);
            ++i;
        }
        i = 0;
        while (i < FEATURING.length) {
            regex = "( " + FEATURING[i] + ".*$)";
            s = this.processFeaturing(s, primary_artists, featured_artists, regex);
            ++i;
        }
        if (primary_artists == null) {
            return;
        }
        s = this.rectifyArtist(s);
        primary_artists.remove(s);
        primary_artists.add(s);
    }

    public String toRegexLiteral(String s) {
        StringBuffer result = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (ESCAPED.indexOf(c) >= 0) {
                result.append('\\');
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public String getPrefixPattern(String s, boolean permissive) {
        return "^('" + s + "'|\\\"" + s + "\\\"|\\[" + s + "\\]|\\(" + s + "\\)|\\{" + s + "\\}|" + s + "\\-" + (permissive ? "|" + s + " " : "") + ")";
    }

    public String getSuffixPattern(String s, boolean permissive) {
        return "('" + s + "'|\\\"" + s + "\\\"|\\[" + s + "\\]|\\(" + s + "\\)|\\{" + s + "\\}|\\-" + s + (permissive ? "| " + s : "") + ")$";
    }

    public String getPrefixPattern2(String s) {
        return "^('.*'|\\\".*\\\"|\\[.*\\]|\\(.*\\)|\\{.*\\}|.*\\-) ?" + s + "$";
    }

    public String getSuffixPattern2(String s) {
        return "^" + s + " ?('.*'|\\\".*\\\"|\\[.*\\]|\\(.*\\)|\\{.*\\}|\\-.*)$";
    }

    private String stripRegexMatch(String s, String pattern) {
        if (s == null) {
            return null;
        }
        try {
            RE re = regex_cache.getRegEx(pattern);
            if (!re.match(s.toLowerCase())) {
                return s;
            }
            s = String.valueOf(s.substring(0, re.getParenStart(0))) + s.substring(re.getParenEnd(0));
            return s;
        }
        catch (Exception e) {
            return s;
        }
    }

    private String extractRegexPattern(String s, String pattern, int paren) {
        if (s == null) {
            return null;
        }
        try {
            RE re = regex_cache.getRegEx(pattern);
            if (!re.match(s.toLowerCase())) {
                return s;
            }
            if (paren < re.getParenCount()) {
                s = re.getParen(paren);
            }
            return s;
        }
        catch (Exception e) {
            return s;
        }
    }

    private String removeSafePrefixSuffix(String s, String[] patterns) {
        return this.removeSafePrefixSuffix(s, patterns, false);
    }

    private String removeSafePrefixSuffix(String s, String[] patterns, boolean permissive) {
        if (s == null) {
            return null;
        }
        int i = 0;
        while (s != null && i < patterns.length) {
            String pattern = patterns[i];
            s = this.removeSafePrefixSuffixLiteral(s, pattern, permissive);
            ++i;
        }
        return s;
    }

    private String removeSafePrefixSuffixLiteral(String s, String pattern, boolean permissive) {
        return this.removeSafePrefixSuffix(s, this.toRegexLiteral(pattern), permissive);
    }

    private String removeSafePrefixSuffix(String s, String pattern) {
        return this.removeSafePrefixSuffix(s, pattern, false);
    }

    private String removeSafePrefixSuffix(String s, String pattern, boolean permissive) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase(pattern)) {
            return null;
        }
        s = this.stripRegexMatch(s, this.getPrefixPattern(pattern, permissive));
        s = this.stripRegexMatch(s, this.getSuffixPattern(pattern, permissive));
        s = this.extractRegexPattern(s, this.getPrefixPattern2(pattern), 1);
        s = this.extractRegexPattern(s, this.getSuffixPattern2(pattern), 1);
        return s;
    }

    private static class RegExCache {
        private final Map map = new Hashtable();
        private static final int kMAX = 25000;

        private RegExCache() {
        }

        public final RE getRegEx(String pattern) {
            if (pattern == null) {
                return null;
            }
            RE result = (RE)this.map.get(pattern = pattern.toLowerCase());
            if (result == null) {
                result = new RE(pattern);
                this.map.put(pattern, result);
            }
            if (this.map.keySet().size() > 25000) {
                this.map.clear();
            }
            return result;
        }
    }
}

