/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class FileComparator {
    public boolean compare(File a, File b) {
        System.out.println("comparing: " + a.getAbsolutePath());
        System.out.println("\twith: " + b.getAbsolutePath());
        if (a.getAbsolutePath().equals(b.getAbsolutePath())) {
            return false;
        }
        if (a.length() != b.length()) {
            System.out.println("\tlengths don't match");
            return false;
        }
        boolean result = this.compareContents(a, b);
        if (result) {
            System.out.println("\tmatch!");
        } else {
            System.out.println("\tcontents don't match");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareContents(File a, File b) {
        InputStream ais = null;
        InputStream bis = null;
        try {
            int abyte;
            ais = new FileInputStream(a);
            ais = new BufferedInputStream(ais);
            bis = new FileInputStream(b);
            bis = new BufferedInputStream(bis);
            do {
                int bbyte;
                if ((abyte = ais.read()) == (bbyte = bis.read())) continue;
                return false;
            } while (abyte != -1);
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (ais != null) {
                    ais.close();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

