/*
 *    Copyright (c) 2012 Hai Bison
 *
 *    See the file LICENSE at the root directory of this project for copying
 *    permission.
 */

package group.pals.android.lib.ui.filechooser.io.localfile;

import group.pals.android.lib.ui.filechooser.io.IFile;
import group.pals.android.lib.ui.filechooser.utils.history.History;

import java.io.File;
import java.util.List;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * This is a wrapper for {@link File}.
 * 
 * @author Hai Bison
 * @since v3.2
 */
public class LocalFile extends File implements IFile {

    /**
     * Auto-generated by Eclipse.
     */
    private static final long serialVersionUID = 2068049445895497580L;

    public LocalFile(String pathname) {
        super(pathname);
    }// LocalFile()

    public LocalFile(File file) {
        this(file.getAbsolutePath());
    }// LocalFile()

    @Override
    public IFile parentFile() {
        return getParent() == null ? null : new LocalFile(getParent());
    }// parentFile()

    /**
     * By default, {@link File} compares to another one by its pathname. So if
     * two different {@link File}'s have same pathname, they are equal. But to
     * let the {@link History} works, we don't do that.<br>
     * For example we have this history: 1-2-3-2-4-5, and it is used in a
     * {@link List}, then if we use {@link File}, we will only get {@code 1} for
     * method {@link List#indexOf(Object)} with file "2". But we have 2
     * positions for "2".<br>
     * <br>
     * So, we override this method :-) The result is a comparison of operator
     * {@code ==}
     */
    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equalsToPath(IFile file) {
        return file == null ? false : getAbsolutePath().equals(file.getAbsolutePath());
    }// equalsToPath()

    @Override
    public IFile clone() {
        return new LocalFile(getAbsolutePath());
    }

    /*-----------------------------------------------------
     * Parcelable
     */

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(getAbsolutePath());
    }

    public static final Parcelable.Creator<LocalFile> CREATOR = new Parcelable.Creator<LocalFile>() {

        public LocalFile createFromParcel(Parcel in) {
            return new LocalFile(in);
        }

        public LocalFile[] newArray(int size) {
            return new LocalFile[size];
        }
    };

    private LocalFile(Parcel in) {
        this(in.readString());
    }
}
