<?php
/**
 * クライアントからの要求を提供するHTTPリクエスト、
 * クライアントへの応答を送信する際の処理を行うHTTPレスポンス
 * それぞれで使用するデータを保持するクラスです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'util'.DIRECTORY_SEPARATOR.'CharUtility.class.php');
class spider_HttpRequest {
	/** Attributes			*/
	var $attribute_array	= array();
	/** Errors				*/
	var $errors				= array();
	/** Global Errors		*/
	var $global_errors		= array();
	/** Response Headers	*/
	var $headers			= array();
	/** Response Body		*/
	var $response_body		= null;
	/** Response File Path	*/
	var $response_file_path	= null;
	/** Redirect To URL		*/
	var $redirect_url		= null;
	/** Attribute Prefix	*/
	var $attribute_prefix	= null;

	/**
	 * コンストラクタ
	 */
	function spider_HttpRequest() {
		$this->attribute_array	= array();
		$this->errors			= array();
	}
	/**
	 * 属性を設定します。
	 * @param $key 属性名
	 * @param $value 属性値
	 */
	function setAttribute( $key, & $value ) {
		$reg_key		= $key;
		$callstack		= debug_backtrace();
		$caller_file	= $callstack[0]['file'];
		if( strpos($caller_file,DIR_PATH_LIB) !== false
			&& strpos($caller_file,DIR_PATH_LIB.DIRECTORY_SEPARATOR.'spider') === false ) {
			// 呼び出し元がlib内のファイルの場合
			$lib_uri		= str_replace(DIR_PATH_LIB,'',$caller_file);
			$caller_class	= preg_replace('/^_/','',str_replace('.class.php','',str_replace(DIRECTORY_SEPARATOR,'_',$lib_uri)));
			$caller_prefix	= str_replace('_','.',$caller_class);
			$package_prefix	= preg_replace('/\\.[^\\.]+$/','',$caller_prefix);
			if( preg_match('/^'.CharUtility::escape_regx_str($caller_prefix).'/',$key) == 0
				&& preg_match('/^'.CharUtility::escape_regx_str($package_prefix).'/',$key) == 0
			) {
				// パッケージ名もクラス名も属性名に含まれないならクラスプレフィックスつけて登録
				$reg_key	= $caller_prefix.'.'.$reg_key;
			}
		} else {
			// lib内でない場合、下位互換の為、$GLOBALSにも登録する
			$reg_key	= 'page.'.$key;
			$GLOBALS[$reg_key]	= $value;
			$GLOBALS[$key]		= $value;
		}
		if( !is_null( $this->attribute_prefix ) && strlen($this->attribute_prefix) > 0 ) {
			$reg_key	= $this->attribute_prefix.'.'.$reg_key;
		}
		$this->attribute_array[$reg_key]	= $value;
		$this->attribute_array[$key]		= $value;
	}
	/**
	 * 指定キーの属性を取得します。
	 * @param $key 属性名
	 */
	function getAttribute( $key ) {
		$ref	= & $this->attribute_array[$key];
		return $ref;
	}
	/**
	 * 指定キーの性がセットされたか確認します
	 */
	function existAttribute( $key ) {
		return array_key_exists( $key, $this->attribute_array );
	}
	/**
	 * エラーメッセージを追加します。
	 * @param $message エラーメッセージ
	 */
	function addError( $message ) {
		array_push( $this->errors, $message );
	}
	/**
	 * エラーがあるか確認します。
	 * @return true:エラーあり、false:それ以外
	 */
	function isError() {
		if( count( $this->errors ) > 0 ) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * グローバルエラーを追加します
	 */
	function addGlobalError( $message ) {
		array_push( $this->global_errors, $message );
	}
	/**
	 * レスポンスヘッダを設定します
	 */
	function setResponseHeader( $key, $value ) {
		$this->headers[$key]	= $value;
	}
	/**
	 * レスポンスボディを設定します
	 */
	function setResponseBody( $body ) {
		$this->response_body	= $body;
	}
	/**
	 * レスポンスボディをファイルパスで設定します。
	 */
	function setResponseFile( $file_path ) {
		$this->response_file_path	= $file_path;
	}
	/**
	 * リダイレクト先を設定します
	 */
	function redirectTo($url) {
		$this->redirect_url	= $url;
	}
}
?>
