<?php
/**
 * すべてのモジュールのベースクラスです。
 * モジュールはすべて本クラスのサブクラスになります。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class ModuleBase {
	var $controller_object;
	var $http_output_object;
	var $require_module_array	= array();
	var $post_module_array		= array();
	/**
	 * コンストラクタ
	 */
	function ModuleBase() {
	}
	/**
	 * モジュールを実行します。
	 * このメソッドをオーバーライドすることにより、モジュールが実行されます。
	 * @param $request 
	 */
	function execute( & $request ) {
	}
	/**
	 * モジュールの後処理を行います。
	 * このメソッドをオーバーライドすることにより、モジュールの後処理として実行されます。
	 * @param $request 
	 */
	function post_process( & $request ) {
	}
	/**
	 * 本モジュールを実行するのに事前に実行する必要があるモジュール名の配列を取得します。
	 */
	function get_require_module_array() {
		return $this->require_module_array;
	}
	/**
	 * 本モジュールを実行した後に必ず実行する必要があるモジュール名配列を取得します。
	 */
	function get_post_module_array() {
		return $this->post_module_array;
	}
	/**
	 * メールレポートを送信します。
	 */
	function report_mailto($subject,$message,$mailto=null) {
		$mailto_addresses	= array();
		if( is_null( $mailto ) || strlen(trim($mailto)) == 0 ) {
			if( !is_array( $GLOBALS['MAIL_SYSTEM_REPORT_TO'] ) ) {
				$this->error( "mailto:no defined:" . $subject . ":" . $message );
				return false;
			} else {
				$mailto_addresses	= $GLOBALS['MAIL_SYSTEM_REPORT_TO'];
			}
		} else {
			array_push($mailto_addresses, $mailto);
		}
		if( $send_object = $this->get_system_mailer() ) {
			// 送信
			foreach( $mailto_addresses as $address ) {
				$result	= $send_object->send( $address, MAIL_SYSTEM_SUBJECT_PREFIX.$subject, $message,
					MAIL_SYSTEM_FROM_NAME.' <'.MAIL_SYSTEM_FROM_ADDRESS.'>', MAIL_SYSTEM_REPLYTO, MAIL_SYSTEM_RETURN );
				if( $result ) {
					$this->report( "mailto:" . $address . ":" . $subject . ":" . $message );
				}
			}
			return true;
		}
		$this->error( "mailto:" . $mailto . ":" . $subject . ":" . $message );
		return false;
	}
	/**
	 * システム設定された値でメール送信オブジェクトを作成して取得します。
	 */
	function get_system_mailer() {
		if( defined('MAIL_METHOD') ) {
			require_once( dirname(dirname(__FILE__))
				. DIRECTORY_SEPARATOR . "util"
				. DIRECTORY_SEPARATOR . "Mail.class.php" );
			// 送信オプション
			$params		= array();
			// 送信方法の決定
			$class_name	= 'PHP';
			if( preg_match('/^[sS][mM][tT][pP]$/',MAIL_METHOD) > 0 ) {
				$class_name	= 'SMTP';
				$params		= array(
					'smtp_host'		=> MAIL_SMTP_HOST,
					'smtp_port'		=> MAIL_SMTP_PORT,
					'smtp_auth'		=> MAIL_SMTP_AUTH,
					'smtp_auth_user'	=> MAIL_SMTP_USER,
					'smtp_auth_pass'	=> MAIL_SMTP_PASS
				);
			} else if( preg_match('/^[sS][eE][nN][dD][mM][aA][iI][lL]$/',MAIL_METHOD) > 0 ) {
				$class_name	= 'SendMail';
				$params		= array('sendmail_path'=>MAIL_SENDMAIL_PATH);
			}
			// 送信オブジェクト作成
			$send_object	= util_Mail::get_instance( $class_name, $params );
			if( $send_object === false ) {
				return false;
			} else {
				return $send_object;
			}
		} else {
			return false;
		}
	}
	/**
	 * ログを出力します。
	 * @param $message ログメッセージ
	 * @param $log_level 出力するログのレベル
	 */
	function write_log( $message, $log_level='info' ) {
		$log_level	= 3;
		if( defined('SYSTEM_LOG_LEVEL') && is_numeric(SYSTEM_LOG_LEVEL)
			&& preg_match('/^[0-4]$/',SYSTEM_LOG_LEVEL) > 0 ) {
			$log_level	= SYSTEM_LOG_LEVEL;
		} else if( defined('MODE_LOG') && is_numeric(MODE_LOG)
			&& preg_match('/^[0-4]$/',MODE_LOG) > 0 ) {
			$log_level	= MODE_LOG;
		} else {
			$log_level	= 3;
		}
		if( $log_level == 4 && $log_level != 'fatal' ) {
			return true;
		} else if ( $log_level == 3
			&& $log_level != 'info' && $log_level != 'fatal' ) {
			return true;
		} else if ( $log_level == 2
			&& $log_level != 'error' && $log_level != 'info'
			&& $log_level != 'fatal' ) {
			return true;
		} else if ( $log_level == 1
			&& $log_level != 'report' && $log_level != 'error'
			&& $log_level != 'info' && $log_level != 'fatal' ) {
			return true;
		}
		// ログファイル名の決定
		$log_file_path	= DIR_PATH_LOG
			. DIRECTORY_SEPARATOR . "sp_module"
		;
		if( !file_exists( $log_file_path ) ) {
			mkdir( $log_file_path, 0777 );
			chmod( $log_file_path, 0777 );
		}
		if( strlen(trim($log_level)) > 0 ) {
			$log_file_path	.= DIRECTORY_SEPARATOR . trim($log_level)
				. "_" . date('Y_m') . ".log";
		} else {
			$log_file_path	.= DIRECTORY_SEPARATOR
				. "info_" . date('Y_m') . ".log";
		}
		if( strlen( $log_file_path ) > 2 && !file_exists($log_file_path) ) {
			touch( $log_file_path, 0666 );
			chmod( $log_file_path, 0666 );
		}
		$message	= str_replace( "\r\n", "\n", $message );
		$message	= str_replace( "\r", "\n", $message );
		$message	= str_replace( "\n", " ", $message );
		error_log(
			"[". date('Y-m-d H:i:s')."]"
			."[".get_class($this)."] "
			.$message
			. "\t" . $_SERVER['REMOTE_ADDR']
			. "\t" . $_SERVER['REMOTE_HOST']
			. "\t" . $_SERVER['HTTP_USER_AGENT']
			. "\n"
			, 3, $log_file_path );
		return true;
	}
	/**
	 * Infoレベルのログを出力します。
	 * @param $message ログメッセージ
	 */
	function info($message){
		$this->write_log( $message, 'info' );
	}
	/**
	 * Reportレベルのログを出力します。
	 * @param $message ログメッセージ
	 */
	function report($message){
		$this->write_log( $message, 'report' );
	}
	/**
	 * Errorレベルのログを出力します。
	 * @param $message ログメッセージ
	 */
	function error($message){
		$this->write_log( $message, 'error' );
	}
	/**
	 * Fatalレベルのログを出力します。
	 * @param $message ログメッセージ
	 */
	function fatal($message){
		$this->write_log( $message, 'fatal' );
	}
	/**
	 * Debugレベルのログを出力します。
	 * @param $message ログメッセージ
	 */
	function debug($message){
		$this->write_log( $message, 'debug' );
	}
}
?>
