<?php
/**
 * HTML用変換タグ：setAttributeを実行するクラス
 * 
 * {set:[新たに登録する属性名] [属性名]->[メンバ名]}
 * {set:[新たに登録する属性名] [属性名][配列添え字]}
 * 
 * と指定することでオブジェクトや配列の中の値を属性として新たに設定することができます。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.01
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_SetAttribute extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_SetAttribute() {
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		$vars_tags_aray			= array();
		preg_match_all( '/\\{set\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER );
		foreach ( $vars_tags_aray as $vars_tags ) {
			foreach ( $vars_tags as $vars_tag ) {
				$var_name	= preg_replace( '/\\{set\\:/','', $vars_tag );
				$var_name	= preg_replace( '/\\}$/','', $var_name );
				$var_name	= trim( $var_name );
				list( $var_name, $var_value)	= explode( ' ', $var_name );
				$var_name	= trim( $var_name );
				$var_value	= trim( $var_value );
				if( strlen(trim($var_name)) > 0 && strlen(trim($var_value)) > 0 ) {
					// 名前と値を両方指定されている場合のみ変換
					// 登録属性名
					$var_name	= trim( $var_name );
					if( ( preg_match('/^"/',$var_name) > 0 && preg_match('/"$/',$var_name) > 0 )
						|| ( preg_match('/^\'/',$var_name) > 0 && preg_match('/\'$/',$var_name) > 0 )
					) {
						$var_name	= substr($var_name,1,strlen($var_name)-2);
					}
					$rep_string = "<?php ";
					if( preg_match('/^\\".+?\\"$/',$var_value) || preg_match('/^\\\'.+?\\\'$/',$var_value) ) {
						// 値がクォーテーションで囲まれている場合は中の値をそのまま登録する
						$rep_string .= '$tmp='.$var_value.'; ';
						$rep_string .= '$request_object->setAttribute( "' . $var_name . '",$tmp ); ';
						$rep_string .= '$GLOBALS["' . $var_name . '"] =$tmp; ';
					} else {
						// 値がクォーテーションで囲まれていない場合は、スコープから変数を探して登録
						if( preg_match('/\\:\\:/',$var_value) > 0 ) {
							// コロン二つがつく場合はオブジェクトかハッシュの属性自動判別
							list( $obj_name, $at_name )		= explode('::',$var_value);
							$rep_string .= '$tmp=$request_object->getAttribute( "' . $obj_name . '" ); ';
							$rep_string	.= '$type=gettype($tmp); ';
							if ( strlen(trim($at_name)) > 0 ) {
								$rep_string	.= 'if(\'array\'==$type) { ';
								$rep_string	.= '$tmp=$tmp[\''.$at_name.'\'];';
								$rep_string	.= ' } ';
								$rep_string	.= 'if(\'object\'==$type) { $tmp=$tmp->'.$at_name.'; } ';
							}
						} else if( preg_match('/\\->/',$var_value) > 0 ) {
							// オブジェクト指定子の場合はオブジェクトのメソッドまたはメンバ値である
							list( $obj_name, $member_strings )	= explode('->',$var_value);
							$rep_string .= '$tmp=$request_object->getAttribute( "' . $obj_name . '" ); ';
							$rep_string	.= '$type=gettype($tmp); ';
							$member_strings	= trim($member_strings);
							if( strlen($member_strings) > 0 ) {
								if( preg_match('/\\(/',$member_strings) > 0 && preg_match('/\\)$/',$member_strings) > 0 ) {
									// 開始括弧があり、閉じ括弧で終了しているならメソッドの引数部分を確認
									list( $method_name, $method_param_strings )	= explode('(',$member_strings );
									list( $method_param_strings )				= explode(')',$method_param_strings );
									$method_param_strings						= trim( $method_param_strings );
									$method_param_tmp_array						= explode(',',$method_param_strings);
									$method_param_array							= array();
									foreach( $method_param_tmp_array as $param ) {
										$param	= trim( $param );
										if( strlen( $param ) > 0 ) {
											if( ( preg_match('/^"/',$param) > 0 && preg_match('/"$/',$param) > 0 )
												|| ( preg_match('/^\'/',$param) > 0 && preg_match('/\'$/',$param) > 0 )
											) {
												// シングルクォートかダブルクォートで囲まれているなら固定文字列
												array_push( $method_param_array, $param );
											} else if( is_numeric($param) ){
												// 数値ならそのまま登録
												array_push( $method_param_array, $param );
											} else {
												// 文字列でないなら属性から取得
												$strmp	= '$request_object->getAttribute( "' . $param . '" ); ';
												array_push( $method_param_array, $strmp );
											}
										}
									}
									$rep_string	.= 'if(\'object\'==$type) { $tmp=$tmp->'.$method_name.'('.implode(',',$method_param_array).'); } ';
								} else {
									// 開始括弧も閉じ括弧もないならメンバ変数として処理
									$rep_string	.= 'if(\'object\'==$type) { $tmp=$tmp->'.$member_strings.'; } ';
								}
							}
						} else if( preg_match('/\\[/',$var_value) > 0 && preg_match('/\\[/',$var_value) > 0 ) {
							// 開始大括弧と閉じ大括弧があるなら配列・ハッシュと判断する
							list( $hash_name, $hash_key_strings )	= explode('[',$var_value );
							$rep_string .= '$tmp=$request_object->getAttribute( "' . $hash_name . '" ); ';
							$rep_string	.= '$type=gettype($tmp); ';
							list( $hash_key_strings )				= explode(']',$hash_key_strings );
							$hash_key_strings						= trim( $hash_key_strings );
							if(  preg_match('/^\\".+?\\"$/',$hash_key_strings) || preg_match('/^\\\'.+?\\\\\'$/',$hash_key_strings) ){
								// キー文字列がクォートされているなら文字列としてそのまま利用
								$rep_string	.= 'if(\'array\'==$type) { $tmp=$tmp['.$hash_key_strings.']; } ';
							} else if( is_numeric($hash_key_strings) ) {
								// キー文字列が数値ならそのまま利用
								$rep_string	.= 'if(\'array\'==$type) { $tmp=$tmp['.$hash_key_strings.']; } ';
							} else {
								// キー文字列が数字でなくクォートされていないなら属性から取得
								if( preg_match('/\\:\\:/',$hash_key_strings) > 0 ) {
									// コロン二つがつく場合はオブジェクトかハッシュの属性自動判別
									list( $key_object_name, $key_at_name )		= explode('::',$hash_key_strings);
									$rep_string .= '$tmp_key=$request_object->getAttribute( "' . $key_object_name . '" ); ';
									$rep_string	.= '$type_key=gettype($tmp_key); ';
									if ( strlen(trim($key_at_name)) > 0 ) {
										$rep_string	.= 'if(\'array\'==$type_key) { $tmp_key=$tmp_key[\''.$key_at_name.'\']; } ';
										$rep_string	.= 'if(\'object\'==$type_key) { $tmp_key=$tmp_key->'.$key_at_name.'; } ';
										$rep_string	.= 'if(\'array\'==$type) { $tmp=$tmp[$tmp_key]; } ';
									}
								} else {
									// とりあえず配列キーではメソッド呼び出しはできない仕様。その他の場合はそのままgetAttribute
									$hash_key_strings	= '$request_object->getAttribute("'.$hash_key_strings.'")';
									$rep_string	.= 'if(\'array\'==$type) { $tmp=$tmp['.$hash_key_strings.']; } ';
								}
							}
						} else {
							// 単体文字列なら属性から取得
							$rep_string .= '$tmp = $request_object->getAttribute( "' . $var_value . '" ); ';
						}
						$rep_string .= '$request_object->setAttribute( "' . $var_name . '", $tmp ); ';
						$rep_string .= '$GLOBALS["' . $var_name . '"] =$tmp; ';
					}
					$rep_string .= " ?>";
					$result_strings = str_replace( $vars_tag, $rep_string, $result_strings );
				} else {
					// 名前か値どちらかがカラ文字の場合は変換しない
				}
			}
		}
		
		// presetタグの機能追加
		if( preg_match_all( '/\\{preset\\:[^\\}]*?\\}/'
			, $result_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$option_strings	= preg_replace( '/\\{preset\\:/','', $target );
					$option_strings	= preg_replace( '/\\}/','', $option_strings );
					$option_strings	= trim($option_strings);
					if( strpos($option_strings,' ') !== false ) {
						// 空白が存在するなら分割して復元
						$option_array	= $this->splitOptionBySpace( $option_strings );
						if( count($option_array) >= 2 ) {
							// パラメータが2つ以上ならモジュール実行前コードを追加
							$this->createPresetCode( $build_information, $option_array );
							// タグ行の削除
							$result_strings = str_replace( "\n".$target."\n", "", $result_strings );
							$result_strings = str_replace( $target, "", $result_strings );
						} else {
							// 空白が存在しないなら使い方が違うのでエラーメッセージを表示する
							$result_strings = str_replace( $target, "[preset tag requre 2 parameters! ".$target."]", $result_strings );
						}
					} else {
						// 空白が存在しないなら使い方が違うのでエラーメッセージを表示する
						$result_strings = str_replace( $target, "[preset tag requre 2 parameters! ".$target."]", $result_strings );
					}
				}
			}
		}
	}
	/**
	 * presetタグのパラメータを受け取って実行前コードを作成します
	 */
	function createPresetCode( &$build_information, $param_array ) {
		$process_code	= '';
		if( count( $param_array ) >= 2 ) {
			$name			= array_shift( $param_array );
			if( preg_match('/^\\\'[^\\\']+\\\'$/',$name) > 0 ) {
				$name			= preg_replace('/^\\\'/','',$name);
				$name			= preg_replace('/\\\'$/','',$name);
			}
			if( preg_match('/^\\"[^\\\']+\\"$/',$name) > 0 ) {
				$name			= preg_replace('/^\\"/','',$name);
				$name			= preg_replace('/\\"$/','',$name);
			}
			$value			= array_shift( $param_array );
			if( preg_match('/^\\\'[^\\\']+\\\'$/',$value) > 0 ) {
				$value			= preg_replace('/^\\\'/','',$value);
				$value			= preg_replace('/\\\'$/','',$value);
			}
			if( preg_match('/^\\"[^\\\']+\\"$/',$value) > 0 ) {
				$value			= preg_replace('/^\\"/','',$value);
				$value			= preg_replace('/\\"$/','',$value);
			}
			$var_name		= str_replace('.','_',$name);
			$process_code	.= '$'.$var_name.' = $request_object->getAttribute("'.$name.'");'."\n";
			$process_code	.= 'if( is_array($'.$var_name.') ) { '."\n";
			$process_code	.= 'array_push( $'.$var_name.', "'.$value.'" );'."\n";
			$process_code	.= '$request_object->setAttribute("'.$name.'",$'.$var_name.' );'."\n";
			$process_code	.= '} else if( is_null($'.$var_name.') || strlen($'.$var_name.') == 0 ) { '."\n";
			$process_code	.= '$'.$var_name.' = "'.$value.'";'."\n";
			$process_code	.= '$request_object->setAttribute("'.$name.'",$'.$var_name.' );'."\n";
			$process_code	.= '} else {'."\n";
			// objectの場合の検討..現状オブジェクトが登録済みの場合は上書きしない(あり得ないので)
			$process_code	.= '}'."\n";
			// ビルド情報に実行コードを追加
			if( !isset($build_information->preview_process_hash)
				|| !is_array($build_information->preview_process_hash) ){
				$build_information->preview_process_hash	= array();
			}
			if( !isset($build_information->preview_process_hash[$this->priority])
				|| !is_array($build_information->preview_process_hash[$this->priority]) ){
				$build_information->preview_process_hash[$this->priority]	= array();
			}
			array_push( $build_information->preview_process_hash[$this->priority], $process_code );
			return true;
		} else {
			return false;
		}
	}
}
?>