<?php
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'functions.inc.php' );
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'BuildInformation.class.php' );
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'Builder.class.php');
require_once(dirname(dirname( __FILE__ )).DIRECTORY_SEPARATOR.'util'.DIRECTORY_SEPARATOR.'LockProcess.class.php' );
/**
 * HTTP出力を行うクラスです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_HttpOutput {

	/**
	 * コンストラクタ
	 * @param $template_foler_path テンプレートファイルのルートディレクトリ
	 */	
	function spider_HttpOutput() {
	}
	/**
	 * リクエストの出力
	 * @param $controller モジュールを実行するspider_Controllerオブジェクト
	 * @param $request_object spider_HttpRequestオブジェクト
	 */
	function output( $controller, & $request ) {

		// 互換性
		$request_object				= & $request;
		
		// ビルド情報クラスの作成
		$build_information_object	= new spider_BuildInformation();
		
		// ユーザーエージェント分類をリクエストにセット
		$request->setAttribute('spider.access_agent_class',$build_information_object->agent_class);
		
		// ビルドファイルパスを取得
		$build_file_path	= $build_information_object->getAgentPageBuildFilePath();
		$build_confirm_path	= $build_file_path.'.build.php';
		
		// 指定ファイルに対してロックオブジェクト作成
		$bin_lock_name		= str_replace('/','_S_',str_replace(DIRECTORY_SEPARATOR,'_S_',$build_information_object->execute_file_path));
		$lock_obj			= new util_LockProcess($bin_lock_name);

		// ファイルとテンプレートの更新を確認
		$build				= false;
		if( file_exists( $build_confirm_path ) ) {
			// ビルド確認ファイルが存在するなら実行してビルド済みファイルが古くないか確認
			require_once( $build_confirm_path );
			if( $build ) {
				// ビルドファイルが古いならビルドファイルを削除
				if( $lock_obj->lock() ) {
					if( file_exists($build_file_path) ) {
						@unlink( $build_file_path );
					}
					if( file_exists($build_confirm_path) ) {
						@unlink( $build_confirm_path );
					}
				} else {
					$lock_obj->release();
					$this->exitWithCoreError();
				}
			} else if( $lock_obj->wait() ) {
				require_once( $build_file_path );
				return;
			} else {
				$this->exitWithCoreError();
			}
		} else if( file_exists( $build_file_path ) ) {
			// ビルド確認ファイルが存在しないならビルドファイルも削除する
			if( $lock_obj->lock() ) {
				if( file_exists($build_file_path) ) {
					@unlink( $build_file_path );
				}
			} else {
				$lock_obj->release();
				$this->exitWithCoreError();
			}
		} else {
			if( $lock_obj->lock() ) {
				if( file_exists($build_file_path) ) {
					@unlink( $build_file_path );
				}
				if( file_exists($build_confirm_path) ) {
					@unlink( $build_confirm_path );
				}
			} else {
				$lock_obj->release();
				$this->exitWithCoreError();
			}
		}

		// 実行ファイル作成オブジェクト
		$builder_object	= new spider_Builder();
		
		// 実行ファイル作成
		$builder_object->createBinFile( $build_information_object );
		$lock_obj->release();
		
		// 実行ファイル実行
		require( $build_file_path );

		return;
	}
	/**
	 * コアエラーが起こった場合にエラーメッセージを出力して終了します。
	 */
	function exitWithCoreError() {
		spider_exitWithCoreError('Core Error: 現在アクセスが非常に混雑しています。'
			.'しばらくたってからもう一度アクセスしてください。');
	}
}
?>