<?php
/*
 * グローバル関数定義ファイル
 * spiderで利用するグローバル関数を定義するファイルです
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
/**
 * spiderに必要なディレクトリとファイルのパーミッションを確認します
 * @return エラーメッセージ配列
 */
function spider_is_avairable_permittion() {
	$errors	= array();
	if( !file_exists(DIR_PATH_LIB) ) {
		array_push( $errors, 'ライブラリディレクトリがありません。' );
	}
	if( !file_exists(DIR_PATH_TEMPLATES) ) {
		array_push( $errors, 'テンプレートディレクトリがありません。' );
	}
	
	if( !file_exists(DIR_PATH_WORK) ) {
		array_push( $errors, ''.DIR_NAME_WORK.'ディレクトリがありません。' );
	} else if( !is_writable(DIR_PATH_WORK) ){
		array_push( $errors, 'ワークディレクトリが書き込み不能になっています。' );
	} else {
		if( !file_exists(DIR_PATH_BIN) ) {
			if( @mkdir(DIR_PATH_BIN,0777) ) {
				@chmod(DIR_PATH_BIN,0777);
			} else {
				array_push( $errors, 'ビルドファイル保存ディレクトリの作成に失敗しました。' );
			}
		} else if( !is_writable(DIR_PATH_BIN) ){
			array_push( $errors, 'ビルドファイル保存ディレクトリが書き込み不能になっています。' );
		}
		if( !file_exists(DIR_PATH_LOCK) ) {
			if( @mkdir( DIR_PATH_LOCK, 0777 ) ) {
				@chmod( DIR_PATH_LOCK, 0777 );
			} else {
				array_push( $errors, 'プロセスロックディレクトリの作成に失敗しました。' );
			}
		} else if( !is_writable(DIR_PATH_LOCK) ){
			array_push( $errors, 'プロセスロックディレクトリが書き込み不能になっています。' );
		}
		if( !file_exists(DIR_PATH_TMP) ) {
			if( @mkdir( DIR_PATH_TMP, 0777 ) ) {
				@chmod( DIR_PATH_TMP, 0777 );
			} else {
				array_push( $errors, '一時ディレクトリ作成に失敗しました。' );
			}
		} else if( !is_writable(DIR_PATH_TMP) ){
			array_push( $errors, '一時ディレクトリが書き込み不能になっています。' );
		}
		if( !file_exists(DIR_PATH_CACHE) ) {
			if( @mkdir( DIR_PATH_CACHE, 0777 ) ) {
				@chmod( DIR_PATH_CACHE, 0777 );
			} else {
				array_push( $errors, 'キャッシュディレクトリ作成に失敗しました。' );
			}
		} else if( !is_writable(DIR_PATH_CACHE) ){
			array_push( $errors, 'キャッシュディレクトリが書き込み不能になっています。' );
		}
	}

	if( !file_exists(DIR_PATH_DATA) ) {
		array_push( $errors, 'データディレクトリがありません。' );
	} else if( !is_writable(DIR_PATH_DATA) ){
		array_push( $errors, 'データディレクトリが書き込み不能になっています。' );
	} else {
		if( !file_exists(DIR_PATH_LOG) ) {
			if( @mkdir( DIR_PATH_LOG, 0777 ) ) {
				@chmod( DIR_PATH_LOG, 0777 );
			} else {
				array_push( $errors, 'ログ保存ディレクトリ作成に失敗しました。' );
			}
		} else if( !is_writable(DIR_PATH_LOG) ){
			array_push( $errors, 'ログ保存ディレクトリが書き込み不能になっています。' );
		}
	}
	return $errors;
}
/**
 * コアエラーが発生した場合に出力して処理を終了します。
 */
function spider_exitWithCoreError($message) {
	header('Content-type: text/plain;charset=UTF-8');
	die('Core Error: '.$message);
}
/**
 * spiderにおけるセッションを開始します
 * セッションIDの重複を避けるため、生成したIDのセッションが存在するかどうか
 * 確認してからセッションIDを発行します
 * 新規セッション発行時にロックをかけるため通常のPHPセッションスタートする場合よりも
 * 多少のオーバーヘッドがあります。
 */
function spider_session_start() {
	// セッション名を確認
	$session_name	= session_name();
	// 送信されたセッションIDを取得
	$session_id		= trim($_COOKIE[$session_name]);
	if( is_null($session_id) || strlen($session_id) == 0 ) {
		$session_id	= trim($_GET[$session_name]);
		if( is_null($session_id) || strlen($session_id) == 0 ) {
			$session_id	= trim($_POST[$session_name]);
		}
	}
	// セッションIDが送信されていないならセッション開始していない
	// 独自にセッションIDを発行する
	if( is_null($session_id) || strlen($session_id) == 0 ) {
		if( spider_plock() ) {
			$session_id	= spider_create_session_id();
			$save_path	= session_save_path().DIRECTORY_SEPARATOR.'sess_'.$session_id;
			while( file_exists($save_path) ) {
				$session_id	= spider_create_session_id();
				$save_path	= session_save_path().DIRECTORY_SEPARATOR.'sess_'.$session_id;
			}
			session_id($session_id);
			session_start();
			$_SESSION['spider.session.initiated'] = serialize(true);
			spider_prelease();
		} else {
			return false;
		}
	} else {
		session_start();
		if (!isset($_SESSION['spider.session.initiated'])) {
			session_regenerate_id(true);
			$_SESSION['spider.session.initiated'] = serialize(true);
		}
	}
	return true;
}
/**
 * マイクロタイムスタンプを元にランダム文字列のセッションＩＤを生成します。
 */
function spider_create_session_id() {
	$mictime				= microtime();
	list( $msec, $sec )		= explode(' ', $mictime );
	$microtimestamp			= $sec . str_replace('0.','',$msec );
	$unique_num				=
		spider_get_random_string(2)
		.substr($microtimestamp,0,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,2,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,4,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,6,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,8,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,10,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,12,2)
		.spider_get_random_string(2)
		.substr($microtimestamp,14,2)
	;
	return $unique_num;
}
/**
 * ランダム文字列を作成します
 */
function spider_get_random_string( $length = 32 ) {
	$str_array	= array(
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
		'A','B','C','D','E','F','G','H','I','J',
		'K','L','M','N','O','P','Q','R','S','T',
		'U','V','W','X','Y','Z',
		'a','b','c','d','e','f','g','h','i','j',
		'k','l','m','n','o','p','q','r','s','t',
		'u','v','w','x','y','z',
		'0','1','2','3','4','5','6','7','8','9',
	);
	$keys	= array_rand( $str_array, $length );
	$string	= '';
	foreach( $keys as $key ) {
		$string	.= $str_array[$key];
	}
	return $string;
}
/**
 * フォルダ作成ベースの処理ロック
 */
function spider_plock(){
	// 現在ロックがかかっているか確認する
	$lock_path	= DIR_PATH_LOCK.DIRECTORY_SEPARATOR.'spider.orgsession.mainlock';
	if( spider_pwait() ) {
		// ロックがかかっていないならロックディレクトリ作成
		mkdir( $lock_path, 0777 );
		chmod( $lock_path, 0777 );
		return true;
	} else {
		return false;
	}
}

/**
 * 指定名のロックを解除します。
 */
function spider_prelease(){
	$lock_path	= DIR_PATH_LOCK.DIRECTORY_SEPARATOR.'spider.orgsession.mainlock';
	if( is_dir( $lock_path ) ){
		rmdir( $lock_path );
	}
	return true;
}
/**
 * ロックが解除されるまで待機します
 */
function spider_pwait() {
	$lock_path	= DIR_PATH_LOCK.DIRECTORY_SEPARATOR.'spider.orgsession.mainlock';
	$loop_count	= 0;
	while( true ) {
		$loop_count++;
		if( $loop_count > 300 ){
			return false;
		} else if ( !is_dir( $lock_path ) ) {
			return true;
		} else if ( filemtime($lock_path) + 30 < time() ){
			spider_prelease();
			return true;
		} else {
			usleep(500);
			continue;
		}
	}
}
/**
 * CSVデータラインを配列にして返します
 */
function convert_csv_columns( $strings ) {
	$strings		= str_replace("\r\n","\n",$strings);
	$strings		= str_replace("\r","\n",$strings);
	$columns		= explode(',',$strings);
	$regist_columns	= array();
	$column_value	= '';
	// カラム値を""と,の関係維持して正確に分割する
	foreach( $columns as $val ) {
		if( strlen($column_value) > 0 ) {
			$column_value	.= ','.$val;
		} else {
			$column_value	.= $val;
		}
		$quote_count	= substr_count( $column_value, '"' );
		if( $quote_count % 2 != 0 ) {
			// クォータ数が偶数でない場合はカラムデータが完結していないので次の行へ
		} else {
			// 完結している場合はカラムとして処理
			if( preg_match('/^"/',$column_value) > 0 && preg_match( '/"$/', $column_value ) > 0 ) {
				$column_value	= preg_replace('/^"/','',$column_value );
				$column_value	= preg_replace('/"$/','',$column_value );
				$column_value	= preg_replace('/""/','"',$column_value );
			}
			$column_value			= mb_convert_kana($column_value,'KVa');
			array_push( $regist_columns, $column_value );
			$column_value	= '';
		}
	}
	return $regist_columns;
}
?>
