<?php
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグ:charsetタグクラス
 * 
 * {charset:[文字コード指定文字列]}で指定された文字コードでページを出力するよう変更します。
 * 
 * [文字コード指定文字列]にはPHPのmbstringによる文字コード指定方法を用いてください。
 * 例）Windows向けShift_JISの場合→SJIS-win
 * 
 * また出力時にHTMLタグ内の以下のメタタグ内の文字セットの書き換えも試みます。
 * <meta http-equiv="Content-type" content="text/html; charset=UTF-8">
 * 
 * 記述例）
 * {charset:SJIS-win}
 * 
 * ※本タグはテンプレート・ウィジェット・ページ全てあわせて1つのみ指定できます。
 * 複数のタグが記述されている場合、出力文字列の一番最後に記述されているcharset指定が有効になります。
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_tags_Charset extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Charset() {
		$this->priority	= 30;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		// charsetタグ内文字列
		$charset_strings	= '';
		if ( preg_match_all( '/\\{charset\\:[^\\}]*?\\}/'
				, $result_strings
				, $output_array
				, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$charset_strings	= preg_replace( '/\\{charset\\:/','', $target );
					$charset_strings	= preg_replace( '/\\}/','', $charset_strings );
					// 空行にならないよう前後が改行も削除
					$result_strings 	= str_replace( "\n".$target."\n", "", $result_strings );
					$result_strings 	= str_replace( $target, "", $result_strings );
					$charset_strings	= trim($charset_strings);
				}
			}
		} else {
			if ( $build_information->agent_class == 'default' ){
				$charset_strings	= 'UTF-8';
			} else {
				$charset_strings	= 'SJIS-win';
			}
		}

		$charset_array	= explode( " ", $charset_strings );
		// 最初の項は必ず文字コード
		$charset			= trim(array_shift($charset_array));
		$convert_kana		= '';
		$internal_charset	= 'UTF-8';
		$output_handler		= 'mb_output_handler';
		$detect_order		= 'UTF-8,EUC-JP,SJIS,SJIS-win,JIS,UTF-7';
		$language			= 'japanese';
		// 残りの項の解析
		foreach( $charset_array as $str ) {
			if( strlen(trim($str)) > 0 ) {
				list( $key, $val )	= explode('=',trim($str));
				$key	= trim($key);
				$val	= trim($val);
				if( strlen($val) == 0 ) {
					// 単一項目ならconvert_kanaと判断する（下位互換）
					$convert_kana	= $key;
				} else if( 'internal_charset' == $key ){
					$internal_charset	= $val;
				} else if( 'output_handler' == $key ) {
					$output_handler		= $val;
				} else if( 'convert_kana' == $key ) {
					$convert_kana		= $val;
				} else if( 'detect_order' == $key ) {
					$detect_order		= $val;
				} else if( 'language' == $key ) {
					$language			= $val;
				}
			}
		}
		// 互換の為creatorにも設定
		$build_information->output_charset		= $charset;
		$build_information->convert_kana		= $convert_kana;
		$build_information->output_handler		= $output_handler;
		$build_information->internal_charset	= $internal_charset;
		$build_information->detect_order		= $detect_order;
		$build_information->output_language		= $language;

		// 出力文字コード変換
		$out_code = "UTF-8";
		if ( 'SJIS' == $charset
			|| 'SJIS-win' == $charset ) {
			$out_code = 'Shift_JIS';
		} else if ( 'EUC-JP' == $charset ) {
			$out_code = 'EUC-JP';
		}
		$result_strings = str_replace(
			"content=\"text/html; charset=UTF-8\""
			, 'content="text/html; charset=' . $out_code . '"'
			, $result_strings );


		// 前処理の文字コードフラッシュコードを追加
		$process_code = "ob_start('".$output_handler."');\n";
		$process_code .= "ob_implicit_flush( false );\n";
		$process_code .= "mb_language('".$language."');\n";
		$process_code .= "mb_detect_order('".$detect_order."');\n";
		$process_code .= "mb_internal_encoding('".$internal_charset."');\n";
		if( !isset($build_information->preview_process_hash)
			|| !is_array($build_information->preview_process_hash) ){
			$build_information->preview_process_hash	= array();
		}
		if( !isset($build_information->preview_process_hash[$this->priority])
			|| !is_array($build_information->preview_process_hash[$this->priority]) ){
			$build_information->preview_process_hash[$this->priority]	= array();
		}
		array_push( $build_information->preview_process_hash[$this->priority], $process_code );
		
		// 表示文字列に対する処理実行コードを記述
		if( !isset($build_information->convert_view_process_hash)
			|| !is_array($build_information->convert_view_process_hash) ){
			$build_information->convert_view_process_hash	= array();
		}
		if( !isset($build_information->convert_view_process_hash[$this->priority])
			|| !is_array($build_information->convert_view_process_hash[$this->priority]) ){
			$build_information->convert_view_process_hash[$this->priority]	= array();
		}
		if( strlen( trim( $convert_kana ) ) > 0 ) {
			$process_code = '$outstr = mb_convert_kana( $outstr, "' . $convert_kana . '" );'."\n";
			array_push( $build_information->convert_view_process_hash[$this->priority], $process_code );
		} else if ( 'docomo' == $build_information->agent_class || 'docomo2' == $build_information->agent_class || 'softbank' == $build_information->agent_class || 'au' == $build_information->agent_class ) {
			$process_code = '$outstr = mb_convert_kana( $outstr, "kna" );'."\n";
			if( 'docomo2' == $build_information->agent_class ) {
				// ユーザーエージェントがdocomo2でボディがxml宣言で始まっているならヘッダー追加
				$process_code .= 'if( preg_match(\'/\\\\<\\\\?xml/\',$outstr) > 0 ){ '
					. 'header(\'Content-Type: application/xhtml+xml;charset=Shift_JIS\'); echo "\n";'."\n"
					. ' }'."\n"
				;
			}
			array_push( $build_information->convert_view_process_hash[$this->priority], $process_code );
		}
		
	}
}
?>