<?php
/**
 * 変換タグ HTMLファイル出力を指定する
 * 
 * {output-html}とテンプレート、ウィジェット、ページ内のどこかに記述することで
 * 実行されたURIのファイルと同じフォルダに同名で.htmlファイルを出力します。
 * 
 * 本タグ利用時には、ドキュメントルートフォルダ以下のフォルダ全てがWebサーバ実行ユーザにより
 * 書込み可能な状態である必要があります。
 * 
 * 有効なオプション）
 * lifetime=[ライフタイムを秒で指定]
 * 
 * 記述例）
 * {output-html:lifetime=300}
 * 前回のHTML出力から300秒を過ぎていた場合新たにHTMLファイルを出力しなおす
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_OutputHtml extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_OutputHtml() {
		$this->priority	= 999;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		// charsetタグ内文字列
		$output_option	= '';
		$is_exists		= false;
		if ( preg_match_all( '/\\{output\\-html[^\\}]*?\\}/'
				, $result_strings
				, $output_array
				, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$output_option	= preg_replace( '/\\{output\\-html/','', $target );
					$output_option	= trim(preg_replace( '/\\}/','', $output_option ));
					if( strlen($output_option) == 0 || preg_match('/^\\:/',$output_option) > 0 ) {
						// 文字がないか:から始まる場合はオプション指定なので変換実行
						$result_strings	= str_replace( $target, "", $result_strings );
						$output_option	= trim($output_option);
						$output_option	= preg_match('/^\\:/','',$output_option);
						$is_exists		= true;
					} else {
						// ：以外の文字が続く場合は違うタグなので処理しない
					}
				}
			}
		}
		
		// 存在するならHTML出力行を追加
		if( $is_exists ) {
			// オプションの整理
			$option_values	= explode(' ',$output_option);
			$option_hash	= array();
			foreach( $option_values as $option_value ) {
				$name	= $option_value;
				$value	= $option_value;
				if( preg_match('/\\=/',$option_value) > 0 ) {
					list( $name, $value )	= explode('=',$option_value);
					$name	= trim($name);
					$value	= trim($value);
				}
				$option_hash[$name]	= $value;
			}
			// HTMLファイルのライフタイム(sec)
			$lifetime	= 3600;
			if( isset($option_hash['lifetime'])
				&& preg_match('/^[0-9]{1-10}$/', $option_hash['lifetime'] ) > 0 ) {
				$lifetime	= $option_hash['lifetime'];
			}
			
			// コード追加
			$html_path		= preg_replace('/\\.php$/','.html',$build_information->execute_file_path);
			$html_path		= str_replace('"','\\"',$html_path);
			$html_path		= str_replace('\\','\\\\',$html_path);
			$process_code	= 'if( !file_exists("'.$html_path.'") || time() - filemtime("'.$html_path.'") > '.$lifetime.' ){'."\n";
				$process_code	.= '$fp = fopen("'.$html_path.'","w");'."\n";
				$process_code	.= 'if($fp){'."\n";
					$process_code	.= 'if (@flock($fp, LOCK_EX)) {'."\n";
						$process_code	.= 'fwrite($fp,$outstr);'."\n";
						$process_code	.= 'flock($fp, LOCK_UN);'."\n";
					$process_code	.= '}'."\n";
					$process_code	.= '@fclose( $fp );'."\n";
					$process_code	.= '@chmod( "'.$html_path.'", 0666 );'."\n";
				$process_code	.= '}'."\n";
			$process_code	.= '}'."\n";
			if( !isset($build_information->convert_view_process_hash)
				|| !is_array($build_information->convert_view_process_hash) ){
				$build_information->convert_view_process_hash	= array();
			}
			if( !isset($build_information->convert_view_process_hash[$this->priority])
				|| !is_array($build_information->convert_view_process_hash[$this->priority]) ){
				$build_information->convert_view_process_hash[$this->priority]	= array();
			}
			array_push( $build_information->convert_view_process_hash[$this->priority], $process_code );
		}
	}
}
?>